/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail;

import java.io.File;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryLockedException;
import org.openrdf.repository.base.RepositoryBase;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailException;
import org.openrdf.sail.SailLockedException;

public class SailRepository
extends RepositoryBase {
    private final Sail sail;

    public SailRepository(Sail sail) {
        this.sail = sail;
    }

    @Override
    public File getDataDir() {
        return this.sail.getDataDir();
    }

    @Override
    public void setDataDir(File dataDir) {
        this.sail.setDataDir(dataDir);
    }

    @Override
    protected void initializeInternal() throws RepositoryException {
        try {
            this.sail.initialize();
        }
        catch (SailLockedException e) {
            String l = e.getLockedBy();
            String r = e.getRequestedBy();
            String m = e.getMessage();
            throw new RepositoryLockedException(l, r, m, e);
        }
        catch (SailException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    @Override
    protected void shutDownInternal() throws RepositoryException {
        try {
            this.sail.shutDown();
        }
        catch (SailException e) {
            throw new RepositoryException("Unable to shutdown Sail", e);
        }
    }

    public Sail getSail() {
        return this.sail;
    }

    @Override
    public boolean isWritable() throws RepositoryException {
        try {
            return this.sail.isWritable();
        }
        catch (SailException e) {
            throw new RepositoryException("Unable to determine writable status of Sail", e);
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.sail.getValueFactory();
    }

    @Override
    public SailRepositoryConnection getConnection() throws RepositoryException {
        try {
            return new SailRepositoryConnection(this, this.sail.getConnection());
        }
        catch (SailException e) {
            throw new RepositoryException(e);
        }
    }

    public String toString() {
        return this.sail.toString();
    }
}

