/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryImplConfigBase;
import org.openrdf.repository.sail.config.ProxyRepositorySchema;

public class ProxyRepositoryConfig
extends RepositoryImplConfigBase {
    private String proxiedID;

    public ProxyRepositoryConfig() {
        super("openrdf:ProxyRepository");
    }

    public ProxyRepositoryConfig(String proxiedID) {
        this();
        this.setProxiedRepositoryID(proxiedID);
    }

    public final void setProxiedRepositoryID(String value) {
        this.proxiedID = value;
    }

    public String getProxiedRepositoryID() {
        return this.proxiedID;
    }

    @Override
    public void validate() throws RepositoryConfigException {
        super.validate();
        if (null == this.proxiedID) {
            throw new RepositoryConfigException("No id specified for proxied repository");
        }
    }

    @Override
    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        if (null != this.proxiedID) {
            graph.add(implNode, ProxyRepositorySchema.PROXIED_ID, ValueFactoryImpl.getInstance().createLiteral(this.proxiedID), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Graph graph, Resource implNode) throws RepositoryConfigException {
        super.parse(graph, implNode);
        try {
            Literal proxiedID = GraphUtil.getOptionalObjectLiteral(graph, implNode, ProxyRepositorySchema.PROXIED_ID);
            if (proxiedID != null) {
                this.setProxiedRepositoryID(proxiedID.getLabel());
            }
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }
}

