/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail.helpers;

import java.io.IOException;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.trig.TriGParser;
import org.openrdf.rio.turtle.TurtleUtil;

public class SPARQLUpdateDataBlockParser
extends TriGParser {
    private boolean allowBlankNodes = true;

    public SPARQLUpdateDataBlockParser() {
    }

    public SPARQLUpdateDataBlockParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return null;
    }

    private boolean checkGraphKeyword(boolean verifyOnly) throws IOException, RDFParseException, RDFHandlerException {
        boolean isGraphKeyword = false;
        int c = this.peek();
        if (c == 103 || c == 71) {
            StringBuilder sb = new StringBuilder(5);
            do {
                if ((c = this.read()) == -1 || TurtleUtil.isWhitespace(c)) {
                    this.unread(c);
                    break;
                }
                sb.append((char)c);
            } while (sb.length() < 5);
            isGraphKeyword = sb.toString().equalsIgnoreCase("GRAPH");
            if (verifyOnly || !isGraphKeyword) {
                this.unread(sb.toString());
            }
        }
        return isGraphKeyword;
    }

    @Override
    protected void parseGraph() throws IOException, RDFParseException, RDFHandlerException {
        int c;
        if (this.checkGraphKeyword(false)) {
            if (this.getContext() != null) {
                this.reportFatalError("nested named graph not allowed.");
            }
            this.skipWSC();
            c = this.read();
            int c2 = this.peek();
            if (c == 60 || TurtleUtil.isPrefixStartChar(c) || c == 58 && c2 != 45 || c == 95 && c2 == 58) {
                this.unread(c);
                Value value = this.parseValue();
                if (value instanceof Resource) {
                    this.setContext((Resource)value);
                } else {
                    this.reportFatalError("Illegal graph name: " + value);
                }
            } else {
                this.reportFatalError("Missing graph name.");
            }
        }
        if ((c = this.skipWSC()) == 123) {
            this.read();
            c = this.skipWSC();
        }
        if (c != 125) {
            this.parseTriples();
            c = this.skipWSC();
            while (c == 46) {
                this.read();
                c = this.skipWSC();
                if (c == 125 || c == -1) {
                    this.read();
                    this.setContext(null);
                    return;
                }
                if (this.checkGraphKeyword(true)) {
                    return;
                }
                this.parseTriples();
                c = this.skipWSC();
            }
        }
        if ((c = this.read()) == 125) {
            this.setContext(null);
        }
    }

    @Override
    protected Resource parseImplicitBlank() throws IOException, RDFParseException, RDFHandlerException {
        if (this.isAllowBlankNodes()) {
            return super.parseImplicitBlank();
        }
        throw new RDFParseException("blank nodes not allowed in data block");
    }

    @Override
    protected BNode parseNodeID() throws IOException, RDFParseException {
        if (this.isAllowBlankNodes()) {
            return super.parseNodeID();
        }
        throw new RDFParseException("blank nodes not allowed in data block");
    }

    public boolean isAllowBlankNodes() {
        return this.allowBlankNodes;
    }

    public void setAllowBlankNodes(boolean allowBlankNodes) {
        this.allowBlankNodes = allowBlankNodes;
    }
}

