/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation.config;

import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryFactory;
import org.openrdf.repository.config.RepositoryImplConfig;
import org.openrdf.repository.config.RepositoryRegistry;
import org.openrdf.repository.sail.config.RepositoryResolver;
import org.openrdf.repository.sail.config.RepositoryResolverClient;
import org.openrdf.sail.Sail;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailFactory;
import org.openrdf.sail.config.SailImplConfig;
import org.openrdf.sail.federation.Federation;
import org.openrdf.sail.federation.config.FederationConfig;

public class FederationFactory
implements SailFactory,
RepositoryResolverClient {
    public static final String SAIL_TYPE = "openrdf:Federation";
    private RepositoryResolver resolver;

    @Override
    public String getSailType() {
        return SAIL_TYPE;
    }

    @Override
    public SailImplConfig getConfig() {
        return new FederationConfig();
    }

    @Override
    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        assert (config instanceof FederationConfig);
        FederationConfig cfg = (FederationConfig)config;
        Federation sail = new Federation();
        for (RepositoryImplConfig member : cfg.getMembers()) {
            RepositoryFactory factory = (RepositoryFactory)RepositoryRegistry.getInstance().get(member.getType());
            if (factory == null) {
                throw new SailConfigException("Unsupported repository type: " + config.getType());
            }
            if (factory instanceof RepositoryResolverClient) {
                ((RepositoryResolverClient)((Object)factory)).setRepositoryResolver(this.resolver);
            }
            try {
                sail.addMember(factory.getRepository(member));
            }
            catch (RepositoryConfigException e) {
                throw new SailConfigException(e);
            }
        }
        sail.setLocalPropertySpace(cfg.getLocalPropertySpace());
        sail.setDistinct(cfg.isDistinct());
        sail.setReadOnly(cfg.isReadOnly());
        return sail;
    }

    @Override
    public void setRepositoryResolver(RepositoryResolver resolver) {
        this.resolver = resolver;
    }
}

