/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.sail.memory.model.MemLiteral;

public class IntegerMemLiteral
extends MemLiteral {
    private static final long serialVersionUID = -8121416400439616510L;
    private final BigInteger value;

    public IntegerMemLiteral(Object creator, BigInteger value) {
        this(creator, value, XMLSchema.INTEGER);
    }

    public IntegerMemLiteral(Object creator, BigInteger value, URI datatype) {
        this(creator, value.toString(), value, datatype);
    }

    public IntegerMemLiteral(Object creator, String label, BigInteger value, URI datatype) {
        super(creator, label, datatype);
        this.value = value;
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public BigInteger integerValue() {
        return this.value;
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this.value);
    }
}

