/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanList;
import it.unimi.dsi.fastutil.longs.AbstractLongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongList;
import it.unimi.dsi.fastutil.longs.AbstractLongListIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import it.unimi.dsi.util.LongBigList;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBitVector
extends AbstractBooleanList
implements BitVector {
    protected void ensureRestrictedIndex(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.length()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to length (" + this.length() + ")");
        }
    }

    protected void ensureIndex(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.length()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than length (" + this.length() + ")");
        }
    }

    public void set(int index) {
        this.set(index, true);
    }

    public void clear(int index) {
        this.set(index, false);
    }

    public void flip(int index) {
        this.set(index, !this.getBoolean(index));
    }

    @Override
    public void set(long index) {
        this.set(index, true);
    }

    @Override
    public void clear(long index) {
        this.set(index, false);
    }

    @Override
    public void flip(long index) {
        this.set(index, !this.getBoolean(index));
    }

    @Override
    public void fill(boolean value) {
        long i = this.length();
        while (i-- != 0L) {
            this.set(i, value);
        }
    }

    @Override
    public void fill(int value) {
        this.fill(value != 0);
    }

    @Override
    public void flip() {
        long i = this.length();
        while (i-- != 0L) {
            this.flip(i);
        }
    }

    @Override
    public void fill(long from, long to, boolean value) {
        BitVectors.ensureFromTo(this.length(), from, to);
        long i = to;
        while (i-- != from) {
            this.set(i, value);
        }
    }

    @Override
    public void fill(long from, long to, int value) {
        this.fill(from, to, value != 0);
    }

    @Override
    public void flip(long from, long to) {
        BitVectors.ensureFromTo(this.length(), from, to);
        long i = to;
        while (i-- != from) {
            this.flip(i);
        }
    }

    @Override
    public int getInt(long index) {
        return this.getBoolean(index) ? 1 : 0;
    }

    @Override
    public long getLong(long from, long to) {
        if (to - from > 64L) {
            throw new IllegalArgumentException("Range too large for a long: [" + from + ".." + to + ")");
        }
        long result = 0L;
        for (long i = from; i < to; ++i) {
            if (!this.getBoolean(i)) continue;
            result |= 1L << (int)(i - from);
        }
        return result;
    }

    @Override
    public boolean getBoolean(int index) {
        return this.getBoolean((long)index);
    }

    @Override
    public boolean removeBoolean(int index) {
        return this.removeBoolean((long)index);
    }

    @Override
    public boolean set(int index, boolean value) {
        return this.set((long)index, value);
    }

    @Override
    public void add(int index, boolean value) {
        this.add((long)index, value);
    }

    @Override
    public boolean removeBoolean(long index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean set(long index, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(long index, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long index, int value) {
        this.set(index, value != 0);
    }

    @Override
    public void add(long index, int value) {
        this.add(index, value != 0);
    }

    @Override
    public boolean add(boolean value) {
        this.add(this.length(), value);
        return true;
    }

    @Override
    public void add(int value) {
        this.add(value != 0);
    }

    @Override
    public BitVector append(long value, int k) {
        for (int i = 0; i < k; ++i) {
            this.add((value & 1L << i) != 0L);
        }
        return this;
    }

    @Override
    public BitVector append(BitVector bv) {
        long length = bv.length();
        long l = length - length % 64L;
        int i = 0;
        while ((long)i < l) {
            this.append(bv.getLong(i, i + 64), 64);
            i += 64;
        }
        if ((long)i < length) {
            this.append(bv.getLong(i, length), (int)(length - (long)i));
        }
        return this;
    }

    @Override
    public BitVector copy() {
        return this.copy(0L, this.size());
    }

    @Override
    public BitVector copy(long from, long to) {
        BitVectors.ensureFromTo(this.length(), from, to);
        long length = to - from;
        long l = length - length % 64L;
        long[] bits = new long[(int)((length + 64L - 1L) / 64L)];
        int i = 0;
        while ((long)i < l) {
            bits[i / 64] = this.getLong(from + (long)i, from + (long)i + 64L);
            i += 64;
        }
        if ((long)i < length) {
            bits[i / 64] = this.getLong(from + (long)i, to);
        }
        return LongArrayBitVector.wrap(bits, length);
    }

    @Override
    public BitVector fast() {
        return this.copy();
    }

    @Override
    public long count() {
        long c = 0L;
        long i = this.length();
        while (i-- != 0L) {
            c += (long)this.getInt(i);
        }
        return c;
    }

    @Override
    public long firstOne() {
        return this.nextOne(0L);
    }

    @Override
    public long lastOne() {
        return this.previousOne(this.length());
    }

    @Override
    public long firstZero() {
        return this.nextZero(0L);
    }

    @Override
    public long lastZero() {
        return this.previousZero(this.length());
    }

    @Override
    public long nextOne(long index) {
        long length = this.length();
        for (long i = index; i < length; ++i) {
            if (!this.getBoolean(i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousOne(long index) {
        long i = index;
        while (i-- != 0L) {
            if (!this.getBoolean(i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long nextZero(long index) {
        long length = this.length();
        for (long i = index; i < length; ++i) {
            if (this.getBoolean(i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousZero(long index) {
        long i = index;
        while (i-- != 0L) {
            if (this.getBoolean(i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long longestCommonPrefixLength(BitVector v) {
        long w1;
        long w0;
        long minLength = Math.min(this.length(), v.length());
        long l = minLength - minLength % 64L;
        int i = 0;
        while ((long)i < l) {
            w0 = this.getLong(i, i + 64);
            if (w0 != (w1 = v.getLong(i, i + 64))) {
                return i + Fast.leastSignificantBit(w0 ^ w1);
            }
            i += 64;
        }
        w0 = this.getLong(i, minLength);
        if (w0 != (w1 = v.getLong(i, minLength))) {
            return i + Fast.leastSignificantBit(w0 ^ w1);
        }
        return minLength;
    }

    @Override
    public BitVector and(BitVector v) {
        int i = Math.min(this.size(), v.size());
        while (i-- != 0) {
            if (v.getBoolean(i)) continue;
            this.clear(i);
        }
        return this;
    }

    @Override
    public BitVector or(BitVector v) {
        int i = Math.min(this.size(), v.size());
        while (i-- != 0) {
            if (!v.getBoolean(i)) continue;
            this.set(i);
        }
        return this;
    }

    @Override
    public BitVector xor(BitVector v) {
        int i = Math.min(this.size(), v.size());
        while (i-- != 0) {
            if (!v.getBoolean(i)) continue;
            this.flip(i);
        }
        return this;
    }

    @Override
    public int size() {
        long length = this.length();
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("The number of bits of this bit vector (" + length + ") exceeds Integer.MAX_INT");
        }
        return (int)length;
    }

    @Override
    public void size(int newSize) {
        this.length(newSize);
    }

    @Override
    public void clear() {
        this.length(0L);
    }

    @Override
    public BitVector replace(BitVector bv) {
        this.clear();
        long fullBits = bv.length() - bv.length() % 64L;
        for (long i = 0L; i < fullBits; i += 64L) {
            this.append(bv.getLong(i, i + 64L), 64);
        }
        if (bv.length() % 64L != 0L) {
            this.append(bv.getLong(fullBits, bv.length()), (int)(bv.length() - fullBits));
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BitVector)) {
            return false;
        }
        BitVector v = (BitVector)o;
        long length = this.length();
        if (length != v.length()) {
            return false;
        }
        while (length-- != 0L) {
            if (this.getBoolean(length) == v.getBoolean(length)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        long length = this.length();
        long fullLength = length - length % 64L;
        long h = 0x9E3779B97F4A7C13L ^ length;
        for (long i = 0L; i < fullLength; i += 64L) {
            h ^= (h << 5) + this.getLong(i, i + 64L) + (h >>> 2);
        }
        if (length != fullLength) {
            h ^= (h << 5) + this.getLong(fullLength, length) + (h >>> 2);
        }
        return (int)(h >>> 32 ^ h);
    }

    @Override
    public long[] bits() {
        long[] bits = new long[(int)(this.length() + 64L - 1L >> 6)];
        long length = this.length();
        int i = 0;
        while ((long)i < length) {
            if (this.getBoolean(i)) {
                int n = i >> 6;
                bits[n] = bits[n] | 1L << (i & 0x3F);
            }
            ++i;
        }
        return bits;
    }

    @Override
    public BitVector length(long newLength) {
        long length = this.length();
        if (length < newLength) {
            long i = newLength - length;
            while (i-- != 0L) {
                this.add(false);
            }
        } else {
            long i = length;
            while (i-- != newLength) {
                this.removeBoolean(i);
            }
        }
        return this;
    }

    @Override
    public LongSortedSet asLongSet() {
        return new LongSetView(this, 0L, Long.MAX_VALUE);
    }

    @Override
    public LongBigList asLongBigList(int width) {
        return new LongBigListView(this, width);
    }

    @Override
    public SubBitVector subList(int from, int to) {
        return new SubBitVector(this, from, to);
    }

    @Override
    public BitVector subVector(long from, long to) {
        return new SubBitVector(this, from, to);
    }

    @Override
    public BitVector subVector(long from) {
        return this.subVector(from, this.length());
    }

    @Override
    public int compareTo(List<? extends Boolean> list) {
        if (list instanceof BitVector) {
            return this.compareTo((BitVector)list);
        }
        return super.compareTo(list);
    }

    @Override
    public int compareTo(BitVector v) {
        long xor;
        long w1;
        long w0;
        long minLength = Math.min(this.length(), v.length());
        long l = minLength - minLength % 64L;
        int i = 0;
        while ((long)i < l) {
            w0 = this.getLong(i, i + 64);
            xor = w0 ^ (w1 = v.getLong(i, i + 64));
            if (xor != 0L) {
                return (xor & -xor & w0) == 0L ? -1 : 1;
            }
            i += 64;
        }
        w0 = this.getLong(i, minLength);
        xor = w0 ^ (w1 = v.getLong(i, minLength));
        if (xor != 0L) {
            return (xor & -xor & w0) == 0L ? -1 : 1;
        }
        return Long.signum(this.length() - v.length());
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            s.append(this.getInt(i));
        }
        return s.toString();
    }

    public static class SubBitVector
    extends AbstractBitVector
    implements BitVector {
        private static final long serialVersionUID = 1L;
        protected final BitVector bitVector;
        protected long from;
        protected long to;

        public SubBitVector(BitVector l, long from, long to) {
            BitVectors.ensureFromTo(l.length(), from, to);
            this.from = from;
            this.to = to;
            this.bitVector = l;
        }

        public boolean getBoolean(long index) {
            return this.bitVector.getBoolean(this.from + index);
        }

        public int getInt(long index) {
            return this.getBoolean(index) ? 1 : 0;
        }

        public boolean set(long index, boolean value) {
            return this.bitVector.set(this.from + index, value);
        }

        public void set(long index, int value) {
            this.set(index, value != 0);
        }

        public void add(long index, boolean value) {
            this.bitVector.add(this.from + index, value);
            ++this.to;
        }

        public void add(long index, int value) {
            this.add(index, value != 0);
            ++this.to;
        }

        public void add(int value) {
            this.bitVector.add(this.to++, value);
        }

        public boolean removeBoolean(long index) {
            --this.to;
            return this.bitVector.removeBoolean(this.from + index);
        }

        public BitVector copy(long from, long to) {
            BitVectors.ensureFromTo(this.length(), from, to);
            return this.bitVector.copy(this.from + from, this.from + to);
        }

        public BitVector subVector(long from, long to) {
            BitVectors.ensureFromTo(this.length(), from, to);
            return new SubBitVector(this.bitVector, this.from + from, this.from + to);
        }

        public long getLong(long from, long to) {
            return this.bitVector.getLong(from + this.from, to + this.from);
        }

        public long length() {
            return this.to - this.from;
        }
    }

    public static class LongBigListView
    extends AbstractLongList
    implements LongBigList,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final BitVector bitVector;
        protected final int width;
        protected final long fullMask;

        public LongBigListView(BitVector bitVector, int width) {
            this.width = width;
            this.bitVector = bitVector;
            this.fullMask = width == 64 ? -1L : (1L << width) - 1L;
        }

        public long length() {
            return this.width == 0 ? 0L : this.bitVector.length() / (long)this.width;
        }

        public int size() {
            long length = this.length();
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("The number of elements of this bit list (" + length + ") exceeds Integer.MAX_INT");
            }
            return (int)length;
        }

        public LongBigList length(long newSize) {
            this.bitVector.length(newSize * (long)this.width);
            return this;
        }

        public void size(int newSize) {
            this.length(newSize);
        }

        public LongListIterator listIterator() {
            return new LongBigListIterator();
        }

        public void add(int index, long value) {
            this.add((long)index, value);
        }

        public void add(long index, long value) {
            if (this.width != 64 && value > this.fullMask) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < this.width; ++i) {
                this.bitVector.add((value & 1L << i) != 0L);
            }
        }

        public long getLong(long index) {
            long start = index * (long)this.width;
            return this.bitVector.getLong(start, start + (long)this.width);
        }

        public long getLong(int index) {
            return this.getLong((long)index);
        }

        public long removeLong(long index) {
            throw new UnsupportedOperationException();
        }

        public long set(long index, long value) {
            if (this.width != 64 && value > this.fullMask) {
                throw new IllegalArgumentException();
            }
            long oldValue = this.getLong(index);
            long start = index * (long)this.width;
            int i = this.width;
            while (i-- != 0) {
                this.bitVector.set((long)i + start, (value & 1L << i) != 0L);
            }
            return oldValue;
        }

        public long set(int index, long value) {
            return this.set((long)index, value);
        }

        public LongBigList subList(long from, long to) {
            return this.bitVector.subVector(from * (long)this.width, to * (long)this.width).asLongBigList(this.width);
        }

        private final class LongBigListIterator
        extends AbstractLongListIterator {
            private long pos = 0L;

            private LongBigListIterator() {
            }

            public boolean hasNext() {
                return this.pos < LongBigListView.this.length();
            }

            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LongBigListView.this.getLong(this.pos++);
            }

            public long previousLong() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return LongBigListView.this.getLong(--this.pos);
            }

            public int nextIndex() {
                if (this.pos >= Integer.MAX_VALUE) {
                    throw new IllegalStateException("The current list position is larger than Integer.MAX_VALUE");
                }
                return (int)this.pos;
            }

            public int previousIndex() {
                if (this.pos > 0x80000000L) {
                    throw new IllegalStateException("The current list position is larger than Integer.MAX_VALUE");
                }
                return (int)(this.pos - 1L);
            }
        }
    }

    public static class LongSetView
    extends AbstractLongSortedSet
    implements LongSet,
    Serializable {
        protected final BitVector bitVector;
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;

        public LongSetView(BitVector bitVector, long from, long to) {
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            this.bitVector = bitVector;
            this.from = from;
            this.to = to;
        }

        public boolean contains(long index) {
            if (index < 0L) {
                throw new IllegalArgumentException("The provided index (" + index + ") is negative");
            }
            if (index < this.from || index >= this.to) {
                return false;
            }
            return index < (long)this.bitVector.size() && this.bitVector.getBoolean(index);
        }

        public boolean add(long index) {
            if (index < 0L) {
                throw new IllegalArgumentException("The provided index (" + index + ") is negative");
            }
            if (index < this.from || index >= this.to) {
                return false;
            }
            int size = this.bitVector.size();
            if (index >= (long)size) {
                this.bitVector.length(index + 1L);
            }
            boolean oldValue = this.bitVector.getBoolean(index);
            this.bitVector.set(index);
            return !oldValue;
        }

        public boolean remove(long index) {
            int size = this.bitVector.size();
            if (index >= (long)size) {
                return false;
            }
            boolean oldValue = this.bitVector.getBoolean(index);
            this.bitVector.clear(index);
            return oldValue;
        }

        public void clear() {
            this.bitVector.clear();
        }

        public int size() {
            long size = this.bitVector.subVector(this.from, Math.min(this.to, this.bitVector.length())).count();
            if (size > Integer.MAX_VALUE) {
                throw new IllegalStateException("Set is too large to return an integer size");
            }
            return (int)size;
        }

        public LongBidirectionalIterator iterator() {
            return this.iterator(0L);
        }

        public LongBidirectionalIterator iterator(long from) {
            return new LongSetViewIterator(from);
        }

        public long firstLong() {
            return this.bitVector.nextOne(this.from);
        }

        public long lastLong() {
            return this.bitVector.previousOne(Math.min(this.bitVector.length(), this.to));
        }

        public LongComparator comparator() {
            return null;
        }

        public LongSortedSet headSet(long to) {
            return to < this.to ? new LongSetView(this.bitVector, this.from, to) : this;
        }

        public LongSortedSet tailSet(long from) {
            return from > this.from ? new LongSetView(this.bitVector, from, this.to) : this;
        }

        public LongSortedSet subSet(long from, long to) {
            to = to < this.to ? to : this.to;
            long l = from = from > this.from ? from : this.from;
            if (from == this.from && to == this.to) {
                return this;
            }
            return new LongSetView(this.bitVector, from, to);
        }

        private final class LongSetViewIterator
        extends AbstractLongBidirectionalIterator {
            long pos;
            long last = -1L;
            long nextPos = -1L;
            long prevPos = -1L;

            private LongSetViewIterator(long from) {
                this.pos = from;
            }

            public boolean hasNext() {
                if (this.nextPos == -1L && this.pos < LongSetView.this.bitVector.length()) {
                    this.nextPos = LongSetView.this.bitVector.nextOne(this.pos);
                }
                return this.nextPos != -1L;
            }

            public boolean hasPrevious() {
                if (this.prevPos == -1L && this.pos > 0L) {
                    this.prevPos = LongSetView.this.bitVector.previousOne(this.pos);
                }
                return this.prevPos != -1L;
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.nextPos;
                this.pos = this.nextPos + 1L;
                this.nextPos = -1L;
                return this.last;
            }

            public long previousLong() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.pos = this.prevPos;
                this.prevPos = -1L;
                this.last = this.pos;
                return this.last;
            }

            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                LongSetView.this.bitVector.clear(this.last);
            }
        }
    }
}

