/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.compression;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.compression.Decoder;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.io.InputBitStream;
import java.io.IOException;
import java.io.Serializable;

public final class TreeDecoder
implements Decoder,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final boolean DEBUG = false;
    private final Node root;
    private final int n;

    public TreeDecoder(Node root, int n) {
        this.root = root;
        this.n = n;
    }

    public TreeDecoder(BitVector[] lexSortedCodeWord, int[] symbol) {
        this(TreeDecoder.buildTree(lexSortedCodeWord, symbol, 0, 0, lexSortedCodeWord.length), lexSortedCodeWord.length);
    }

    private static Node buildTree(BitVector[] lexSortedCodeWords, int[] symbol, int prefix, int offset, int length) {
        if (length == 1) {
            return new LeafNode(symbol[offset]);
        }
        int i = length - 1;
        while (i-- != 0) {
            if (lexSortedCodeWords[offset + i].get(prefix) == lexSortedCodeWords[offset + i + 1].get(prefix)) continue;
            Node node = new Node();
            node.left = TreeDecoder.buildTree(lexSortedCodeWords, symbol, prefix + 1, offset, i + 1);
            node.right = TreeDecoder.buildTree(lexSortedCodeWords, symbol, prefix + 1, offset + i + 1, length - i - 1);
            return node;
        }
        throw new IllegalStateException();
    }

    public int decode(BooleanIterator iterator) {
        Node n = this.root;
        while (!(n instanceof LeafNode)) {
            n = iterator.nextBoolean() ? n.right : n.left;
        }
        return ((LeafNode)n).symbol;
    }

    public int decode(InputBitStream ibs) throws IOException {
        Node n = this.root;
        while (!(n instanceof LeafNode)) {
            n = ibs.readBit() == 0 ? n.left : n.right;
        }
        return ((LeafNode)n).symbol;
    }

    private void buildCodes(BitVector[] codeWord, Node node, BitVector prefix) {
        if (node instanceof LeafNode) {
            codeWord[((LeafNode)node).symbol] = prefix;
            return;
        }
        BitVector bitVector = prefix.copy();
        bitVector.length(bitVector.length() + 1L);
        this.buildCodes(codeWord, node.left, bitVector);
        bitVector = prefix.copy();
        bitVector.length(bitVector.length() + 1L);
        bitVector.set(bitVector.size() - 1);
        this.buildCodes(codeWord, node.right, bitVector);
    }

    public BitVector[] buildCodes() {
        BitVector[] codeWord = new BitVector[this.n];
        this.buildCodes(codeWord, this.root, LongArrayBitVector.getInstance());
        return codeWord;
    }

    public static class LeafNode
    extends Node {
        private static final long serialVersionUID = 1L;
        public final int symbol;

        public LeafNode(int symbol) {
            this.symbol = symbol;
        }
    }

    public static class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Node left;
        public Node right;
    }
}

