/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes.custom;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CustomByteArrayFrontCodedList
extends AbstractObjectList<byte[]>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -2532468860579334765L;
    protected int n;
    protected int ratio;
    private BackingBuffer bb;
    private boolean hasDups;
    protected transient int[] p;
    private static transient String NULL = "null";

    private void assertRatio(int ratio) {
        if (ratio < 1) {
            throw new IllegalArgumentException("Illegal ratio (" + ratio + ")");
        }
    }

    public CustomByteArrayFrontCodedList(Iterator<byte[]> arrays, int ratio) {
        this(arrays, ratio, false);
    }

    public CustomByteArrayFrontCodedList(Iterator<byte[]> arrays, int ratio, boolean hasDups) {
        this.assertRatio(ratio);
        byte[] array = ByteArrays.EMPTY_ARRAY;
        int[] p = IntArrays.EMPTY_ARRAY;
        byte[][] a = new byte[2][];
        int curSize = 0;
        int b = 0;
        while (arrays.hasNext()) {
            a[b] = arrays.next();
            int length = a[b].length;
            if (this.n % ratio == 0) {
                p = IntArrays.grow(p, this.n / ratio + 1);
                p[this.n / ratio] = curSize;
                array = ByteArrays.grow(array, curSize + CustomByteArrayFrontCodedList.count(length) + length, curSize);
                curSize += CustomByteArrayFrontCodedList.writeInt(array, length, curSize);
                System.arraycopy(a[b], 0, array, curSize, length);
                curSize += length;
            } else {
                int common;
                int minLength = a[1 - b].length;
                if (length < minLength) {
                    minLength = length;
                }
                for (common = 0; common < minLength && a[0][common] == a[1][common]; ++common) {
                }
                array = ByteArrays.grow(array, curSize + CustomByteArrayFrontCodedList.count(length -= common) + CustomByteArrayFrontCodedList.count(common) + length, curSize);
                curSize += CustomByteArrayFrontCodedList.writeInt(array, length, curSize);
                curSize += CustomByteArrayFrontCodedList.writeInt(array, common, curSize);
                System.arraycopy(a[b], common, array, curSize, length);
                curSize += length;
            }
            b = 1 - b;
            ++this.n;
        }
        this.ratio = ratio;
        this.bb = new BackingByteArray(ByteArrays.trim(array, curSize));
        this.p = IntArrays.trim(p, (this.n + ratio - 1) / ratio);
        this.hasDups = hasDups;
    }

    public CustomByteArrayFrontCodedList(Collection<byte[]> c, int ratio) {
        this(c.iterator(), ratio);
    }

    public CustomByteArrayFrontCodedList(Collection<byte[]> c, int ratio, boolean hasDups) {
        this(c.iterator(), ratio, hasDups);
    }

    private static int count(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 16384) {
            return 2;
        }
        if (length < 0x200000) {
            return 3;
        }
        if (length < 0x10000000) {
            return 4;
        }
        return 5;
    }

    private static int writeInt(byte[] a, int length, int pos) {
        int count = CustomByteArrayFrontCodedList.count(length);
        a[pos + count - 1] = (byte)(length & 0x7F);
        if (count != 1) {
            int i = count - 1;
            while (i-- != 0) {
                a[pos + i] = (byte)(-((length >>>= 7) & 0x7F) - 1);
            }
        }
        return count;
    }

    public int ratio() {
        return this.ratio;
    }

    private int length(int index) {
        BackingBuffer bb = this.bb;
        int delta = index % this.ratio;
        int pos = this.p[index / this.ratio];
        int length = bb.readInt(pos);
        if (delta == 0) {
            return length;
        }
        pos += CustomByteArrayFrontCodedList.count(length) + length;
        length = bb.readInt(pos);
        int common = bb.readInt(pos + CustomByteArrayFrontCodedList.count(length));
        for (int i = 0; i < delta - 1; ++i) {
            length = bb.readInt(pos += CustomByteArrayFrontCodedList.count(length) + CustomByteArrayFrontCodedList.count(common) + length);
            common = bb.readInt(pos + CustomByteArrayFrontCodedList.count(length));
        }
        return length + common;
    }

    public int arrayLength(int index) {
        this.ensureRestrictedIndex(index);
        return this.length(index);
    }

    private int extract(int index, byte[] a, int offset, int length) {
        BackingBuffer bb = this.bb;
        int delta = index % this.ratio;
        int startPos = this.p[index / this.ratio];
        int currLen = 0;
        int pos = startPos;
        int arrayLength = bb.readInt(pos);
        if (delta == 0) {
            pos = this.p[index / this.ratio] + CustomByteArrayFrontCodedList.count(arrayLength);
            bb.arraycopy(pos, a, offset, Math.min(length, arrayLength));
            return arrayLength;
        }
        int common = 0;
        for (int i = 0; i < delta; ++i) {
            int prevArrayPos = pos + CustomByteArrayFrontCodedList.count(arrayLength) + (i != 0 ? CustomByteArrayFrontCodedList.count(common) : 0);
            common = bb.readInt((pos = prevArrayPos + arrayLength) + CustomByteArrayFrontCodedList.count(arrayLength = bb.readInt(pos)));
            int actualCommon = Math.min(common, length);
            if (actualCommon <= currLen) {
                currLen = actualCommon;
                continue;
            }
            bb.arraycopy(prevArrayPos, a, currLen + offset, actualCommon - currLen);
            currLen = actualCommon;
        }
        if (currLen < length) {
            bb.arraycopy(pos + CustomByteArrayFrontCodedList.count(arrayLength) + CustomByteArrayFrontCodedList.count(common), a, currLen + offset, Math.min(arrayLength, length - currLen));
        }
        return arrayLength + common;
    }

    @Override
    public byte[] get(int index) {
        return this.getArray(index);
    }

    public byte[] getArray(int index) {
        this.ensureRestrictedIndex(index);
        int length = this.length(index);
        byte[] a = new byte[length];
        this.extract(index, a, 0, length);
        return a;
    }

    public int writeOn(OutputStream os, int index) throws IOException {
        byte[] a = this.get(index);
        os.write(a);
        return a.length;
    }

    public int get(int index, byte[] a, int offset, int length) {
        this.ensureRestrictedIndex(index);
        ByteArrays.ensureOffsetLength(a, offset, length);
        int arrayLength = this.extract(index, a, offset, length);
        if (length >= arrayLength) {
            return arrayLength;
        }
        return length - arrayLength;
    }

    public int get(int index, byte[] a) {
        return this.get(index, a, 0, a.length);
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public ObjectListIterator<byte[]> listIterator(final int start) {
        this.ensureIndex(start);
        return new AbstractObjectListIterator<byte[]>(){
            byte[] a = ByteArrays.EMPTY_ARRAY;
            int i = 0;
            int pos = 0;
            boolean inSync;
            {
                if (start != 0) {
                    if (start == CustomByteArrayFrontCodedList.this.n) {
                        this.i = start;
                    } else {
                        this.pos = CustomByteArrayFrontCodedList.this.p[start / CustomByteArrayFrontCodedList.this.ratio];
                        int j = start % CustomByteArrayFrontCodedList.this.ratio;
                        this.i = start - j;
                        while (j-- != 0) {
                            this.next();
                        }
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.i < CustomByteArrayFrontCodedList.this.n;
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public int previousIndex() {
                return this.i - 1;
            }

            @Override
            public int nextIndex() {
                return this.i;
            }

            @Override
            public byte[] next() {
                int length;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BackingBuffer bb = CustomByteArrayFrontCodedList.this.bb;
                if (this.i % CustomByteArrayFrontCodedList.this.ratio == 0) {
                    this.pos = CustomByteArrayFrontCodedList.this.p[this.i / CustomByteArrayFrontCodedList.this.ratio];
                    length = bb.readInt(this.pos);
                    this.a = ByteArrays.ensureCapacity(this.a, length, 0);
                    bb.arraycopy(this.pos + CustomByteArrayFrontCodedList.count(length), this.a, 0, length);
                    this.pos += length + CustomByteArrayFrontCodedList.count(length);
                    this.inSync = true;
                } else if (this.inSync) {
                    length = bb.readInt(this.pos);
                    int common = bb.readInt(this.pos + CustomByteArrayFrontCodedList.count(length));
                    this.a = ByteArrays.ensureCapacity(this.a, length + common, common);
                    bb.arraycopy(this.pos + CustomByteArrayFrontCodedList.count(length) + CustomByteArrayFrontCodedList.count(common), this.a, common, length);
                    this.pos += CustomByteArrayFrontCodedList.count(length) + CustomByteArrayFrontCodedList.count(common) + length;
                    length += common;
                } else {
                    length = CustomByteArrayFrontCodedList.this.length(this.i);
                    this.a = ByteArrays.ensureCapacity(this.a, length, 0);
                    CustomByteArrayFrontCodedList.this.extract(this.i, this.a, 0, length);
                }
                ++this.i;
                return ByteArrays.copy(this.a, 0, length);
            }

            @Override
            public byte[] previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.inSync = false;
                return CustomByteArrayFrontCodedList.this.getArray(--this.i);
            }
        };
    }

    public Object clone() {
        CustomByteArrayFrontCodedList c;
        try {
            c = (CustomByteArrayFrontCodedList)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.bb = this.bb.clone();
        c.p = (int[])this.p.clone();
        return c;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{ratio=" + this.ratio + ", size=" + this.n + ", p[]=" + Arrays.toString(this.p));
        s.append("[\n");
        int i = 0;
        while (i < this.n) {
            int pos = this.p[i / this.ratio];
            for (int j = 0; j < this.ratio && i < this.n; ++j, ++i) {
                int clen;
                int delta = i % this.ratio;
                int pos0 = pos;
                int rlen = this.bb.readInt(pos);
                pos += CustomByteArrayFrontCodedList.count(rlen);
                if (delta == 0) {
                    clen = 0;
                } else {
                    clen = this.bb.readInt(pos);
                    pos += CustomByteArrayFrontCodedList.count(clen);
                }
                byte[] a = this.get(i);
                s.append("index=" + i + ", delta=" + delta + ", p[" + i / this.ratio + "]=" + this.p[i / this.ratio] + ", pos@rlen=" + pos0 + ", rlen=" + rlen + ", clen=" + clen + ", pos@remainder=" + pos + " :: " + CustomByteArrayFrontCodedList.toString(a) + "\n");
                pos += rlen;
            }
        }
        s.append("]}");
        return s.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.rebuildPointerArray();
    }

    public CustomByteArrayFrontCodedList(int n, int ratio, byte[] array) {
        this(n, ratio, array, 0, array.length, false);
    }

    public CustomByteArrayFrontCodedList(int n, int ratio, byte[] array, int off, int len, boolean hasDups) {
        this.assertRatio(ratio);
        this.n = n;
        this.ratio = ratio;
        this.bb = new BackingByteArray(array, off, len);
        this.hasDups = hasDups;
        this.rebuildPointerArray();
    }

    public CustomByteArrayFrontCodedList(int n, int ratio, ByteBuffer b) {
        this.assertRatio(ratio);
        this.n = n;
        this.ratio = ratio;
        this.bb = new BackingByteBuffer(b);
        this.rebuildPointerArray();
    }

    public BackingBuffer getBackingBuffer() {
        return this.bb;
    }

    private void rebuildPointerArray() {
        int[] p = new int[(this.n + this.ratio - 1) / this.ratio];
        BackingBuffer bb = this.bb;
        int i = 0;
        int pos = 0;
        for (i = 0; i < this.n; ++i) {
            int length = bb.readInt(pos);
            if (i % this.ratio == 0) {
                p[i / this.ratio] = pos;
                pos += CustomByteArrayFrontCodedList.count(length) + length;
                continue;
            }
            int common = bb.readInt(pos + CustomByteArrayFrontCodedList.count(length));
            pos += CustomByteArrayFrontCodedList.count(length) + CustomByteArrayFrontCodedList.count(common) + length;
        }
        this.p = p;
    }

    public int search(byte[] a) {
        int rlen;
        int clen;
        int delta;
        int poffset;
        int pret = this.binarySearch(a);
        if (pret == 0 || pret > 0 && !this.hasDups) {
            return pret * this.ratio;
        }
        if (pret == -1) {
            return -1;
        }
        if (pret < 0) {
            poffset = -pret - 1 - 1;
        } else {
            assert (this.hasDups);
            assert (pret > 0);
            poffset = pret - 1;
        }
        int offset = poffset * this.ratio;
        int pos = this.p[poffset];
        int blen = this.bb.readInt(pos);
        pos += CustomByteArrayFrontCodedList.count(blen);
        int i = 0;
        while (i < a.length && i < blen && a[i] == this.bb.get(pos)) {
            ++i;
            ++pos;
        }
        int mlen = i;
        pos += blen - mlen;
        int limit = Math.min(this.n - (offset + 1), this.ratio - 1);
        for (delta = 0; delta < limit && (clen = this.bb.readInt(pos += CustomByteArrayFrontCodedList.count(rlen = this.bb.readInt(pos)))) >= mlen; ++delta) {
            pos += CustomByteArrayFrontCodedList.count(clen);
            if (clen > mlen) {
                pos += rlen;
                continue;
            }
            assert (mlen == clen) : "mlen=" + mlen + ", clen=" + clen + ", rlen=" + rlen + ", delta=" + delta + ", pret=" + pret + ", poffset=" + poffset + ", searchKey=" + CustomByteArrayFrontCodedList.toString(a) + ", this=" + this;
            int ret = this.compareBytes(a, mlen, a.length - mlen, this.bb, pos, rlen);
            if (ret == 0) {
                return offset + delta + 1;
            }
            if (ret < 0) break;
            int prefixLength = Math.abs(ret) - 1;
            mlen += prefixLength;
            pos += rlen;
        }
        if (pret >= 0) {
            assert (this.hasDups);
            assert (delta == limit);
            return pret * this.ratio;
        }
        return -(offset + delta + 1) - 1;
    }

    private int binarySearch(byte[] key) {
        int low = 0;
        int high = this.p.length - 1;
        while (low <= high) {
            int mid;
            int offset = mid = low + high >> 1;
            int tmp = this.comparePos(mid, key);
            if (tmp > 0) {
                low = mid + 1;
                continue;
            }
            if (tmp < 0) {
                high = mid - 1;
                continue;
            }
            if (this.hasDups && mid > 0 && this.comparePos(mid - 1, key) == 0) {
                high = mid - 1;
                continue;
            }
            return offset;
        }
        int offset = low;
        return -(offset + 1);
    }

    private int comparePos(int index, byte[] key) {
        int pos = this.p[index];
        int blen = this.bb.readInt(pos);
        return this.compareBytes(key, 0, key.length, this.bb, pos += CustomByteArrayFrontCodedList.count(blen), blen);
    }

    private int compareBytes(byte[] a, int aoff, int alen, BackingBuffer bb, int boff, int blen) {
        int mlen = 0;
        int i = aoff;
        int j = boff;
        while (i < aoff + alen && j < boff + blen) {
            int ret = (a[i] & 0xFF) - (bb.get(j) & 0xFF);
            if (ret != 0) {
                return ret < 0 ? -(mlen + 1) : mlen + 1;
            }
            ++i;
            ++j;
            ++mlen;
        }
        return alen == blen ? 0 : (alen - blen < 0 ? -(mlen + 1) : mlen + 1);
    }

    public static final String toString(byte[] key) {
        if (key == null) {
            return NULL;
        }
        return CustomByteArrayFrontCodedList.toString(key, 0, key.length);
    }

    public static final String toString(byte[] key, int off, int len) {
        if (key == null) {
            return NULL;
        }
        StringBuilder sb = new StringBuilder(len * 4 + 2);
        sb.append("[");
        for (int i = off; i < off + len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(Integer.toString(key[i] & 0xFF));
        }
        sb.append("]");
        return sb.toString();
    }

    private static class BackingByteBuffer
    implements BackingBuffer {
        private static final long serialVersionUID = 1L;
        private final ByteBuffer b;

        public BackingByteBuffer(ByteBuffer b) {
            this.b = b;
        }

        @Override
        public int size() {
            return this.b.capacity();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte get(int i) {
            ByteBuffer byteBuffer = this.b;
            synchronized (byteBuffer) {
                return this.b.get(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int readInt(int pos) {
            ByteBuffer byteBuffer = this.b;
            synchronized (byteBuffer) {
                if (this.get(pos) >= 0) {
                    return this.get(pos);
                }
                if (this.get(pos + 1) >= 0) {
                    return -this.get(pos) - 1 << 7 | this.get(pos + 1);
                }
                if (this.get(pos + 2) >= 0) {
                    return -this.get(pos) - 1 << 14 | -this.get(pos + 1) - 1 << 7 | this.get(pos + 2);
                }
                if (this.get(pos + 3) >= 0) {
                    return -this.get(pos) - 1 << 21 | -this.get(pos + 1) - 1 << 14 | -this.get(pos + 2) - 1 << 7 | this.get(pos + 3);
                }
                return -this.get(pos) - 1 << 28 | -this.get(pos + 1) - 1 << 21 | -this.get(pos + 2) - 1 << 14 | -this.get(pos + 3) - 1 << 7 | this.get(pos + 4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] toArray() {
            ByteBuffer byteBuffer = this.b;
            synchronized (byteBuffer) {
                byte[] a = new byte[this.b.capacity()];
                this.b.clear();
                this.b.get(a);
                this.b.clear();
                return a;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void arraycopy(int pos, byte[] dest, int destPos, int len) {
            ByteBuffer byteBuffer = this.b;
            synchronized (byteBuffer) {
                this.b.limit(pos + len);
                this.b.position(pos);
                this.b.get(dest, destPos, len);
                this.b.clear();
            }
        }

        @Override
        public int writeOn(OutputStream dos) throws IOException {
            byte[] a = this.toArray();
            dos.write(a, 0, a.length);
            return a.length;
        }

        @Override
        public int writeOn(OutputStream dos, int off, int len) throws IOException {
            byte[] a = new byte[len];
            this.arraycopy(off, a, 0, len);
            dos.write(a, 0, a.length);
            return a.length;
        }

        @Override
        public BackingByteBuffer clone() {
            return new BackingByteBuffer(ByteBuffer.wrap(this.toArray()));
        }
    }

    private class BackingByteArray
    implements BackingBuffer {
        private static final long serialVersionUID = 1L;
        private final byte[] a;
        private final int off;
        private final int len;

        public BackingByteArray(byte[] a) {
            this(a, 0, a.length);
        }

        public BackingByteArray(byte[] a, int off, int len) {
            this.a = a;
            this.off = off;
            this.len = len;
        }

        @Override
        public int size() {
            return this.len;
        }

        @Override
        public byte get(int i) {
            return this.a[this.off + i];
        }

        @Override
        public void arraycopy(int pos, byte[] dest, int destPos, int len) {
            if (pos < 0) {
                throw new IllegalArgumentException();
            }
            if (pos + len > this.len) {
                throw new IllegalArgumentException();
            }
            System.arraycopy(this.a, this.off + pos, dest, destPos, len);
        }

        @Override
        public int writeOn(OutputStream dos) throws IOException {
            dos.write(this.a, this.off, this.len);
            return this.len;
        }

        @Override
        public int writeOn(OutputStream dos, int aoff, int alen) throws IOException {
            if (aoff < 0) {
                throw new IllegalArgumentException();
            }
            if (aoff + alen > this.len) {
                throw new IllegalArgumentException();
            }
            dos.write(this.a, this.off + aoff, alen);
            return this.len;
        }

        @Override
        public int readInt(int pos) {
            if (this.a[pos += this.off] >= 0) {
                return this.a[pos];
            }
            if (this.a[pos + 1] >= 0) {
                return -this.a[pos] - 1 << 7 | this.a[pos + 1];
            }
            if (this.a[pos + 2] >= 0) {
                return -this.a[pos] - 1 << 14 | -this.a[pos + 1] - 1 << 7 | this.a[pos + 2];
            }
            if (this.a[pos + 3] >= 0) {
                return -this.a[pos] - 1 << 21 | -this.a[pos + 1] - 1 << 14 | -this.a[pos + 2] - 1 << 7 | this.a[pos + 3];
            }
            return -this.a[pos] - 1 << 28 | -this.a[pos + 1] - 1 << 21 | -this.a[pos + 2] - 1 << 14 | -this.a[pos + 3] - 1 << 7 | this.a[pos + 4];
        }

        @Override
        public byte[] toArray() {
            byte[] b = new byte[this.len];
            System.arraycopy(this.a, this.off, b, 0, this.len);
            return b;
        }

        @Override
        public BackingByteArray clone() {
            return new BackingByteArray(this.toArray());
        }
    }

    public static interface BackingBuffer
    extends Cloneable,
    Serializable {
        public byte get(int var1);

        public int readInt(int var1);

        public void arraycopy(int var1, byte[] var2, int var3, int var4);

        public int size();

        public byte[] toArray();

        public int writeOn(OutputStream var1) throws IOException;

        public int writeOn(OutputStream var1, int var2, int var3) throws IOException;

        public BackingBuffer clone();
    }
}

