/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BooleanListBitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import it.unimi.dsi.util.LongBigList;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;

public abstract class BitVectorTestCase
extends TestCase {
    public static void testSetClearFlip(BitVector v) {
        int size;
        int i = size = v.size();
        while (i-- != 0) {
            v.set(i);
            BitVectorTestCase.assertTrue((boolean)v.getBoolean(i));
        }
        i = size;
        while (i-- != 0) {
            v.clear(i);
            BitVectorTestCase.assertFalse((boolean)v.getBoolean(i));
        }
        i = size;
        while (i-- != 0) {
            v.set(i);
            v.flip(i);
            BitVectorTestCase.assertFalse((boolean)v.getBoolean(i));
            v.flip(i);
            BitVectorTestCase.assertTrue((boolean)v.getBoolean(i));
        }
    }

    public static void testRemove(BitVector v) {
        v.clear();
        v.size(100);
        v.set(0, true);
        BitVectorTestCase.assertTrue((boolean)v.removeBoolean(0));
        BitVectorTestCase.assertFalse((boolean)v.getBoolean(0));
        v.clear();
        v.size(100);
        v.set(63, true);
        v.set(64, true);
        BitVectorTestCase.assertTrue((boolean)v.removeBoolean(63));
        BitVectorTestCase.assertTrue((boolean)v.getBoolean(63));
        BitVectorTestCase.assertFalse((boolean)v.getBoolean(64));
        BitVectorTestCase.assertFalse((boolean)v.getBoolean(0));
    }

    public static void testAdd(BitVector v) {
        int i;
        v.clear();
        v.size(100);
        v.add(0, true);
        BitVectorTestCase.assertTrue((boolean)v.getBoolean(0));
        v.add(0, true);
        BitVectorTestCase.assertTrue((boolean)v.getBoolean(0));
        BitVectorTestCase.assertTrue((boolean)v.getBoolean(1));
        v.add(false);
        BitVectorTestCase.assertTrue((boolean)v.getBoolean(0));
        BitVectorTestCase.assertTrue((boolean)v.getBoolean(1));
        BitVectorTestCase.assertFalse((boolean)v.getBoolean(2));
        v.set(1, false);
        BitVectorTestCase.assertTrue((boolean)v.getBoolean(0));
        BitVectorTestCase.assertFalse((boolean)v.getBoolean(1));
        BitVectorTestCase.assertFalse((boolean)v.getBoolean(2));
        v.set(1, true);
        BitVectorTestCase.assertTrue((boolean)v.getBoolean(0));
        BitVectorTestCase.assertTrue((boolean)v.getBoolean(1));
        BitVectorTestCase.assertFalse((boolean)v.getBoolean(2));
        v.clear();
        v.size(100);
        v.add(0L, 1);
        BitVectorTestCase.assertEquals((int)1, (int)v.getInt(0L));
        v.add(0L, 2);
        BitVectorTestCase.assertEquals((int)1, (int)v.getInt(0L));
        BitVectorTestCase.assertEquals((int)1, (int)v.getInt(1L));
        v.add(0L, 0);
        BitVectorTestCase.assertEquals((int)0, (int)v.getInt(0L));
        BitVectorTestCase.assertEquals((int)1, (int)v.getInt(1L));
        BitVectorTestCase.assertEquals((int)1, (int)v.getInt(2L));
        v.add(0);
        BitVectorTestCase.assertEquals((int)0, (int)v.getInt(0L));
        BitVectorTestCase.assertEquals((int)1, (int)v.getInt(1L));
        BitVectorTestCase.assertEquals((int)1, (int)v.getInt(2L));
        BitVectorTestCase.assertEquals((int)0, (int)v.getInt(3L));
        v.set(1L, 0);
        BitVectorTestCase.assertEquals((int)0, (int)v.getInt(0L));
        BitVectorTestCase.assertEquals((int)0, (int)v.getInt(1L));
        BitVectorTestCase.assertEquals((int)1, (int)v.getInt(2L));
        BitVectorTestCase.assertEquals((int)0, (int)v.getInt(3L));
        v.set(1L, 1);
        BitVectorTestCase.assertEquals((int)0, (int)v.getInt(0L));
        BitVectorTestCase.assertEquals((int)1, (int)v.getInt(1L));
        BitVectorTestCase.assertEquals((int)1, (int)v.getInt(2L));
        BitVectorTestCase.assertEquals((int)0, (int)v.getInt(3L));
        v.clear();
        v.append(1L, 2);
        v.append(1L, 2);
        v.append(3L, 2);
        BitVectorTestCase.assertEquals((Object)LongArrayBitVector.of(1, 0, 1, 0, 1, 1), (Object)v);
        v.clear();
        for (i = 0; i < 80; ++i) {
            v.add(0, true);
        }
        for (i = 0; i < 80; ++i) {
            BitVectorTestCase.assertTrue((boolean)v.getBoolean(i));
        }
        v.clear();
        for (i = 0; i < 80; ++i) {
            v.add(0, false);
        }
        for (i = 0; i < 80; ++i) {
            BitVectorTestCase.assertFalse((boolean)v.getBoolean(i));
        }
    }

    public static void testFillFlip(BitVector v) {
        v.clear();
        v.size(100);
        v.fill(true);
        int i = v.size();
        while (i-- != 0) {
            BitVectorTestCase.assertTrue((boolean)v.getBoolean(i));
        }
        v.fill(false);
        i = v.size();
        while (i-- != 0) {
            BitVectorTestCase.assertFalse((boolean)v.getBoolean(i));
        }
        v.flip();
        i = v.size();
        while (i-- != 0) {
            BitVectorTestCase.assertTrue((boolean)v.getBoolean(i));
        }
        v.clear();
        v.size(100);
        v.fill(1);
        i = v.size();
        while (i-- != 0) {
            BitVectorTestCase.assertTrue((boolean)v.getBoolean(i));
        }
        v.fill(0);
        i = v.size();
        while (i-- != 0) {
            BitVectorTestCase.assertFalse((boolean)v.getBoolean(i));
        }
        v.clear();
        v.size(100);
        v.fill(5L, 70L, true);
        i = v.size();
        while (i-- != 0) {
            BitVectorTestCase.assertEquals((String)Integer.toString(i), (i >= 5 && i < 70 ? 1 : 0) != 0, (boolean)v.getBoolean(i));
        }
        v.fill(true);
        v.fill(5L, 70L, false);
        i = v.size();
        while (i-- != 0) {
            BitVectorTestCase.assertEquals((String)Integer.toString(i), (i < 5 || i >= 70 ? 1 : 0) != 0, (boolean)v.getBoolean(i));
        }
        v.clear();
        v.size(100);
        v.fill(5L, 70L, 1);
        i = v.size();
        while (i-- != 0) {
            BitVectorTestCase.assertEquals((String)Integer.toString(i), (i >= 5 && i < 70 ? 1 : 0) != 0, (boolean)v.getBoolean(i));
        }
        v.fill(true);
        v.fill(5L, 70L, 0);
        i = v.size();
        while (i-- != 0) {
            BitVectorTestCase.assertEquals((i < 5 || i >= 70 ? 1 : 0) != 0, (boolean)v.getBoolean(i));
        }
        v.clear();
        v.size(100);
        v.flip(5L, 70L);
        i = v.size();
        while (i-- != 0) {
            BitVectorTestCase.assertEquals((String)Integer.toString(i), (i >= 5 && i < 70 ? 1 : 0) != 0, (boolean)v.getBoolean(i));
        }
        v.fill(true);
        v.flip(5L, 70L);
        i = v.size();
        while (i-- != 0) {
            BitVectorTestCase.assertEquals((i < 5 || i >= 70 ? 1 : 0) != 0, (boolean)v.getBoolean(i));
        }
    }

    public static void testCopy(BitVector v) {
        int i;
        v.clear();
        v.size(100);
        v.fill(5L, 80L, true);
        BitVector w = v.copy(0L, 85L);
        BitVectorTestCase.assertEquals((Object)w, (Object)v.subVector(0L, 85L).copy());
        int i2 = w.size();
        while (i2-- != 0) {
            BitVectorTestCase.assertEquals((i2 >= 5 && i2 < 80 ? 1 : 0) != 0, (boolean)w.getBoolean(i2));
        }
        w = v.copy(5L, 85L);
        BitVectorTestCase.assertEquals((Object)w, (Object)v.subVector(5L, 85L).copy());
        i2 = w.size();
        while (i2-- != 0) {
            BitVectorTestCase.assertEquals((i2 < 75 ? 1 : 0) != 0, (boolean)w.getBoolean(i2));
        }
        v.clear();
        int[] bits = new int[]{0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0};
        for (int i3 = 0; i3 < bits.length; ++i3) {
            v.add(bits[i3]);
        }
        LongArrayBitVector c = LongArrayBitVector.getInstance();
        for (i = 5; i < bits.length; ++i) {
            c.add(bits[i]);
        }
        BitVectorTestCase.assertEquals((Object)c, (Object)v.copy(5L, 15L));
        BitVectorTestCase.assertEquals((Object)c, (Object)v.subVector(5L, 15L).copy());
        v.clear();
        bits = new int[]{0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0};
        for (i = 0; i < bits.length; ++i) {
            v.add(bits[i]);
        }
        c = LongArrayBitVector.getInstance();
        for (i = 5; i < bits.length - 2; ++i) {
            c.add(bits[i]);
        }
        BitVectorTestCase.assertEquals((Object)c, (Object)v.copy(5L, bits.length - 2));
        BitVectorTestCase.assertEquals((Object)v, (Object)v.copy());
        long[] words = new long[]{-2401053088876204019L, -2401053088876204019L, -2401053088876204019L};
        long[] copyWords16 = new long[]{-1149017492095508819L, -1149017492095508819L, 3203391149L};
        long[] copyWords32 = new long[]{-2400999083957436689L, -2400999083957436689L};
        LongArrayBitVector.wrap(copyWords16, 160L).equals(LongArrayBitVector.wrap(words, 192L).copy(16L, 176L));
        BitVectorTestCase.assertEquals((Object)LongArrayBitVector.wrap(copyWords16, 160L), (Object)LongArrayBitVector.wrap(words, 192L).copy(16L, 176L));
        copyWords16[2] = copyWords16[2] & 0xFFFFL;
        BitVectorTestCase.assertEquals((Object)LongArrayBitVector.wrap(copyWords16, 144L), (Object)LongArrayBitVector.wrap(words, 192L).copy(16L, 160L));
        copyWords16[2] = copyWords16[2] & 0xFFL;
        BitVectorTestCase.assertEquals((Object)LongArrayBitVector.wrap(copyWords16, 136L), (Object)LongArrayBitVector.wrap(words, 192L).copy(16L, 152L));
        copyWords16[2] = copyWords16[2] & 0x1FL;
        BitVectorTestCase.assertEquals((Object)LongArrayBitVector.wrap(copyWords16, 133L), (Object)LongArrayBitVector.wrap(words, 192L).copy(16L, 149L));
        copyWords16[2] = copyWords16[2] & 1L;
        BitVectorTestCase.assertEquals((Object)LongArrayBitVector.wrap(copyWords16, 129L), (Object)LongArrayBitVector.wrap(words, 192L).copy(16L, 145L));
        copyWords32[1] = copyWords32[1] & 0xFFFFFFFFFFFFL;
        BitVectorTestCase.assertEquals((Object)LongArrayBitVector.wrap(copyWords32, 112L), (Object)LongArrayBitVector.wrap(words, 192L).copy(32L, 144L));
        copyWords32[1] = copyWords32[1] & 0xFFFFFFFFFFL;
        BitVectorTestCase.assertEquals((Object)LongArrayBitVector.wrap(copyWords32, 104L), (Object)LongArrayBitVector.wrap(words, 192L).copy(32L, 136L));
        copyWords32[1] = copyWords32[1] & 0x1FFFFFFFFFL;
        BitVectorTestCase.assertEquals((Object)LongArrayBitVector.wrap(copyWords32, 101L), (Object)LongArrayBitVector.wrap(words, 192L).copy(32L, 133L));
        copyWords32[1] = copyWords32[1] & 0x1FFFFFFFFL;
        BitVectorTestCase.assertEquals((Object)LongArrayBitVector.wrap(copyWords32, 97L), (Object)LongArrayBitVector.wrap(words, 192L).copy(32L, 129L));
    }

    public static void testBits(BitVector b) {
        for (int i = 0; i < 100; ++i) {
            b.add(i % 2);
        }
        BitVectorTestCase.assertTrue((String)LongArrayBitVector.wrap(b.bits(), b.length()).toString(), (boolean)Arrays.equals(new long[]{-6148914691236517206L, 0xAAAAAAAAAL}, b.bits()));
    }

    public static void testLongBigListView(BitVector b) {
        int i;
        LongBigList list = b.asLongBigList(10);
        for (i = 0; i < 100; ++i) {
            list.add(i);
        }
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertEquals((long)i, (long)list.getLong(i));
        }
        BitVectorTestCase.assertTrue((boolean)b.getBoolean(10));
        BitVectorTestCase.assertTrue((boolean)b.getBoolean(21));
        for (i = 0; i < 100; ++i) {
            list.add(i);
        }
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertEquals((long)i, (long)list.set(i, (long)(i + 1)));
            for (int j = i + 1; j < 100; ++j) {
                BitVectorTestCase.assertEquals((String)("" + i), (long)j, (long)list.getLong(j));
            }
        }
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertEquals((long)(i + 1), (long)list.getLong(i));
        }
        BitVectorTestCase.assertTrue((boolean)b.getBoolean(0));
        BitVectorTestCase.assertTrue((boolean)b.getBoolean(11));
        list.size(100);
        int k = 0;
        LongListIterator i2 = list.listIterator();
        while (i2.hasNext()) {
            BitVectorTestCase.assertEquals((int)k, (int)i2.nextIndex());
            BitVectorTestCase.assertEquals((long)(++k), (long)i2.nextLong());
        }
        while (i2.hasPrevious()) {
            BitVectorTestCase.assertEquals((int)(k - 1), (int)i2.previousIndex());
            BitVectorTestCase.assertEquals((long)k--, (long)i2.previousLong());
        }
    }

    public static void testLongSetView(BitVector b) {
        int i;
        int i2;
        LongSortedSet s = b.asLongSet();
        BitVectorTestCase.assertNull((Object)s.comparator());
        for (i2 = 0; i2 < 100; ++i2) {
            s.add(i2 * 2);
        }
        for (i2 = 0; i2 < 100; ++i2) {
            BitVectorTestCase.assertTrue((boolean)s.contains(i2 * 2));
        }
        for (i2 = 0; i2 < 100; ++i2) {
            BitVectorTestCase.assertFalse((boolean)s.contains(i2 * 2 + 1));
        }
        LongBidirectionalIterator iterator = s.iterator();
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertEquals((long)(i * 2), (long)iterator.nextLong());
        }
        BitVectorTestCase.assertFalse((boolean)iterator.hasNext());
        i = 100;
        while (i-- != 0) {
            BitVectorTestCase.assertEquals((long)(i * 2), (long)iterator.previousLong());
        }
        BitVectorTestCase.assertFalse((boolean)iterator.hasPrevious());
        BitVectorTestCase.assertEquals((int)100, (int)s.size());
        BitVectorTestCase.assertEquals((boolean)false, (boolean)s.remove(1L));
        BitVectorTestCase.assertEquals((int)100, (int)s.size());
        BitVectorTestCase.assertEquals((boolean)true, (boolean)s.remove(0L));
        BitVectorTestCase.assertEquals((int)99, (int)s.size());
        BitVectorTestCase.assertEquals((boolean)true, (boolean)s.remove(60L));
        BitVectorTestCase.assertEquals((int)98, (int)s.size());
        BitVectorTestCase.assertEquals((boolean)false, (boolean)s.remove(1000L));
        BitVectorTestCase.assertEquals((int)98, (int)s.size());
        BitVectorTestCase.assertEquals((boolean)false, (boolean)s.add(2L));
        BitVectorTestCase.assertEquals((int)98, (int)s.size());
        BitVectorTestCase.assertEquals((long)2L, (long)s.firstLong());
        BitVectorTestCase.assertEquals((long)198L, (long)s.lastLong());
        BitVectorTestCase.assertEquals((int)18, (int)s.subSet(3L, 40L).size());
        BitVectorTestCase.assertEquals((int)19, (int)s.headSet(40L).size());
        BitVectorTestCase.assertEquals((int)5, (int)s.tailSet(190L).size());
        iterator = s.iterator();
        BitVectorTestCase.assertEquals((long)2L, (long)iterator.nextLong());
        iterator.remove();
        BitVectorTestCase.assertFalse((boolean)s.contains(2L));
        s.clear();
        BitVectorTestCase.assertNull((Object)s.comparator());
        for (i = 0; i < 100; ++i) {
            s.add(i);
        }
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertTrue((boolean)s.contains(i));
        }
        iterator = s.iterator();
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertEquals((long)i, (long)iterator.nextLong());
        }
        BitVectorTestCase.assertFalse((boolean)iterator.hasNext());
        i = 100;
        while (i-- != 0) {
            BitVectorTestCase.assertEquals((long)i, (long)iterator.previousLong());
        }
        BitVectorTestCase.assertFalse((boolean)iterator.hasPrevious());
    }

    public static void testFirstLastPrefix(BitVector b) {
        b.clear();
        b.length(60L);
        BitVectorTestCase.assertEquals((long)-1L, (long)b.firstOne());
        BitVectorTestCase.assertEquals((long)-1L, (long)b.lastOne());
        b.flip();
        BitVectorTestCase.assertEquals((long)-1L, (long)b.firstZero());
        BitVectorTestCase.assertEquals((long)-1L, (long)b.lastZero());
        b.flip();
        b.set(4, true);
        BitVectorTestCase.assertEquals((long)4L, (long)b.firstOne());
        BitVectorTestCase.assertEquals((long)4L, (long)b.lastOne());
        b.flip();
        BitVectorTestCase.assertEquals((long)4L, (long)b.firstZero());
        BitVectorTestCase.assertEquals((long)4L, (long)b.lastZero());
        b.flip();
        b.set(50, true);
        BitVectorTestCase.assertEquals((long)4L, (long)b.firstOne());
        BitVectorTestCase.assertEquals((long)50L, (long)b.nextOne(5L));
        BitVectorTestCase.assertEquals((long)50L, (long)b.lastOne());
        BitVectorTestCase.assertEquals((long)4L, (long)b.previousOne(50L));
        b.flip();
        BitVectorTestCase.assertEquals((long)4L, (long)b.firstZero());
        BitVectorTestCase.assertEquals((long)50L, (long)b.nextZero(5L));
        BitVectorTestCase.assertEquals((long)50L, (long)b.lastZero());
        BitVectorTestCase.assertEquals((long)4L, (long)b.previousZero(50L));
        b.flip();
        b.set(20, true);
        BitVectorTestCase.assertEquals((long)4L, (long)b.firstOne());
        BitVectorTestCase.assertEquals((long)20L, (long)b.nextOne(5L));
        BitVectorTestCase.assertEquals((long)50L, (long)b.nextOne(21L));
        BitVectorTestCase.assertEquals((long)50L, (long)b.lastOne());
        BitVectorTestCase.assertEquals((long)20L, (long)b.previousOne(50L));
        BitVectorTestCase.assertEquals((long)4L, (long)b.previousOne(20L));
        b.flip();
        BitVectorTestCase.assertEquals((long)4L, (long)b.firstZero());
        BitVectorTestCase.assertEquals((long)20L, (long)b.nextZero(5L));
        BitVectorTestCase.assertEquals((long)50L, (long)b.nextZero(21L));
        BitVectorTestCase.assertEquals((long)50L, (long)b.lastZero());
        BitVectorTestCase.assertEquals((long)20L, (long)b.previousZero(50L));
        BitVectorTestCase.assertEquals((long)4L, (long)b.previousZero(20L));
        b.flip();
        b.length(100L);
        b.set(90, true);
        BitVectorTestCase.assertEquals((long)4L, (long)b.firstOne());
        BitVectorTestCase.assertEquals((long)90L, (long)b.lastOne());
        b.flip();
        BitVectorTestCase.assertEquals((long)4L, (long)b.firstZero());
        BitVectorTestCase.assertEquals((long)90L, (long)b.lastZero());
        b.flip();
        b.clear();
        b.length(100L);
        BitVectorTestCase.assertEquals((long)-1L, (long)b.firstOne());
        BitVectorTestCase.assertEquals((long)-1L, (long)b.lastOne());
        b.flip();
        BitVectorTestCase.assertEquals((long)-1L, (long)b.firstZero());
        BitVectorTestCase.assertEquals((long)-1L, (long)b.lastZero());
        b.flip();
        b.set(4, true);
        BitVectorTestCase.assertEquals((long)4L, (long)b.firstOne());
        BitVectorTestCase.assertEquals((long)4L, (long)b.lastOne());
        b.flip();
        BitVectorTestCase.assertEquals((long)4L, (long)b.firstZero());
        BitVectorTestCase.assertEquals((long)4L, (long)b.lastZero());
        b.flip();
        b.set(90, true);
        BitVectorTestCase.assertEquals((long)4L, (long)b.firstOne());
        BitVectorTestCase.assertEquals((long)90L, (long)b.lastOne());
        b.flip();
        BitVectorTestCase.assertEquals((long)4L, (long)b.firstZero());
        BitVectorTestCase.assertEquals((long)90L, (long)b.lastZero());
        b.flip();
        b.length(60L);
        BitVector c = b.copy();
        c.length(40L);
        BitVectorTestCase.assertEquals((long)c.length(), (long)b.longestCommonPrefixLength(c));
        c.flip(20L);
        BitVectorTestCase.assertEquals((long)20L, (long)b.longestCommonPrefixLength(c));
        c.flip(0L);
        BitVectorTestCase.assertEquals((long)0L, (long)b.longestCommonPrefixLength(c));
        b.length(128L).fill(false);
        b.set(127L);
        c.length(65L).fill(false);
        BitVectorTestCase.assertEquals((long)65L, (long)b.longestCommonPrefixLength(c));
        b.length(100L);
        c = b.copy();
        c.length(80L);
        BitVectorTestCase.assertEquals((long)c.length(), (long)b.longestCommonPrefixLength(c));
        BitVectorTestCase.assertEquals((long)c.length(), (long)b.longestCommonPrefixLength(BooleanListBitVector.wrap(c)));
        c.flip(20L);
        BitVectorTestCase.assertEquals((long)20L, (long)b.longestCommonPrefixLength(c));
        BitVectorTestCase.assertEquals((long)20L, (long)b.longestCommonPrefixLength(BooleanListBitVector.wrap(c)));
        c.flip(0L);
        BitVectorTestCase.assertEquals((long)0L, (long)b.longestCommonPrefixLength(c));
        BitVectorTestCase.assertEquals((long)0L, (long)b.longestCommonPrefixLength(BooleanListBitVector.wrap(c)));
        c.clear();
        c.length(2L);
        c.set(0L, 0);
        BitVectorTestCase.assertFalse((boolean)c.getBoolean(0));
        c.set(0L, 1);
        BitVectorTestCase.assertTrue((boolean)c.getBoolean(0));
        c.set(0L, 2);
        BitVectorTestCase.assertTrue((boolean)c.getBoolean(0));
        c.set(0L, 0);
        BitVectorTestCase.assertFalse((boolean)c.getBoolean(0));
        c.add(0L, 0);
        BitVectorTestCase.assertFalse((boolean)c.getBoolean(0));
        c.add(0L, 1);
        BitVectorTestCase.assertTrue((boolean)c.getBoolean(0));
    }

    public static void testLogicOperators(BitVector b) {
        int i;
        int i2;
        b.clear();
        b.length(100L);
        BitVector c = b.copy();
        for (i2 = 0; i2 < 50; ++i2) {
            b.set(2 * i2);
        }
        for (i2 = 0; i2 < 50; ++i2) {
            c.set(2 * i2 + 1);
        }
        BitVector r = b.copy().and(c);
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertFalse((boolean)r.getBoolean(i));
        }
        r = b.copy().or(c);
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertTrue((boolean)r.getBoolean(i));
        }
        r = b.copy().xor(c);
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertTrue((boolean)r.getBoolean(i));
        }
        r.xor(r);
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertFalse((boolean)r.getBoolean(i));
        }
        r = b.copy().and(BooleanListBitVector.wrap(c));
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertFalse((boolean)r.getBoolean(i));
        }
        r = b.copy().or(BooleanListBitVector.wrap(c));
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertTrue((boolean)r.getBoolean(i));
        }
        r = b.copy().xor(BooleanListBitVector.wrap(c));
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertTrue((boolean)r.getBoolean(i));
        }
        r.xor(BooleanListBitVector.wrap(r));
        for (i = 0; i < 100; ++i) {
            BitVectorTestCase.assertFalse((boolean)r.getBoolean(i));
        }
    }

    public static void testCount(BitVector b) {
        b.clear();
        b.length(100L);
        for (int i = 0; i < 50; ++i) {
            b.set(i * 2);
        }
        BitVectorTestCase.assertEquals((long)50L, (long)b.count());
    }

    public static void testSerialisation(BitVector b) throws IOException, ClassNotFoundException {
        File file = File.createTempFile(BitVectorTestCase.class.getSimpleName(), "test");
        file.deleteOnExit();
        b.clear();
        BinIO.storeObject((Object)b, file);
        BitVectorTestCase.assertEquals((Object)b, (Object)BinIO.loadObject(file));
        b.length(1000L);
        BinIO.storeObject((Object)b, file);
        BitVectorTestCase.assertEquals((Object)b, (Object)BinIO.loadObject(file));
        b.fill(true);
        BinIO.storeObject((Object)b, file);
        BitVectorTestCase.assertEquals((Object)b, (Object)BinIO.loadObject(file));
    }

    public static void testReplace(BitVector b) {
        int i;
        Random r = new Random(1L);
        LongArrayBitVector bv = LongArrayBitVector.getInstance(200L);
        for (i = 0; i < 100; ++i) {
            bv.add(r.nextBoolean());
        }
        BitVectorTestCase.assertEquals((Object)b.replace(bv), (Object)bv);
        bv = LongArrayBitVector.getInstance(256L);
        for (i = 0; i < 256; ++i) {
            bv.add(r.nextBoolean());
        }
        BitVectorTestCase.assertEquals((Object)b.replace(bv), (Object)bv);
        bv = LongArrayBitVector.getInstance(10L);
        for (i = 0; i < 10; ++i) {
            bv.add(r.nextBoolean());
        }
        BitVectorTestCase.assertEquals((Object)b.replace(bv), (Object)bv);
    }

    public static void testAppend(BitVector b) {
        b.clear();
        LongArrayBitVector v = LongArrayBitVector.ofLength(200L);
        for (int i = 0; i < 60; ++i) {
            v.set(i * 3);
        }
        b.append(v);
        BitVectorTestCase.assertEquals((Object)b, (Object)v);
        b.clear();
        b.add(true);
        b.append(v);
        LongArrayBitVector w = LongArrayBitVector.ofLength(201L);
        for (int i = 0; i < 60; ++i) {
            w.set(i * 3 + 1);
        }
        w.set(0);
        BitVectorTestCase.assertEquals((Object)w, (Object)b);
    }
}

