/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.bits;

import it.unimi.dsi.bits.Fast;
import junit.framework.TestCase;

public class FastTest
extends TestCase {
    public void testCeilLog2() {
        for (int i = 1; i < 1000; ++i) {
            FastTest.assertEquals((int)((int)Math.ceil(Math.log(i) / Math.log(2.0))), (int)Fast.ceilLog2(i));
        }
    }

    public void testLength() {
        FastTest.assertEquals((int)1, (int)Fast.length(0));
        FastTest.assertEquals((int)1, (int)Fast.length(0L));
        for (int i = 1; i < 100; ++i) {
            FastTest.assertEquals((int)(Fast.mostSignificantBit(i) + 1), (int)Fast.length(i));
        }
        for (long i = 1L; i < 100L; ++i) {
            FastTest.assertEquals((int)(Fast.mostSignificantBit(i) + 1), (int)Fast.length(i));
        }
    }

    public void testMostSignificantBit() {
        FastTest.assertEquals((int)-1, (int)Fast.mostSignificantBit(0));
        for (int i = 0; i < 64; ++i) {
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1L << i));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1L << i | 1L));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1L << i));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1L << i | 1L));
        }
        for (long i = 1L; i < 0x4000000000000000L; i += 10000000000000L) {
            FastTest.assertEquals((String)Long.toString(i), (int)(63 - Long.numberOfLeadingZeros(i)), (int)Fast.mostSignificantBit(i));
        }
    }

    public void testLeastSignificantBit() {
        FastTest.assertEquals((int)-1, (int)Fast.leastSignificantBit(0L));
        for (int i = 0; i < 64; ++i) {
            FastTest.assertEquals((int)i, (int)Fast.leastSignificantBit(1L << i));
            FastTest.assertEquals((int)0, (int)Fast.leastSignificantBit(1L << i | 1L));
            FastTest.assertEquals((int)i, (int)Fast.leastSignificantBit(1L << i));
            FastTest.assertEquals((int)0, (int)Fast.leastSignificantBit(1L << i | 1L));
        }
        for (long i = 1L; i < 0x4000000000000000L; i += 10000000000000L) {
            FastTest.assertEquals((String)Long.toString(i), (int)Long.numberOfTrailingZeros(i), (int)Fast.leastSignificantBit(i));
        }
    }

    public void testCount() {
        FastTest.assertEquals((int)0, (int)Fast.count(0L));
        FastTest.assertEquals((int)1, (int)Fast.count(1L));
        FastTest.assertEquals((int)64, (int)Fast.count(-1L));
        FastTest.assertEquals((int)32, (int)Fast.count(0xFFFFFFFFL));
        FastTest.assertEquals((int)32, (int)Fast.count(-6148914691236517206L));
    }

    public void testSelect() {
        int i;
        FastTest.assertEquals((int)0, (int)Fast.select(1L, 0));
        for (i = 0; i < 64; ++i) {
            FastTest.assertEquals((int)i, (int)Fast.select(-1L, i));
        }
        for (i = 1; i < 32; ++i) {
            FastTest.assertEquals((int)(2 * i + 1), (int)Fast.select(-6148914691236517206L, i));
        }
    }

    public void testInt2Nat() {
        int i;
        FastTest.assertEquals((int)Integer.MAX_VALUE, (int)Fast.int2nat(-1073741824));
        FastTest.assertEquals((int)0x7FFFFFFD, (int)Fast.int2nat(-1073741823));
        FastTest.assertEquals((int)0x7FFFFFFE, (int)Fast.int2nat(0x3FFFFFFF));
        for (i = 0; i < 16; ++i) {
            FastTest.assertEquals((int)(2 * i), (int)Fast.int2nat(i));
        }
        for (i = -16; i < 0; ++i) {
            FastTest.assertEquals((int)(-2 * i - 1), (int)Fast.int2nat(i));
        }
        FastTest.assertEquals((long)Long.MAX_VALUE, (long)Fast.int2nat(-4611686018427387904L));
        FastTest.assertEquals((long)0x7FFFFFFFFFFFFFFDL, (long)Fast.int2nat(-4611686018427387903L));
        FastTest.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)Fast.int2nat(0x3FFFFFFFFFFFFFFFL));
        for (i = 0; i < 16; ++i) {
            FastTest.assertEquals((long)(2L * (long)i), (long)Fast.int2nat(i));
        }
        for (i = -16; i < 0; ++i) {
            FastTest.assertEquals((long)(-2L * (long)i - 1L), (long)Fast.int2nat(i));
        }
    }

    public void testNat2Int() {
        int i;
        FastTest.assertEquals((int)-1073741824, (int)Fast.nat2int(Integer.MAX_VALUE));
        FastTest.assertEquals((int)-1073741823, (int)Fast.nat2int(0x7FFFFFFD));
        FastTest.assertEquals((int)0x3FFFFFFF, (int)Fast.nat2int(0x7FFFFFFE));
        for (i = 0; i < 16; ++i) {
            FastTest.assertEquals((int)i, (int)Fast.nat2int(2 * i));
        }
        for (i = -16; i < 0; ++i) {
            FastTest.assertEquals((int)i, (int)Fast.nat2int(-2 * i - 1));
        }
        FastTest.assertEquals((long)-4611686018427387903L, (long)Fast.nat2int(0x7FFFFFFFFFFFFFFDL));
        FastTest.assertEquals((long)-4611686018427387904L, (long)Fast.nat2int(Long.MAX_VALUE));
        FastTest.assertEquals((long)0x3FFFFFFFFFFFFFFFL, (long)Fast.nat2int(0x7FFFFFFFFFFFFFFEL));
        for (i = 0; i < 16; ++i) {
            FastTest.assertEquals((long)i, (long)Fast.nat2int(2L * (long)i));
        }
        for (i = -16; i < 0; ++i) {
            FastTest.assertEquals((long)i, (long)Fast.nat2int(-2L * (long)i - 1L));
        }
    }

    public void testLeastMostSignificantBit() {
        int i;
        for (i = 0; i < 32; ++i) {
            FastTest.assertEquals((int)i, (int)Fast.leastSignificantBit(1 << i));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1 << i));
            FastTest.assertEquals((int)0, (int)Fast.leastSignificantBit(1 << i | 1));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1 << i | 1));
            FastTest.assertEquals((int)i, (int)Fast.leastSignificantBit(1L << i));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1L << i));
            FastTest.assertEquals((int)0, (int)Fast.leastSignificantBit(1L << i | 1L));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1L << i | 1L));
        }
        for (i = 32; i < 64; ++i) {
            FastTest.assertEquals((int)i, (int)Fast.leastSignificantBit(1L << i));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1L << i));
            FastTest.assertEquals((int)0, (int)Fast.leastSignificantBit(1L << i | 1L));
            FastTest.assertEquals((int)i, (int)Fast.mostSignificantBit(1L << i | 1L));
        }
    }
}

