/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.io;

import it.unimi.dsi.io.ByteBufferInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Random;
import junit.framework.TestCase;

public class ByteBufferInputStreamTest
extends TestCase {
    private static final boolean DEBUG = false;

    public void testStream() throws FileNotFoundException, IOException {
        File f = File.createTempFile(ByteBufferInputStreamTest.class.getName(), "tmp");
        f.deleteOnExit();
        int l = 100000;
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        for (int n = 1; n < 4; ++n) {
            FileOutputStream fos = new FileOutputStream(f);
            for (int i = 0; i < 100000 * n; ++i) {
                fos.write(random.nextInt() & 0xFF);
            }
            fos.close();
            ByteBufferInputStream bis = ByteBufferInputStream.map(new FileInputStream(f).getChannel(), FileChannel.MapMode.READ_ONLY);
            FileInputStream test = new FileInputStream(f);
            FileChannel fc = test.getChannel();
            byte[] b1 = new byte[32768];
            byte[] b2 = new byte[32768];
            block10: for (int k = 0; k < 10000; ++k) {
                switch (random.nextInt(6)) {
                    case 0: {
                        int a1 = bis.read();
                        int a2 = test.read();
                        ByteBufferInputStreamTest.assertEquals((int)a2, (int)a1);
                        continue block10;
                    }
                    case 1: {
                        int off = random.nextInt(b1.length);
                        int len = random.nextInt(b1.length - off + 1);
                        int a1 = bis.read(b1, off, len);
                        int a2 = test.read(b2, off, len);
                        ByteBufferInputStreamTest.assertEquals((int)a2, (int)a1);
                        for (int i = off; i < off + len; ++i) {
                            ByteBufferInputStreamTest.assertEquals((byte)b2[i], (byte)b1[i]);
                        }
                        continue block10;
                    }
                    case 2: {
                        ByteBufferInputStreamTest.assertEquals((int)test.available(), (int)bis.available());
                        continue block10;
                    }
                    case 3: {
                        int pos = (int)bis.position();
                        ByteBufferInputStreamTest.assertEquals((int)((int)fc.position()), (int)pos);
                        continue block10;
                    }
                    case 4: {
                        int pos = random.nextInt(100000 * n);
                        bis.position(pos);
                        test = new FileInputStream(f);
                        test.skip(pos);
                        fc = test.getChannel();
                        continue block10;
                    }
                    case 5: {
                        int pos = random.nextInt((int)((long)(100000 * n) - bis.position() + 1L));
                        int a1 = (int)bis.skip(pos);
                        int a2 = (int)test.skip(pos);
                        ByteBufferInputStreamTest.assertEquals((int)a2, (int)a1);
                    }
                }
            }
            test.close();
        }
    }
}

