/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.io;

import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.io.SegmentedInputStream;
import java.io.IOException;
import junit.framework.TestCase;

public class SegmentedInputStreamTest
extends TestCase {
    private FastByteArrayInputStream stream = new FastByteArrayInputStream(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13});
    private SegmentedInputStream sis;

    public void setUp() throws IllegalArgumentException, IOException {
        this.sis = new SegmentedInputStream(this.stream);
        this.sis.addBlock(0L, 1L, 2L);
        this.sis.addBlock(2L, 3L, 4L);
        this.sis.addBlock(6L, 7L, 8L);
        this.sis.addBlock(8L, 11L, 14L);
    }

    public void testResetClose() throws IOException {
        SegmentedInputStreamTest.assertEquals((int)0, (int)this.sis.read());
        this.sis.reset();
        SegmentedInputStreamTest.assertEquals((int)1, (int)this.sis.read());
        this.sis.reset();
        SegmentedInputStreamTest.assertEquals((int)-1, (int)this.sis.read());
        this.sis.close();
        SegmentedInputStreamTest.assertEquals((int)2, (int)this.sis.read());
        this.sis.reset();
        SegmentedInputStreamTest.assertEquals((int)3, (int)this.sis.read());
        this.sis.reset();
        SegmentedInputStreamTest.assertEquals((int)-1, (int)this.sis.read());
        this.sis.close();
        SegmentedInputStreamTest.assertEquals((int)6, (int)this.sis.read());
        this.sis.reset();
        SegmentedInputStreamTest.assertEquals((int)7, (int)this.sis.read());
        this.sis.reset();
        SegmentedInputStreamTest.assertEquals((int)-1, (int)this.sis.read());
    }

    public void testRead() throws IOException {
        byte[] b = new byte[11];
        SegmentedInputStreamTest.assertEquals((int)1, (int)this.sis.read(b, 0, 10));
        SegmentedInputStreamTest.assertEquals((int)0, (int)b[0]);
        this.sis.reset();
        SegmentedInputStreamTest.assertEquals((int)1, (int)this.sis.read(b, 1, 10));
        SegmentedInputStreamTest.assertEquals((int)1, (int)b[1]);
        this.sis.close();
        SegmentedInputStreamTest.assertEquals((int)1, (int)this.sis.read(b, 5, 5));
        SegmentedInputStreamTest.assertEquals((int)2, (int)b[5]);
    }

    public void testSkip() throws IOException {
        SegmentedInputStreamTest.assertEquals((long)1L, (long)this.sis.skip(1L));
        this.sis.reset();
        SegmentedInputStreamTest.assertEquals((long)1L, (long)this.sis.skip(10L));
        this.sis.reset();
        SegmentedInputStreamTest.assertEquals((long)0L, (long)this.sis.skip(10L));
        this.sis.close();
        this.sis.close();
        this.sis.close();
        SegmentedInputStreamTest.assertEquals((long)2L, (long)this.sis.skip(2L));
        SegmentedInputStreamTest.assertEquals((long)1L, (long)this.sis.skip(2L));
        this.sis.reset();
        SegmentedInputStreamTest.assertEquals((long)3L, (long)this.sis.skip(10L));
    }
}

