/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.lang;

import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import junit.framework.TestCase;

public class MutableStringTest
extends TestCase {
    public void testSqueezeSpace() {
        MutableString s = new MutableString(new char[]{' ', '\r', '\n', ' ', ' ', ' ', '\r', '\n', ' ', ' ', ' ', '\r', '\n', ' ', ' ', ' ', ' ', ' '});
        MutableStringTest.assertEquals((Object)new MutableString(" \r\n \r\n \r\n "), (Object)s.squeezeSpace());
        MutableStringTest.assertEquals((Object)new MutableString(" "), (Object)s.squeezeWhitespace());
    }

    public void testSubsequence() {
        MutableString s = new MutableString("abc");
        CharSequence ss = s.subSequence(1, 3);
        MutableStringTest.assertEquals((Object)new MutableString("bc"), (Object)ss);
        MutableStringTest.assertEquals((int)1, (int)ss.subSequence(1, 2).length());
    }

    public void testSkipSelfDelimUTF8() throws IOException {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        new MutableString("a").writeSelfDelimUTF8(fastByteArrayOutputStream);
        new MutableString("b").writeSelfDelimUTF8(fastByteArrayOutputStream);
        new MutableString("\u221e").writeSelfDelimUTF8(fastByteArrayOutputStream);
        new MutableString("c").writeSelfDelimUTF8(fastByteArrayOutputStream);
        fastByteArrayOutputStream.flush();
        FastByteArrayInputStream fastByteArrayInputStream = new FastByteArrayInputStream(fastByteArrayOutputStream.array);
        MutableStringTest.assertEquals((String)"a", (String)new MutableString().readSelfDelimUTF8(fastByteArrayInputStream).toString());
        MutableStringTest.assertEquals((String)"b", (String)new MutableString().readSelfDelimUTF8(fastByteArrayInputStream).toString());
        MutableStringTest.assertEquals((int)1, (int)MutableString.skipSelfDelimUTF8(fastByteArrayInputStream));
        MutableStringTest.assertEquals((String)"c", (String)new MutableString().readSelfDelimUTF8(fastByteArrayInputStream).toString());
        fastByteArrayInputStream.position(0L);
        MutableStringTest.assertEquals((String)"a", (String)new MutableString().readSelfDelimUTF8(fastByteArrayInputStream).toString());
        MutableStringTest.assertEquals((int)1, (int)MutableString.skipSelfDelimUTF8(fastByteArrayInputStream));
        MutableStringTest.assertEquals((String)"\u221e", (String)new MutableString().readSelfDelimUTF8(fastByteArrayInputStream).toString());
        MutableStringTest.assertEquals((String)"c", (String)new MutableString().readSelfDelimUTF8(fastByteArrayInputStream).toString());
    }
}

