/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.parser.callback;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.parser.Attribute;
import it.unimi.dsi.parser.BulletParser;
import it.unimi.dsi.parser.Element;
import it.unimi.dsi.parser.callback.Callback;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class BulletParserCallbackContentHandler
extends DefaultHandler {
    private final Callback callback;
    private final BulletParser parser;
    private Element inCdata;
    private final ReferenceSet<Element> cdataElements = new ReferenceOpenHashSet<Element>(new Element[]{Element.SCRIPT, Element.STYLE});
    private final Reference2ObjectOpenHashMap<Attribute, MutableString> attrMap = new Reference2ObjectOpenHashMap();

    public BulletParserCallbackContentHandler(BulletParser parser, Callback callback) {
        this.parser = parser;
        this.callback = callback;
    }

    public void endDocument() {
        this.callback.endDocument();
    }

    public void endElement(String uri, String localName, String qName) {
        Element element = this.parser.factory.getElement(new MutableString(localName));
        if (this.cdataElements.contains(element) && element == this.inCdata) {
            this.inCdata = null;
        }
        this.callback.endElement(element);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inCdata != null) {
            this.callback.cdata(this.inCdata, ch, start, length);
        } else {
            this.callback.characters(ch, start, length, false);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.callback.characters(ch, start, length, false);
    }

    public void startDocument() {
        this.callback.startDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.attrMap.clear();
        for (Attribute attribute : this.parser.parsedAttributes) {
            String value = attributes.getValue(attribute.toString());
            if (value == null) continue;
            this.attrMap.put(attribute, new MutableString(value));
        }
        Element element = this.parser.factory.getElement(new MutableString(localName));
        if (this.cdataElements.contains(element)) {
            this.inCdata = element;
        }
        this.callback.startElement(element, this.attrMap);
    }
}

