/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.inline.uri;

import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.model.BigdataLiteral;
import java.util.Locale;
import java.util.UUID;

public class UndecoratedUuidInlineUriHandler
extends InlineURIHandler {
    public UndecoratedUuidInlineUriHandler(String namespace) {
        super(namespace);
    }

    protected AbstractLiteralIV createInlineIV(String localName) {
        if ((localName = localName.replace("-", "")).length() != 32) {
            return null;
        }
        try {
            long first = UndecoratedUuidInlineUriHandler.parseUnsigned(localName, 0, 16);
            long second = UndecoratedUuidInlineUriHandler.parseUnsigned(localName, 16, 32);
            return new UUIDLiteralIV(new UUID(first, second));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        return delegate.stringValue().replace("-", "").toLowerCase(Locale.ROOT);
    }

    private static long parseUnsigned(String s, int from, int to) {
        long value = 0L;
        int pos = from;
        while (pos < to) {
            int digit = Character.digit(s.charAt(pos), 16);
            if (digit == -1) {
                throw new NumberFormatException(s);
            }
            value = value * 16L + (long)digit;
            ++pos;
        }
        return value;
    }
}

