/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bfs;

import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.proc.ISimpleIndexProcedure;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.journal.AbstractJournal;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AtomicBlockWriteProc
implements ISimpleIndexProcedure,
Externalizable {
    private static final long serialVersionUID = 4982851251684333327L;
    protected static transient Logger log = Logger.getLogger(AtomicBlockWriteProc.class);
    public static final transient boolean INFO = log.getEffectiveLevel().toInt() <= Level.INFO.toInt();
    public static final transient boolean DEBUG = log.getEffectiveLevel().toInt() <= Level.DEBUG.toInt();
    private String id;
    private int version;
    private long block;
    private int off;
    private int len;
    private byte[] b;

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    public AtomicBlockWriteProc(BigdataFileSystem repo, String id, int version, long block, byte[] b, int off, int len) {
        assert (id != null && id.length() > 0);
        assert (version >= 0);
        assert (block >= 0L && block <= 0x7FFFFFFFFFFFFFFEL);
        assert (b != null);
        assert (off >= 0) : "off=" + off;
        assert (len >= 0 && off + len <= b.length);
        assert (len <= repo.getBlockSize()) : "len=" + len + " exceeds blockSize=" + repo.getBlockSize();
        this.id = id;
        this.version = version;
        this.block = block;
        this.off = off;
        this.len = len;
        this.b = b;
    }

    @Override
    public Object apply(IIndex ndx) {
        AbstractJournal journal = (AbstractJournal)((AbstractBTree)ndx).getStore();
        IKeyBuilder keyBuilder = ndx.getIndexMetadata().getKeyBuilder();
        long addr = this.len == 0 ? 0L : journal.write(ByteBuffer.wrap(this.b, this.off, this.len));
        byte[] key = keyBuilder.reset().appendText(this.id, true, false).append(this.version).append(this.block).getKey();
        DataOutputBuffer out = new DataOutputBuffer(8);
        out.reset().putLong(addr);
        byte[] val = out.toByteArray();
        boolean overwrite = ndx.insert(key, val) != null;
        log.info((Object)("Wrote " + this.len + " bytes : id=" + this.id + ", version=" + this.version + ", block#=" + this.block + " @ addr" + journal.toString(addr) + ", overwrite=" + overwrite));
        return overwrite;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.version = in.readInt();
        this.block = in.readLong();
        this.off = 0;
        this.len = in.readInt();
        this.b = new byte[this.len];
        in.readFully(this.b);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeInt(this.version);
        out.writeLong(this.block);
        out.writeInt(this.len);
        out.write(this.b, this.off, this.len);
    }
}

