/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataElement;
import com.bigdata.blueprints.BigdataGraph;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;

public class BigdataEdge
extends BigdataElement
implements Edge {
    private static final transient Logger log = Logger.getLogger(BigdataEdge.class);
    private static final List<String> blacklist = Arrays.asList("id", "", "label");
    protected final Statement stmt;

    public BigdataEdge(Statement stmt, BigdataGraph graph) {
        super(stmt.getPredicate(), graph);
        this.stmt = stmt;
    }

    public Object getId() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        return this.graph.factory.fromURI(this.uri);
    }

    public void remove() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        this.graph.removeEdge(this);
    }

    public String getLabel() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        return (String)this.graph.getProperty(this.uri, this.graph.getValueFactory().getLabelURI());
    }

    public Vertex getVertex(Direction dir) throws IllegalArgumentException {
        if (log.isInfoEnabled()) {
            log.info((Object)("(" + dir + ")"));
        }
        if (dir == Direction.BOTH) {
            throw new IllegalArgumentException();
        }
        URI uri = (URI)(dir == Direction.OUT ? this.stmt.getSubject() : this.stmt.getObject());
        String id = this.graph.factory.fromURI(uri);
        return this.graph.getVertex(id);
    }

    @Override
    public void setProperty(String prop, Object val) {
        if (log.isInfoEnabled()) {
            log.info((Object)("(" + prop + ", " + val + ")"));
        }
        if (prop == null || blacklist.contains(prop)) {
            throw new IllegalArgumentException();
        }
        super.setProperty(prop, val);
    }

    @Override
    public String toString() {
        URI s = (URI)this.stmt.getSubject();
        URI p = this.stmt.getPredicate();
        URI o = (URI)this.stmt.getObject();
        return "e[" + p.getLocalName() + "][" + s.getLocalName() + "->" + o.getLocalName() + "]";
    }

    @Override
    public <T> T getProperty(String prop) {
        if (log.isInfoEnabled()) {
            log.info((Object)("(" + prop + ")"));
        }
        return super.getProperty(prop);
    }

    @Override
    public Set<String> getPropertyKeys() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        return super.getPropertyKeys();
    }

    @Override
    public <T> T removeProperty(String prop) {
        if (log.isInfoEnabled()) {
            log.info((Object)("(" + prop + ")"));
        }
        return super.removeProperty(prop);
    }
}

