/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataEdge;
import com.bigdata.blueprints.BigdataGraph;
import com.bigdata.blueprints.BigdataRDFFactory;
import com.bigdata.blueprints.BigdataVertex;
import com.bigdata.blueprints.BlueprintsValueFactory;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import java.util.Collection;
import java.util.UUID;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.repository.RepositoryConnection;

public class BigdataGraphBulkLoad
extends BigdataGraph
implements TransactionalGraph,
IChangeLog {
    private final BigdataSailRepositoryConnection cxn;
    private transient long mutationCountTotal = 0L;
    private transient long mutationCountCurrentCommit = 0L;
    private transient long mutationCountLastCommit = 0L;

    public BigdataGraphBulkLoad(BigdataSailRepositoryConnection cxn) {
        this(cxn, BigdataRDFFactory.INSTANCE);
    }

    public BigdataGraphBulkLoad(BigdataSailRepositoryConnection cxn, BlueprintsValueFactory factory) {
        super(factory);
        this.cxn = cxn;
        this.cxn.addChangeLog(this);
    }

    @Override
    protected RepositoryConnection getWriteConnection() throws Exception {
        return this.cxn;
    }

    @Override
    protected RepositoryConnection getReadConnection() throws Exception {
        return this.cxn;
    }

    public void commit() {
        try {
            this.cxn.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void rollback() {
        try {
            this.cxn.rollback();
            this.cxn.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        try {
            this.cxn.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void stopTransaction(TransactionalGraph.Conclusion arg0) {
    }

    @Override
    public Edge getEdge(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Edge> getEdges() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Edge> getEdges(String arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vertex getVertex(Object key) {
        block7: {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            URI uri = this.factory.toVertexURI(key.toString());
            if (!this.cxn.hasStatement((Resource)uri, this.TYPE, (Value)this.VERTEX, false, new Resource[0])) break block7;
            BigdataVertex bigdataVertex = new BigdataVertex(uri, this);
            return bigdataVertex;
        }
        try {
            Vertex vertex = null;
            return vertex;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Iterable<Vertex> getVertices() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Vertex> getVertices(String arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GraphQuery query() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(Edge arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeVertex(Vertex arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(URI uri, URI prop, Literal val) {
        try {
            RepositoryConnection cxn = this.getWriteConnection();
            cxn.add((Resource)uri, prop, (Value)val, new Resource[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setProperty(URI uri, URI prop, Collection<Literal> vals) {
        try {
            RepositoryConnection cxn = this.getWriteConnection();
            for (Literal val : vals) {
                cxn.add((Resource)uri, prop, (Value)val, new Resource[0]);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Vertex addVertex(Object key) {
        try {
            String vid = key != null ? key.toString() : UUID.randomUUID().toString();
            URI uri = this.factory.toVertexURI(vid);
            this.getWriteConnection().add((Resource)uri, this.TYPE, (Value)this.VERTEX, new Resource[0]);
            return new BigdataVertex(uri, this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Edge addEdge(Object key, Vertex from, Vertex to, String label) {
        if (label == null) {
            throw new IllegalArgumentException();
        }
        String eid = key != null ? key.toString() : UUID.randomUUID().toString();
        URI edgeURI = this.factory.toEdgeURI(eid);
        try {
            URI fromURI = this.factory.toVertexURI(from.getId().toString());
            URI toURI = this.factory.toVertexURI(to.getId().toString());
            RepositoryConnection cxn = this.getWriteConnection();
            cxn.add((Resource)fromURI, edgeURI, (Value)toURI, new Resource[0]);
            cxn.add((Resource)edgeURI, this.TYPE, (Value)this.EDGE, new Resource[0]);
            cxn.add((Resource)edgeURI, this.LABEL, (Value)this.factory.toLiteral(label), new Resource[0]);
            return new BigdataEdge((Statement)new StatementImpl((Resource)fromURI, edgeURI, (Value)toURI), (BigdataGraph)this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void changeEvent(IChangeRecord record) {
        ++this.mutationCountTotal;
        ++this.mutationCountCurrentCommit;
    }

    @Override
    public void transactionBegin() {
    }

    @Override
    public void transactionPrepare() {
    }

    @Override
    public void transactionCommited(long commitTime) {
        this.mutationCountLastCommit = this.mutationCountCurrentCommit;
        this.mutationCountCurrentCommit = 0L;
    }

    @Override
    public void transactionAborted() {
    }

    public long getMutationCountTotal() {
        return this.mutationCountTotal;
    }

    public long getMutationCountCurrentCommit() {
        return this.mutationCountCurrentCommit;
    }

    public long getMutationCountLastCommit() {
        return this.mutationCountLastCommit;
    }

    static {
        BigdataGraphBulkLoad.FEATURES.supportsTransactions = true;
    }
}

