/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataGraph;
import com.bigdata.blueprints.BigdataGraphFactory;
import com.tinkerpop.rexster.config.GraphConfiguration;
import com.tinkerpop.rexster.config.GraphConfigurationContext;
import com.tinkerpop.rexster.config.GraphConfigurationException;
import org.apache.commons.configuration.Configuration;

public class BigdataGraphConfiguration
implements GraphConfiguration {
    public BigdataGraph configureGraphInstance(GraphConfigurationContext context) throws GraphConfigurationException {
        try {
            return this.configure(context);
        }
        catch (Exception ex) {
            throw new GraphConfigurationException((Throwable)ex);
        }
    }

    protected BigdataGraph configure(GraphConfigurationContext context) throws Exception {
        Configuration config = context.getProperties();
        if (!config.containsKey("properties.type")) {
            throw new GraphConfigurationException("missing required parameter: properties.type");
        }
        String type = config.getString("properties.type").toLowerCase();
        if ("embedded".equals(type)) {
            if (config.containsKey("properties.file")) {
                String journal = config.getString("properties.file");
                return BigdataGraphFactory.open(journal, true);
            }
            return BigdataGraphFactory.create();
        }
        if ("remote".equals(type)) {
            if (!config.containsKey("properties.host")) {
                throw new GraphConfigurationException("missing required parameter: properties.host");
            }
            if (!config.containsKey("properties.port")) {
                throw new GraphConfigurationException("missing required parameter: properties.port");
            }
            String host = config.getString("properties.host");
            int port = config.getInt("properties.port");
            return BigdataGraphFactory.connect(host, port);
        }
        throw new GraphConfigurationException("unrecognized value for properties.type: " + type);
    }

    public static interface Options {
        public static final String TYPE = "properties.type";
        public static final String TYPE_EMBEDDED = "embedded";
        public static final String TYPE_REMOTE = "remote";
        public static final String FILE = "properties.file";
        public static final String HOST = "properties.host";
        public static final String PORT = "properties.port";
    }
}

