/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IdFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class BOpIdFactory
implements IdFactory {
    private LinkedHashSet<Integer> ids;
    private int nextId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserve(int id) {
        BOpIdFactory bOpIdFactory = this;
        synchronized (bOpIdFactory) {
            if (this.ids == null) {
                this.ids = new LinkedHashSet();
                this.ids.add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextId() {
        BOpIdFactory bOpIdFactory = this;
        synchronized (bOpIdFactory) {
            if (this.ids != null) {
                while (this.ids.contains(this.nextId)) {
                    ++this.nextId;
                }
            }
            return this.nextId++;
        }
    }

    public void reserveIds(IPredicate<?>[] preds) {
        if (preds == null) {
            throw new IllegalArgumentException();
        }
        for (IPredicate<?> p : preds) {
            this.reserve(p.getId());
        }
    }

    public void reserveIds(IConstraint[] constraints) {
        if (constraints == null) {
            return;
        }
        for (IConstraint c : constraints) {
            Iterator<BOp> itr = BOpUtility.preOrderIteratorWithAnnotations(c);
            while (itr.hasNext()) {
                BOp y = itr.next();
                Integer anId = (Integer)y.getProperty(BOp.Annotations.BOP_ID);
                if (anId == null) continue;
                this.reserve(anId);
            }
        }
    }
}

