/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.ImmutableBOp;
import java.util.Collections;

public final class Constant<E>
extends ImmutableBOp
implements IConstant<E> {
    private static final long serialVersionUID = -2967861242470442497L;
    private final E value;

    @Override
    public final boolean isVar() {
        return false;
    }

    @Override
    public final boolean isConstant() {
        return true;
    }

    public Constant(Constant<E> op) {
        super(op);
        this.value = op.value;
    }

    public Constant(IVariable<E> var, E value) {
        super(BOp.NOARGS, Collections.singletonMap(Annotations.VAR, var));
        if (var == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value instanceof IConstant) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    public Constant(E value) {
        super(BOp.NOARGS, BOp.NOANNS);
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value instanceof IConstant) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    @Override
    public final Constant<E> clone() {
        return this;
    }

    @Override
    public String toString() {
        IVariable var = (IVariable)this.getProperty(Annotations.VAR);
        if (var != null) {
            return this.value.toString() + "[var=" + var + "]";
        }
        return this.value.toString();
    }

    @Override
    public final boolean equals(IVariableOrConstant<E> o) {
        return o.isConstant() && this.value.equals(o.get());
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IConstant)) {
            return false;
        }
        Object otherValue = ((IConstant)o).get();
        if (this.value == otherValue) {
            return true;
        }
        if (this.value == null) {
            return false;
        }
        return this.value.equals(otherValue);
    }

    @Override
    public final int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public final E get() {
        return this.value;
    }

    @Override
    public final E get(IBindingSet bindingSet) {
        return this.value;
    }

    @Override
    public final String getName() {
        throw new UnsupportedOperationException();
    }

    public final IVariable<E> getVar() {
        return (IVariable)this.getProperty(Annotations.VAR);
    }

    public static interface Annotations
    extends BOp.Annotations {
        public static final String VAR = Constant.class.getName() + ".var";
    }
}

