/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpEvaluationContext;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IValueExpression;
import com.bigdata.btree.Tuple;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public abstract class CoreBaseBOp
implements BOp {
    private static final long serialVersionUID = 1L;
    protected static final transient int DEFAULT_INITIAL_CAPACITY = 2;
    private int hash = 0;
    private static final transient String ws = "                                                                                                                                                                                                                                                                                                                                                                                                                                    ";

    protected void checkArgs(BOp[] args) {
    }

    @Override
    public CoreBaseBOp clone() {
        Class<?> cls = this.getClass();
        try {
            Constructor<?> ctor = cls.getConstructor(cls);
            return (CoreBaseBOp)ctor.newInstance(this);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toShortString() {
        CoreBaseBOp t = this;
        if (t instanceof IValueExpression || t instanceof IValueExpressionNode) {
            return t.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(t.getClass().getSimpleName());
        Integer tid = (Integer)t.getProperty(BOp.Annotations.BOP_ID);
        if (tid != null) {
            sb.append("[" + tid + "]");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        Integer bopId = (Integer)this.getProperty(BOp.Annotations.BOP_ID);
        if (bopId != null) {
            sb.append("[" + bopId + "]");
        }
        sb.append("(");
        int nwritten = 0;
        Iterator<BOp> itr = this.argIterator();
        while (itr.hasNext()) {
            BOp t = itr.next();
            if (nwritten > 0) {
                sb.append(',');
            }
            if (t == null) {
                sb.append("<null>");
            } else {
                sb.append(t.toShortString());
            }
            ++nwritten;
        }
        sb.append(")");
        this.annotationsToString(sb);
        return sb.toString();
    }

    protected void shortenName(StringBuilder sb, String longishName) {
        int lastDot = longishName.lastIndexOf(46);
        if (lastDot != -1) {
            int lastButOneDot = longishName.lastIndexOf(46, lastDot - 1);
            sb.append(longishName.substring(lastButOneDot + 1));
            return;
        }
        sb.append(longishName);
    }

    protected void annotationsToString(StringBuilder sb) {
        this.annotationsToString(sb, 0);
    }

    protected void annotationsToString(StringBuilder sb, int indent) {
        Map<String, Object> annotations = this.annotations();
        if (!annotations.isEmpty()) {
            sb.append("[");
            boolean first = true;
            for (Map.Entry<String, Object> e : annotations.entrySet()) {
                if (first) {
                    sb.append(" ");
                } else {
                    sb.append(", ");
                }
                String key = e.getKey();
                Object val = e.getValue();
                this.shortenName(sb, key);
                sb.append("=");
                if (val != null && val.getClass().isArray()) {
                    sb.append(Arrays.toString((Object[])val));
                } else if (key.equals(IPredicate.Annotations.FLAGS)) {
                    sb.append(Tuple.flagString((Integer)val));
                } else if (val instanceof BOp) {
                    this.annotationValueToString(sb, (BOp)val, indent);
                } else {
                    sb.append(val);
                }
                first = false;
            }
            sb.append("]");
        }
    }

    protected void annotationValueToString(StringBuilder sb, BOp val, int indent) {
        sb.append(val.toString());
    }

    @Override
    public final Object getRequiredProperty(String name) {
        Object tmp = this.getProperty(name);
        if (tmp == null) {
            throw new IllegalStateException("Required property: " + name + " : " + this.getClass());
        }
        return tmp;
    }

    @Override
    public final <T> T getProperty(String name, T defaultValue) {
        Object val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if (defaultValue != null && val.getClass() != defaultValue.getClass()) {
            if (defaultValue.getClass() == Integer.class) {
                return (T)Integer.valueOf("" + val);
            }
            if (defaultValue.getClass() == Long.class) {
                return (T)Long.valueOf("" + val);
            }
            if (defaultValue.getClass() == Float.class) {
                return (T)Float.valueOf("" + val);
            }
            if (defaultValue.getClass() == Double.class) {
                return (T)Double.valueOf("" + val);
            }
            if (defaultValue.getClass() == Boolean.class) {
                return (T)Boolean.valueOf("" + val);
            }
        }
        return (T)val;
    }

    @Override
    public final int getId() {
        return (Integer)this.getRequiredProperty(BOp.Annotations.BOP_ID);
    }

    @Override
    public final boolean isController() {
        return this.getProperty(BOp.Annotations.CONTROLLER, false);
    }

    @Override
    public final BOpEvaluationContext getEvaluationContext() {
        return this.getProperty(BOp.Annotations.EVALUATION_CONTEXT, BOp.Annotations.DEFAULT_EVALUATION_CONTEXT);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BOp)) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        BOp o = (BOp)other;
        int arity = this.arity();
        if (arity != o.arity()) {
            return false;
        }
        for (int i = 0; i < arity; ++i) {
            BOp y;
            BOp x = this.get(i);
            if (x == (y = o.get(i)) || x == null || x.equals(y)) continue;
            return false;
        }
        return this.annotationsEqual(o);
    }

    protected boolean annotationsEqual(BOp o) {
        Map<String, Object> m1 = this.annotations();
        Map<String, Object> m2 = o.annotations();
        return CoreBaseBOp.annotationsEqual(m1, m2);
    }

    protected static final boolean annotationsEqual(Map<String, Object> m1, Map<String, Object> m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 != null && m2 == null) {
            return false;
        }
        if (m1.size() != m2.size()) {
            return false;
        }
        for (Map.Entry<String, Object> e : m1.entrySet()) {
            Object v2;
            String name = e.getKey();
            Object v1 = e.getValue();
            if (v1 == (v2 = m2.get(name))) continue;
            if (v1 == null || v2 == null) {
                return false;
            }
            if (v1.getClass().isArray()) {
                if (!v2.getClass().isArray()) {
                    return false;
                }
                if (Arrays.equals((Object[])v1, (Object[])v2)) continue;
                return false;
            }
            if (v1.equals(v2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int n = this.arity();
            for (int i = 0; i < n; ++i) {
                BOp arg = this.get(i);
                h = 31 * h + (arg == null ? 0 : arg.hashCode());
            }
            this.hash = h;
        }
        return h;
    }

    public static String indent(int depth) {
        if (depth < 0) {
            return "";
        }
        return ws.substring(0, Math.min(ws.length(), depth * 2));
    }

    @Override
    public String toString(int indent) {
        return this.toString();
    }
}

