/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpBase;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BufferAnnotations;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.ISingleThreadedOp;
import com.bigdata.bop.engine.BOpStats;
import java.util.Map;
import java.util.concurrent.FutureTask;

public abstract class PipelineOp
extends BOpBase {
    private static final long serialVersionUID = 1L;

    protected PipelineOp(PipelineOp op) {
        super(op);
    }

    protected PipelineOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        if (this.getMaxParallel() < 1) {
            throw new IllegalArgumentException(Annotations.MAX_PARALLEL + "=" + this.getMaxParallel());
        }
        if (this.isLastPassRequested()) {
            if (this.getMaxParallel() != 1) {
                throw new IllegalArgumentException(Annotations.MAX_PARALLEL + "=" + this.getMaxParallel());
            }
            if (!this.isPipelinedEvaluation()) {
                throw new UnsupportedOperationException(Annotations.PIPELINED + "=" + this.isPipelinedEvaluation());
            }
        }
    }

    public final int getChunkCapacity() {
        return this.getProperty(Annotations.CHUNK_CAPACITY, 100);
    }

    public final int getChunkOfChunksCapacity() {
        return this.getProperty(Annotations.CHUNK_OF_CHUNKS_CAPACITY, 5);
    }

    public final long getChunkTimeout() {
        return this.getProperty(Annotations.CHUNK_TIMEOUT, 10).intValue();
    }

    public final boolean isReorderSolutions() {
        return this.getProperty(Annotations.REORDER_SOLUTIONS, true);
    }

    public final long getMaxMemory() {
        return this.getProperty(Annotations.MAX_MEMORY, 0L);
    }

    public final boolean isPipelinedEvaluation() {
        return this.getProperty(Annotations.PIPELINED, true);
    }

    public final boolean isAtOnceEvaluation() {
        if (this.isPipelinedEvaluation()) {
            return false;
        }
        long maxMemory = this.getMaxMemory();
        if (maxMemory == 0L) {
            return true;
        }
        return maxMemory == Long.MAX_VALUE;
    }

    public final boolean isBlockedEvaluation() {
        if (this.isPipelinedEvaluation()) {
            return false;
        }
        long maxMemory = this.getMaxMemory();
        return maxMemory > 0L && maxMemory < Long.MAX_VALUE;
    }

    protected void assertAtOnceJavaHeapOp() {
        if (this.isPipelinedEvaluation()) {
            throw new UnsupportedOperationException(Annotations.PIPELINED + "=" + this.isPipelinedEvaluation());
        }
        long maxMemory = this.getMaxMemory();
        if (maxMemory != 0L) {
            throw new UnsupportedOperationException(Annotations.MAX_MEMORY + "=" + maxMemory);
        }
    }

    protected final void assertMaxParallelOne() {
        if (this.getProperty(Annotations.MAX_PARALLEL, 5) != 1) {
            throw new IllegalArgumentException(Annotations.MAX_PARALLEL + "=" + this.getMaxParallel());
        }
    }

    public final int getMaxParallel() {
        if (this instanceof ISingleThreadedOp) {
            return 1;
        }
        return this.getProperty(Annotations.MAX_PARALLEL, 5);
    }

    public final boolean isLastPassRequested() {
        return this.getProperty(Annotations.LAST_PASS, false);
    }

    public final boolean isSharedState() {
        return this.getProperty(Annotations.SHARED_STATE, false);
    }

    public BOpStats newStats() {
        return new BOpStats();
    }

    public abstract FutureTask<Void> eval(BOpContext<IBindingSet> var1);

    public static interface Annotations
    extends BOp.Annotations,
    BufferAnnotations {
        public static final String SINK_REF = PipelineOp.class.getName() + ".sinkRef";
        public static final String ALT_SINK_REF = PipelineOp.class.getName() + ".altSinkRef";
        public static final String SHARED_STATE = PipelineOp.class.getName() + ".sharedState";
        public static final boolean DEFAULT_SHARED_STATE = false;
        public static final String REORDER_SOLUTIONS = PipelineOp.class.getName() + ".reorderSolutions";
        public static final boolean DEFAULT_REORDER_SOLUTIONS = true;
        public static final String MAX_PARALLEL = PipelineOp.class.getName() + ".maxParallel";
        public static final int DEFAULT_MAX_PARALLEL = 5;
        public static final String MAX_MESSAGES_PER_TASK = PipelineOp.class.getName() + ".maxMessagesPerTask";
        public static final int DEFAULT_MAX_MESSAGES_PER_TASK = 10;
        public static final String PIPELINE_QUEUE_CAPACITY = PipelineOp.class.getName() + ".pipelineQueueCapacity";
        public static final int DEFAULT_PIPELINE_QUEUE_CAPACITY = 10;
        public static final String PIPELINED = PipelineOp.class.getName() + ".pipelined";
        public static final boolean DEFAULT_PIPELINED = true;
        public static final String MAX_MEMORY = PipelineOp.class.getName() + ".maxMemory";
        public static final long DEFAULT_MAX_MEMORY = 0L;
        public static final String LAST_PASS = PipelineOp.class.getName() + ".lastPass";
        public static final boolean DEFAULT_LAST_PASS = false;
    }
}

