/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.ImmutableBOp;
import com.bigdata.cache.ConcurrentWeakValueCache;
import java.io.ObjectStreamException;
import java.util.UUID;

public final class Var<E>
extends ImmutableBOp
implements IVariable<E>,
Comparable<IVariable<E>> {
    private static final long serialVersionUID = -7100443208125002485L;
    private boolean anonymous = false;
    private final String name;
    private static final ConcurrentWeakValueCache<String, Var<?>> vars = new ConcurrentWeakValueCache(0);

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public final boolean isVar() {
        return true;
    }

    @Override
    public final boolean isConstant() {
        return false;
    }

    private Var(String name) {
        super(BOp.NOARGS, BOp.NOANNS);
        assert (name != null);
        this.name = name;
    }

    @Override
    public final Var<E> clone() {
        return this;
    }

    @Override
    public final boolean equals(IVariableOrConstant<E> o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IVariable) {
            return this.name.equals(((IVariable)o).getName());
        }
        return false;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IVariable) {
            return this.name.equals(((IVariable)o).getName());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean isWildcard() {
        return this.name.length() == 1 && this.name.charAt(0) == '*';
    }

    @Override
    public E get() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(IBindingSet bindingSet) {
        if (bindingSet == null) {
            throw new IllegalArgumentException();
        }
        IConstant c = bindingSet.get(this);
        return c == null ? null : (E)c.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static Var<?> var() {
        return Var.var(UUID.randomUUID().toString());
    }

    public static Var var(String name) {
        Var tmp;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException();
        }
        Var<Object> var = vars.get(name);
        if (var == null && (tmp = vars.putIfAbsent(name, var = new Var(name))) != null) {
            var = tmp;
        }
        return var;
    }

    @Override
    public int compareTo(IVariable<E> o) {
        return this.name.compareTo(o.getName());
    }

    private Object readResolve() throws ObjectStreamException {
        return Var.var(this.name);
    }
}

