/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.bindingSet;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class HashBindingSet
implements IBindingSet {
    private static final long serialVersionUID = -2989802566387532422L;
    private final LinkedHashMap<IVariable, IConstant> current;
    private int hash;

    private LinkedHashMap<IVariable, IConstant> current() {
        return this.current;
    }

    public HashBindingSet() {
        this.current = new LinkedHashMap();
    }

    protected HashBindingSet(HashBindingSet src, IVariable[] variablesToKeep) {
        this.current = this.copy(src.current, variablesToKeep);
    }

    private LinkedHashMap<IVariable, IConstant> copy(LinkedHashMap<IVariable, IConstant> src, IVariable[] variablesToKeep) {
        LinkedHashMap<IVariable, IConstant> dst = new LinkedHashMap<IVariable, IConstant>(variablesToKeep != null ? variablesToKeep.length : src.size());
        for (Map.Entry<IVariable, IConstant> e : src.entrySet()) {
            boolean keep = true;
            if (variablesToKeep != null) {
                keep = false;
                for (IVariable x : variablesToKeep) {
                    if (x != e.getKey()) continue;
                    keep = true;
                    break;
                }
            }
            if (!keep) continue;
            dst.put(e.getKey(), e.getValue());
        }
        return dst;
    }

    HashBindingSet(IBindingSet src) {
        this();
        Iterator<Map.Entry<IVariable, IConstant>> itr = src.iterator();
        while (itr.hasNext()) {
            Map.Entry<IVariable, IConstant> e = itr.next();
            this.set(e.getKey(), e.getValue());
        }
    }

    HashBindingSet(IVariable[] vars, IConstant[] vals) {
        this();
        if (vars == null) {
            throw new IllegalArgumentException();
        }
        if (vals == null) {
            throw new IllegalArgumentException();
        }
        if (vars.length != vals.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < vars.length; ++i) {
            this.set(vars[i], vals[i]);
        }
    }

    @Override
    public HashBindingSet clone() {
        return new HashBindingSet(this, null);
    }

    @Override
    public HashBindingSet copy(IVariable[] variablesToKeep) {
        return new HashBindingSet(this, variablesToKeep);
    }

    @Override
    public boolean isBound(IVariable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        return this.current().containsKey(var);
    }

    @Override
    public IConstant get(IVariable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        return this.current().get(var);
    }

    @Override
    public void set(IVariable var, IConstant val) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        if (val == null) {
            throw new IllegalArgumentException();
        }
        this.current().put(var, val);
        this.hash = 0;
    }

    @Override
    public void clear(IVariable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        this.current().remove(var);
        this.hash = 0;
    }

    @Override
    public void clearAll() {
        this.current().clear();
        this.hash = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        int i = 0;
        Iterator<Map.Entry<IVariable, IConstant>> itr = this.current().entrySet().iterator();
        while (itr.hasNext()) {
            if (i > 0) {
                sb.append(", ");
            }
            Map.Entry<IVariable, IConstant> entry = itr.next();
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            ++i;
        }
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public Iterator<Map.Entry<IVariable, IConstant>> iterator() {
        return this.current().entrySet().iterator();
    }

    @Override
    public Iterator<IVariable> vars() {
        return Collections.unmodifiableSet(this.current().keySet()).iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.current().isEmpty();
    }

    @Override
    public int size() {
        return this.current().size();
    }

    @Override
    public boolean equals(Object t) {
        if (this == t) {
            return true;
        }
        if (!(t instanceof IBindingSet)) {
            return false;
        }
        IBindingSet o = (IBindingSet)t;
        if (this.size() != o.size()) {
            return false;
        }
        for (Map.Entry<IVariable, IConstant> entry : this.current().entrySet()) {
            IVariable var = entry.getKey();
            IConstant val = entry.getValue();
            IConstant o_val = o.get(var);
            if (null != o_val && val.equals((Object)o_val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            int result = 0;
            for (IConstant c : this.current().values()) {
                if (c == null) continue;
                result ^= c.hashCode();
            }
            this.hash = result;
        }
        return this.hash;
    }
}

