/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.DefaultQueryAttributes;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IQueryAttributes;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.engine.BlockingBufferWithStats;
import com.bigdata.bop.engine.IChunkMessage;
import com.bigdata.bop.engine.IHaltOpMessage;
import com.bigdata.bop.engine.IQueryClient;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.IStartOpMessage;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.engine.QueryLog;
import com.bigdata.bop.engine.QueryResultIterator;
import com.bigdata.bop.engine.QueryTimeoutException;
import com.bigdata.bop.engine.RunState;
import com.bigdata.bop.fed.EmptyChunkMessage;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sparql.ast.QueryHints;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.rwstore.sector.IMemoryManager;
import com.bigdata.rwstore.sector.MemoryManager;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.Haltable;
import com.bigdata.util.concurrent.IHaltable;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.nio.channels.ClosedByInterruptException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class AbstractRunningQuery
implements IRunningQuery {
    protected static final String ERR_NOT_CONTROLLER = "Operator only permitted on the query controller";
    protected static final String ERR_QUERY_DONE = "Query is no longer running";
    protected static final String ERR_NOT_PIPELINE_START = "Not pipeline start";
    protected static final String ERR_NO_SUCH_BOP = "No such bop: id=";
    protected static final String ERR_DUPLICATE_IDENTIFIER = "Duplicate identifier: id=";
    private static final transient Logger log = Logger.getLogger(AbstractRunningQuery.class);
    private final QueryEngine queryEngine;
    private final UUID queryId;
    private final AtomicLong startTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicLong doneTime = new AtomicLong(0L);
    private final boolean controller;
    private final IQueryClient clientProxy;
    private final IChunkMessage<IBindingSet> realSource;
    private final PipelineOp query;
    private final Map<Integer, BOp> bopIndex;
    private final Haltable<Void> future = new Haltable();
    private final ConcurrentHashMap<Integer, BOpStats> statsMap;
    private final IBlockingBuffer<IBindingSet[]> queryBuffer;
    private final ICloseableIterator<IBindingSet[]> queryIterator;
    protected final ReentrantLock lock = new ReentrantLock();
    private final RunState runState;
    private final AtomicBoolean didQueryTearDown = new AtomicBoolean(false);
    private final AtomicReference<IMemoryManager> memoryManager = new AtomicReference();
    private final IQueryAttributes queryAttributes = new DefaultQueryAttributes();
    private static final IRunningQuery[] EMPTY_ARRAY = new IRunningQuery[0];
    private final LinkedHashMap<UUID, IRunningQuery> children = new LinkedHashMap();

    protected final IHaltable<Void> getFuture() {
        return this.future;
    }

    public final void setDeadline(long deadline) {
        if (!this.controller) {
            throw new UnsupportedOperationException(ERR_NOT_CONTROLLER);
        }
        try {
            this.runState.setDeadline(deadline);
            this.queryEngine.addQueryToDeadlineQueue(this);
        }
        catch (QueryTimeoutException e) {
            this.halt((Throwable)e);
        }
    }

    protected final void checkDeadline() {
        if (this.isDone()) {
            return;
        }
        try {
            this.runState.checkDeadline();
        }
        catch (QueryTimeoutException ex) {
            this.halt((Throwable)ex);
        }
    }

    @Override
    public final long getDeadline() {
        return this.runState.getDeadline();
    }

    @Override
    public final long getStartTime() {
        return this.startTime.get();
    }

    @Override
    public final long getDoneTime() {
        return this.doneTime.get();
    }

    @Override
    public final long getElapsed() {
        long mark = this.doneTime.get();
        if (mark == 0L) {
            mark = System.currentTimeMillis();
        }
        return mark - this.startTime.get();
    }

    protected final IBlockingBuffer<IBindingSet[]> getQueryBuffer() {
        return this.queryBuffer;
    }

    @Override
    public QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    @Override
    public final IQueryClient getQueryController() {
        return this.clientProxy;
    }

    @Override
    public final UUID getQueryId() {
        return this.queryId;
    }

    @Override
    public final PipelineOp getQuery() {
        return this.query;
    }

    public final boolean isController() {
        return this.controller;
    }

    @Override
    public final Map<Integer, BOpStats> getStats() {
        return Collections.unmodifiableMap(this.statsMap);
    }

    public final BOpStats getStats(Integer bopId) {
        if (bopId == null) {
            throw new IllegalArgumentException();
        }
        if (this.statsMap == null) {
            throw new IllegalStateException("bopId=" + bopId + ", query=" + BOpUtility.toString(this.query));
        }
        return this.statsMap.get(bopId);
    }

    @Override
    public final Map<Integer, BOp> getBOpIndex() {
        return this.bopIndex;
    }

    public final BOp getBOp(int bopId) {
        BOp bop = this.getBOpIndex().get(bopId);
        if (bop == null) {
            throw new IllegalArgumentException("Not found: id=" + bopId + ", query=" + this.query);
        }
        return bop;
    }

    public AbstractRunningQuery(QueryEngine queryEngine, UUID queryId, boolean controller, IQueryClient clientProxy, PipelineOp query, IChunkMessage<IBindingSet> realSource) {
        if (queryEngine == null) {
            throw new IllegalArgumentException();
        }
        if (queryId == null) {
            throw new IllegalArgumentException();
        }
        if (clientProxy == null) {
            throw new IllegalArgumentException();
        }
        if (query == null) {
            throw new IllegalArgumentException();
        }
        this.queryEngine = queryEngine;
        this.queryId = queryId;
        this.controller = controller;
        this.clientProxy = clientProxy;
        this.query = query;
        this.realSource = realSource;
        this.bopIndex = BOpUtility.getIndex(query);
        if (controller) {
            this.runState = new RunState(this);
            this.statsMap = new ConcurrentHashMap();
            this.populateStatsMap(query);
            BOpStats queryStats = this.statsMap.get(query.getId());
            this.queryBuffer = this.newQueryBuffer(query, queryStats);
            this.queryIterator = new QueryResultIterator<IBindingSet[]>(this, this.queryBuffer.iterator());
        } else {
            this.runState = null;
            this.statsMap = null;
            this.queryBuffer = null;
            this.queryIterator = null;
        }
    }

    protected final IBlockingBuffer<IBindingSet[]> newQueryBuffer(PipelineOp query, BOpStats queryStats) {
        return new BlockingBufferWithStats<IBindingSet[]>(query, queryStats);
    }

    private void populateStatsMap(BOp op) {
        if (!(op instanceof PipelineOp)) {
            return;
        }
        PipelineOp bop = (PipelineOp)op;
        int bopId = bop.getId();
        BOpStats stats = bop.newStats();
        this.statsMap.put(bopId, stats);
        Iterator<BOp> itr = op.argIterator();
        while (itr.hasNext()) {
            BOp t = itr.next();
            this.populateStatsMap(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void startQuery(IChunkMessage<IBindingSet> msg) {
        if (!this.controller) {
            throw new UnsupportedOperationException(ERR_NOT_CONTROLLER);
        }
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        if (!this.queryId.equals(msg.getQueryId())) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            this.runState.startQuery(msg);
        }
        catch (TimeoutException ex) {
            this.halt((Throwable)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void startOp(IStartOpMessage msg) {
        if (!this.controller) {
            throw new UnsupportedOperationException(ERR_NOT_CONTROLLER);
        }
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        if (!this.queryId.equals(msg.getQueryId())) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)msg.toString());
            }
            this.runState.startOp(msg);
        }
        catch (TimeoutException ex) {
            this.halt((Throwable)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void haltOp(IHaltOpMessage msg) {
        if (!this.controller) {
            throw new UnsupportedOperationException(ERR_NOT_CONTROLLER);
        }
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        if (!this.queryId.equals(msg.getQueryId())) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            BOpStats tmp;
            if (log.isTraceEnabled()) {
                log.trace((Object)msg.toString());
            }
            if ((tmp = this.statsMap.putIfAbsent(msg.getBOpId(), msg.getStats())) == null) {
                tmp = msg.getStats();
            } else if (tmp != msg.getStats()) {
                tmp.add(msg.getStats());
            }
            tmp.opCount.increment();
            switch (this.runState.haltOp(msg)) {
                case Running: 
                case RunningLastPass: {
                    return;
                }
                case StartLastPass: {
                    Set doneOn = this.runState.getDoneOn(msg.getBOpId());
                    this.doLastPass(msg.getBOpId(), doneOn);
                    return;
                }
                case AllDone: {
                    this.triggerOperatorsAwaitingLastPass();
                    this.releaseNativeMemoryForOperator(msg.getBOpId());
                    if (this.runState.isAllDone()) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Query reports all done: bopId=" + msg.getBOpId() + ", msg=" + msg + ", runState=" + this.runState));
                        }
                        this.halt((Void)null);
                    }
                    return;
                }
            }
            try {
                throw new AssertionError();
            }
            catch (Throwable t) {
                this.halt(t);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void triggerOperatorsAwaitingLastPass() {
        for (Integer bopId : this.runState.getAtOnceRequired()) {
            if (this.runState.getOperatorRunState(bopId) != RunState.RunStateEnum.StartLastPass) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("Triggering at-once (no solutions in): " + bopId));
            }
            EmptyChunkMessage<IBindingSet> emptyMessage = new EmptyChunkMessage<IBindingSet>(this.getQueryController(), this.queryId, bopId, -1, true);
            this.acceptChunk(emptyMessage);
        }
        if (this.runState.getTotalLastPassRemainingCount() == 0L) {
            return;
        }
        for (Integer bopId : this.runState.getLastPassRequested()) {
            if (this.runState.getOperatorRunState(bopId) != RunState.RunStateEnum.StartLastPass) continue;
            Set doneOn = this.runState.getDoneOn(bopId);
            if (log.isInfoEnabled()) {
                log.info((Object)("Triggering last pass: " + bopId));
            }
            this.doLastPass(bopId, doneOn);
        }
    }

    protected void doLastPass(int bopId, Set doneOn) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (doneOn == null) {
            throw new AssertionError((Object)("doneOn is null? : bopId=" + bopId + ", runState=" + this.runState));
        }
        if (doneOn.isEmpty()) {
            throw new AssertionError((Object)("doneOn is empty? : bopId=" + bopId + ", runState=" + this.runState));
        }
        if (doneOn.size() != 1) {
            throw new AssertionError((Object)("doneOn set not single element? : bopId=" + bopId + ", runState=" + this.runState + ", doneOn=" + doneOn));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Triggering last pass: " + bopId));
        }
        EmptyChunkMessage<IBindingSet> emptyMessage = new EmptyChunkMessage<IBindingSet>(this.getQueryController(), this.queryId, bopId, -1, true);
        this.acceptChunk(emptyMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAtOnceReady(int bopId) {
        this.lock.lock();
        try {
            boolean bl = this.runState.isAtOnceReady(bopId);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunState.RunStateEnum getRunState(int bopId) {
        this.lock.lock();
        try {
            RunState.RunStateEnum runStateEnum = this.runState.getOperatorRunState(bopId);
            return runStateEnum;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunState.RunStateEnum tryGetRunState(int bopId) {
        if (this.lock.tryLock()) {
            try {
                RunState.RunStateEnum runStateEnum = this.runState.getOperatorRunState(bopId);
                return runStateEnum;
            }
            finally {
                this.lock.unlock();
            }
        }
        return null;
    }

    protected void releaseNativeMemoryForOperator(int bopId) {
    }

    protected void releaseNativeMemoryForQuery() {
        assert (this.lock.isHeldByCurrentThread());
        IMemoryManager memoryManager = this.memoryManager.getAndSet(null);
        if (memoryManager != null) {
            memoryManager.clear();
        }
    }

    protected abstract boolean acceptChunk(IChunkMessage<IBindingSet> var1);

    protected abstract void consumeChunk();

    @Override
    public final ICloseableIterator<IBindingSet[]> iterator() {
        if (!this.controller) {
            throw new UnsupportedOperationException(ERR_NOT_CONTROLLER);
        }
        if (this.queryIterator == null) {
            throw new UnsupportedOperationException();
        }
        return this.queryIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void halt(Void v) {
        this.lock.lock();
        try {
            this.future.halt(v);
            this.cancel(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T extends Throwable> T halt(T t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            T t2;
            try {
                t2 = this.future.halt(t);
                this.cancel(true);
            }
            catch (Throwable throwable) {
                this.cancel(true);
                throw throwable;
            }
            return t2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        boolean interrupted = false;
        this.lock.lock();
        try {
            boolean cancelled = this.future.cancel(mayInterruptIfRunning);
            if (this.didQueryTearDown.compareAndSet(false, true)) {
                if (this.realSource != null) {
                    this.realSource.release();
                }
                this.releaseAcceptedMessages();
                cancelled |= this.cancelRunningOperators(mayInterruptIfRunning);
                interrupted |= Thread.interrupted();
                if (this.controller) {
                    cancelled |= this.cancelQueryOnPeers(this.future.getCause(), this.runState.getServiceIds());
                }
                if (this.queryBuffer != null) {
                    this.queryBuffer.close();
                }
                this.releaseNativeMemoryForQuery();
                this.doneTime.set(System.currentTimeMillis());
                if (this.isController()) {
                    QueryLog.log(this);
                }
                this.queryEngine.counters.queryDoneCount.increment();
                long elapsed = this.getElapsed();
                this.queryEngine.counters.elapsedMillis.add(elapsed);
                if (this.future.getCause() != null) {
                    this.queryEngine.counters.queryErrorCount.increment();
                }
                this.queryEngine.halt(this);
            }
            boolean bl = cancelled;
            return bl;
        }
        finally {
            this.lock.unlock();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected abstract boolean cancelRunningOperators(boolean var1);

    protected abstract void releaseAcceptedMessages();

    protected boolean cancelQueryOnPeers(Throwable cause, Set<UUID> startedOn) {
        if (!this.controller) {
            throw new UnsupportedOperationException(ERR_NOT_CONTROLLER);
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return false;
    }

    @Override
    public final Void get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public final Void get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(arg0, arg1);
    }

    @Override
    public final boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public final Throwable getCause() {
        return this.future.getCause();
    }

    @Override
    public final Throwable getAsThrownCause() {
        return this.future.getAsThrownCause();
    }

    @Override
    public IBigdataFederation<?> getFederation() {
        return this.queryEngine.getFederation();
    }

    @Override
    public IIndexManager getLocalIndexManager() {
        return this.queryEngine.getIndexManager();
    }

    protected long getRunningCount(int bopId) {
        return this.runState.getRunningCount(bopId);
    }

    protected int getStartedOnCount(int bopId) {
        return this.runState.getStartedOnCount(bopId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMemoryManager getMemoryManager() {
        IMemoryManager memoryManager = this.memoryManager.get();
        if (memoryManager == null) {
            this.lock.lock();
            try {
                memoryManager = this.memoryManager.get();
                if (memoryManager == null) {
                    memoryManager = this.newMemoryManager();
                    this.memoryManager.set(memoryManager);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return memoryManager;
    }

    private IMemoryManager newMemoryManager() {
        int nsectors;
        boolean blocking;
        DirectBufferPool pool = DirectBufferPool.INSTANCE;
        long maxMemoryBytesPerQuery = QueryHints.DEFAULT_ANALYTIC_MAX_MEMORY_PER_QUERY;
        if (maxMemoryBytesPerQuery < 0L) {
            maxMemoryBytesPerQuery = 0L;
        }
        if (maxMemoryBytesPerQuery == 0L) {
            blocking = true;
            nsectors = Integer.MAX_VALUE;
        } else {
            blocking = false;
            int bufferCapacity = pool.getBufferCapacity();
            nsectors = (int)Math.ceil((double)maxMemoryBytesPerQuery / (double)bufferCapacity);
        }
        return new MemoryManager(pool, nsectors, blocking, null);
    }

    @Override
    public final IQueryAttributes getAttributes() {
        return this.queryAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IRunningQuery[] getChildren() {
        LinkedHashMap<UUID, IRunningQuery> linkedHashMap = this.children;
        synchronized (linkedHashMap) {
            if (this.children.isEmpty()) {
                return EMPTY_ARRAY;
            }
            LinkedList<IRunningQuery> tmp = new LinkedList<IRunningQuery>(this.children.values());
            for (IRunningQuery c : this.children.values()) {
                tmp.addAll(Arrays.asList(((AbstractRunningQuery)c).getChildren()));
            }
            return tmp.toArray(new IRunningQuery[tmp.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addChild(IRunningQuery childQuery) {
        LinkedHashMap<UUID, IRunningQuery> linkedHashMap = this.children;
        synchronized (linkedHashMap) {
            UUID childId = childQuery.getQueryId();
            if (this.children.containsKey(childId)) {
                return false;
            }
            this.children.put(childId, childQuery);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String runStateString() {
        this.lock.lock();
        try {
            String string = this.runState.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("{queryId=" + this.queryId);
        this.lock.lock();
        try {
            sb.append(",elapsed=" + this.getElapsed());
            sb.append(",deadline=" + this.runState.getDeadline());
            sb.append(",isDone=" + this.isDone());
            sb.append(",isCancelled=" + this.isCancelled());
            sb.append(",runState=" + this.runState);
        }
        finally {
            this.lock.unlock();
        }
        sb.append(",controller=" + this.controller);
        sb.append(",clientProxy=" + this.clientProxy);
        sb.append(",query=" + this.query);
        sb.append("}");
        return sb.toString();
    }

    public static boolean isRootCauseInterrupt(Throwable t) {
        if (InnerCause.isInnerCause(t, InterruptedException.class)) {
            return true;
        }
        if (InnerCause.isInnerCause(t, ClosedByInterruptException.class)) {
            return true;
        }
        return InnerCause.isInnerCause(t, InterruptedException.class);
    }
}

