/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.BufferAnnotations;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.relation.accesspath.BlockingBuffer;
import java.util.concurrent.TimeUnit;

public class BlockingBufferWithStats<E>
extends BlockingBuffer<E> {
    private final BOpStats stats;

    public BlockingBufferWithStats(PipelineOp op, BOpStats stats) {
        super(op.getChunkOfChunksCapacity(), op.getChunkCapacity(), op.getChunkTimeout(), BufferAnnotations.chunkTimeoutUnit);
        this.stats = stats;
    }

    @Override
    public boolean add(E e, long timeout, TimeUnit unit) throws InterruptedException {
        boolean ret = super.add(e, timeout, unit);
        if (ret) {
            int n = e.getClass().getComponentType() != null ? ((Object[])e).length : 1;
            this.stats.unitsOut.add(n);
            this.stats.chunksOut.increment();
        }
        return ret;
    }
}

