/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpEvaluationContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.NoBOpIdException;
import com.bigdata.bop.NoSuchBOpException;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.engine.IChunkMessage;
import com.bigdata.bop.engine.IHaltOpMessage;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.IStartOpMessage;
import com.bigdata.bop.engine.QueryTimeoutException;
import com.bigdata.bop.join.PipelineJoinStats;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

class RunState {
    private static final Logger log = Logger.getLogger(RunState.class);
    private static final transient String ERR_QUERY_STARTED = "Query already running.";
    private static final transient String ERR_QUERY_HALTED = "Query already halted.";
    private static final transient String ERR_OP_NOT_STARTED = "Operator never ran.";
    private static final transient String ERR_OP_HALTED = "Operator is not running.";
    private static final transient String ERR_DEADLINE = "Query deadline is expired.";
    private final InnerState innerState;

    public final UUID getQueryId() {
        return this.innerState.queryId;
    }

    public final long getDeadline() {
        return this.innerState.deadline.get();
    }

    public final void setDeadline(long deadline) throws QueryTimeoutException {
        if (deadline <= 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.innerState.deadline.compareAndSet(Long.MAX_VALUE, deadline)) {
            throw new IllegalStateException();
        }
        if (deadline < System.currentTimeMillis()) {
            throw new QueryTimeoutException();
        }
    }

    public final boolean isStarted() {
        return this.innerState.started.get();
    }

    public final boolean isAllDone() {
        return this.innerState.allDone.get();
    }

    public final long getStepCount() {
        return this.innerState.stepCount.get();
    }

    public final long getTotalRunningCount() {
        return this.innerState.totalRunningCount.get();
    }

    public final long getTotalAvailableCount() {
        return this.innerState.totalAvailableCount.get();
    }

    public final long getTotalLastPassRemainingCount() {
        return this.innerState.totalLastPassRemainingCount.get();
    }

    final Set<UUID> getServiceIds() {
        return Collections.unmodifiableSet(this.innerState.serviceIds);
    }

    final long getRunningCount(int bopId) {
        AtomicLong runningCount = this.innerState.runningMap.get(bopId);
        if (runningCount == null) {
            return 0L;
        }
        return runningCount.get();
    }

    final int getStartedOnCount(int bopId) {
        Set<?> startedOn = this.innerState.startedOn.get(bopId);
        if (startedOn == null) {
            return 0;
        }
        return startedOn.size();
    }

    final Set getDoneOn(int bopId) {
        Set set = this.innerState.doneOn.get(bopId);
        if (set == null) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    final Set<Integer> getLastPassRequested() {
        return Collections.unmodifiableSet(this.innerState.lastPassRequested);
    }

    final Set<Integer> getAtOnceRequired() {
        return Collections.unmodifiableSet(this.innerState.atOnceRequired);
    }

    public RunState(IRunningQuery query) {
        this(new InnerState(query.getQuery(), query.getQueryId(), Long.MAX_VALUE, System.currentTimeMillis(), query.getBOpIndex()));
    }

    RunState(InnerState innerState) {
        if (innerState == null) {
            throw new IllegalArgumentException();
        }
        this.innerState = innerState;
    }

    public synchronized void startQuery(IChunkMessage<?> msg) throws QueryTimeoutException {
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        if (this.innerState.allDone.get()) {
            throw new IllegalStateException(ERR_QUERY_HALTED);
        }
        this.checkDeadline();
        if (!this.innerState.started.compareAndSet(false, true)) {
            throw new IllegalStateException(ERR_QUERY_STARTED);
        }
        this.innerState.stepCount.incrementAndGet();
        this.messagesProduced(msg.getBOpId(), 1);
        UUID controllerId = msg.getQueryControllerId();
        Iterator<BOp> itr = BOpUtility.preOrderIterator(this.innerState.query);
        while (itr.hasNext()) {
            BOp op = itr.next();
            if (op.getEvaluationContext() != BOpEvaluationContext.CONTROLLER) continue;
            boolean lastPassRequested = ((PipelineOp)op).isLastPassRequested();
            boolean atOnceRequired = ((PipelineOp)op).isAtOnceEvaluation();
            if (!atOnceRequired && !lastPassRequested) continue;
            Integer id = (Integer)op.getProperty(BOp.Annotations.BOP_ID);
            if (id == null) {
                throw new NoBOpIdException(op.toString());
            }
            boolean didAdd = false;
            if (atOnceRequired) {
                didAdd = this.innerState.atOnceRequired.add(id);
            }
            if (lastPassRequested && (didAdd = this.innerState.lastPassRequested.add(id))) {
                this.innerState.totalLastPassRemainingCount.incrementAndGet();
            }
            if (!didAdd) continue;
            this.innerState.runningMap.put((int)id, new AtomicLong());
            LinkedHashSet<UUID> set = new LinkedHashSet<UUID>();
            set.add(controllerId);
            this.innerState.startedOn.put(id, set);
            this.messagesConsumed(id, 0);
        }
        this.innerState.serviceIds.add(controllerId);
        if (TableLog.tableLog.isInfoEnabled()) {
            TableLog.tableLog.info((Object)this.getTableHeader());
            TableLog.tableLog.info((Object)this.getTableRow("startQ", controllerId, msg.getBOpId(), -1, 1, null, null));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("startQ : " + this.toString()));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)msg.toString());
        }
    }

    public synchronized boolean startOp(IStartOpMessage msg) throws QueryTimeoutException {
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        if (this.innerState.allDone.get()) {
            throw new IllegalStateException(ERR_QUERY_HALTED);
        }
        this.checkDeadline();
        this.innerState.stepCount.incrementAndGet();
        boolean firstTime = this._startOp(msg);
        this.messagesConsumed(msg.getBOpId(), msg.getChunkMessageCount());
        Integer bopId = msg.getBOpId();
        PipelineOp bop = (PipelineOp)this.innerState.bopIndex.get(bopId);
        if (bop.isLastPassRequested() && this.innerState.lastPassRequested.add(bopId)) {
            this.innerState.totalLastPassRemainingCount.incrementAndGet();
        }
        this.innerState.serviceIds.add(msg.getServiceId());
        if (TableLog.tableLog.isInfoEnabled()) {
            TableLog.tableLog.info((Object)this.getTableRow("startOp", msg.getServiceId(), msg.getBOpId(), msg.getPartitionId(), msg.getChunkMessageCount(), null, null));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("startOp: " + this.toString() + " : bop=" + msg.getBOpId()));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)msg.toString());
        }
        return firstTime;
    }

    protected void checkDeadline() throws QueryTimeoutException {
        if (this.innerState.deadline.get() < System.currentTimeMillis()) {
            throw new QueryTimeoutException(ERR_DEADLINE);
        }
    }

    public synchronized RunStateEnum haltOp(IHaltOpMessage msg) throws QueryTimeoutException, ExecutionException {
        boolean isAllDone;
        BOp p;
        Integer sinkId;
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        if (this.innerState.allDone.get()) {
            throw new IllegalStateException(ERR_QUERY_HALTED);
        }
        this.checkDeadline();
        this.innerState.stepCount.incrementAndGet();
        PipelineOp bop = (PipelineOp)this.innerState.bopIndex.get(msg.getBOpId());
        if (bop == null) {
            throw new IllegalArgumentException();
        }
        if (msg.getSinkMessagesOut() != 0 && (sinkId = BOpUtility.getEffectiveDefaultSink(bop, p = BOpUtility.getParent(this.innerState.query, bop))) != null) {
            this.messagesProduced(sinkId, msg.getSinkMessagesOut());
        }
        if (msg.getAltSinkMessagesOut() != 0) {
            Integer altSinkId = (Integer)bop.getRequiredProperty(PipelineOp.Annotations.ALT_SINK_REF);
            this.messagesProduced(altSinkId, msg.getAltSinkMessagesOut());
        }
        this._haltOp(msg);
        RunStateEnum state = this.getOperatorRunState(msg.getBOpId());
        boolean bl = isAllDone = this.innerState.totalRunningCount.get() == 0L && this.innerState.totalAvailableCount.get() == 0L && this.innerState.totalLastPassRemainingCount.get() == 0L && this.innerState.atOnceRequired.isEmpty();
        if (isAllDone) {
            this.innerState.allDone.set(true);
        }
        if (TableLog.tableLog.isInfoEnabled()) {
            int fanOut = msg.getSinkMessagesOut() + msg.getAltSinkMessagesOut();
            TableLog.tableLog.info((Object)this.getTableRow("haltOp", msg.getServiceId(), msg.getBOpId(), msg.getPartitionId(), fanOut, msg.getCause(), msg.getStats()));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("haltOp : " + this.toString() + " : bop=" + msg.getBOpId() + ",opRunState=" + (Object)((Object)state) + ",queryAllDone=" + isAllDone));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)msg.toString());
        }
        if (msg.getCause() != null) {
            throw new ExecutionException(msg.getCause());
        }
        return state;
    }

    RunStateEnum getOperatorRunState(int bopId) {
        Set doneSet;
        BOp op = this.innerState.bopIndex.get(bopId);
        if (op == null) {
            throw new NoSuchBOpException(bopId);
        }
        Iterator<BOp> itr = BOpUtility.preOrderIterator(op);
        while (itr.hasNext()) {
            BOp t = itr.next();
            Integer id = (Integer)t.getProperty(BOp.Annotations.BOP_ID);
            if (id == null) {
                throw new NoBOpIdException(t.toString());
            }
            AtomicLong runningCount = this.innerState.runningMap.get(id);
            if (runningCount != null && runningCount.get() != 0L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operator can be triggered: op=" + op + ", possible trigger=" + t + " is running."));
                }
                return RunStateEnum.Running;
            }
            AtomicLong availableChunkCount = this.innerState.availableMap.get(id);
            if (availableChunkCount != null && availableChunkCount.get() != 0L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operator can be triggered: op=" + op + ", possible trigger=" + t + " has " + availableChunkCount + " chunks available."));
                }
                return RunStateEnum.Running;
            }
            if (bopId == id) continue;
            if (this.innerState.atOnceRequired.contains(id)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operator can be triggered: op=" + op + ", possible trigger=" + t + " awaiting at-once evaluation of predecessor."));
                }
                return RunStateEnum.Running;
            }
            if (!this.innerState.lastPassRequested.contains(id)) continue;
            doneSet = this.innerState.doneOn.get(id);
            if (doneSet == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operator can be triggered: op=" + op + ", possible trigger=" + t + " has not started last pass evaluation."));
                }
                return RunStateEnum.Running;
            }
            if (doneSet.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Operator can be triggered: op=" + op + ", possible trigger=" + t + " awaiting last pass evaluation for doneSet=" + doneSet));
            }
            return RunStateEnum.Running;
        }
        boolean atOnceRequired = this.innerState.atOnceRequired.contains(bopId);
        boolean lastPassRequest = this.innerState.lastPassRequested.contains(bopId);
        if ((atOnceRequired || lastPassRequest) && this.innerState.runningMap.containsKey(bopId)) {
            doneSet = this.innerState.doneOn.get(bopId);
            if (doneSet == null) {
                Set<?> set;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operator will self-trigger last pass evaluation: op=" + op));
                }
                if ((set = this.innerState.startedOn.get(bopId)) != null) {
                    int nexpected = set.size();
                    this.innerState.doneOn.put(bopId, new LinkedHashSet(set));
                    this.innerState.totalAvailableCount.addAndGet(nexpected);
                    this.innerState.availableMap.get(bopId).addAndGet(nexpected);
                }
                return RunStateEnum.StartLastPass;
            }
            if (!doneSet.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Operator will self-trigger last pass evaluation: op=" + op + ", awaiting last pass evaluation for doneSet=" + doneSet));
                }
                return RunStateEnum.RunningLastPass;
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Operator can not be triggered: op=" + op));
        }
        return RunStateEnum.AllDone;
    }

    boolean isAtOnceReady(int bopId) {
        boolean didStart;
        BOp op = this.innerState.bopIndex.get(bopId);
        if (op == null) {
            throw new NoSuchBOpException(bopId);
        }
        AtomicLong counter = this.innerState.runningMap.get(bopId);
        boolean bl = didStart = counter != null && counter.get() != 0L;
        if (didStart) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Already ran/running: " + bopId));
            }
            return false;
        }
        Iterator<BOp> itr = BOpUtility.preOrderIterator(op);
        while (itr.hasNext()) {
            BOp t = itr.next();
            Integer id = (Integer)t.getProperty(BOp.Annotations.BOP_ID);
            if (id == null) {
                throw new NoBOpIdException(t.toString());
            }
            if (bopId == id) continue;
            AtomicLong runningCount = this.innerState.runningMap.get(id);
            if (runningCount != null && runningCount.get() != 0L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Predecessor running: predecessorId=" + id + ", predecessorRunningCount=" + runningCount));
                }
                return false;
            }
            AtomicLong availableChunkCount = this.innerState.availableMap.get(id);
            if (availableChunkCount == null || availableChunkCount.get() == 0L) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Predecessor can be triggered: predecessorId=" + id + " has " + availableChunkCount + " chunks available."));
            }
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Ready for 'at-once' evaluation: " + bopId));
        }
        return true;
    }

    private boolean _startOp(IStartOpMessage msg) {
        boolean firstTime;
        long running = this.innerState.totalRunningCount.incrementAndGet();
        assert (running >= 1L) : "running=" + running + " :: runState=" + this;
        Integer bopId = msg.getBOpId();
        AtomicLong n = this.innerState.runningMap.get(bopId);
        if (n == null) {
            n = new AtomicLong();
            this.innerState.runningMap.put(bopId, n);
        }
        long tmp = n.incrementAndGet();
        assert (tmp >= 0L) : "runningCount=" + tmp + " for bopId=" + bopId + " :: runState=" + this;
        Set<?> set = this.innerState.startedOn.get(bopId);
        if (set == null) {
            set = new LinkedHashSet();
            this.innerState.startedOn.put(bopId, set);
            firstTime = true;
        } else {
            firstTime = false;
        }
        BOp bop = this.innerState.bopIndex.get(bopId);
        switch (bop.getEvaluationContext()) {
            case ANY: 
            case CONTROLLER: 
            case HASHED: {
                set.add(msg.getServiceId());
                break;
            }
            case SHARDED: {
                set.add(msg.getPartitionId());
            }
        }
        return firstTime;
    }

    private void _haltOp(IHaltOpMessage msg) {
        Set set;
        Integer bopId = msg.getBOpId();
        long running = this.innerState.totalRunningCount.decrementAndGet();
        assert (running >= 0L) : "running=" + running + " :: runState=" + this;
        AtomicLong n = this.innerState.runningMap.get(bopId);
        if (n == null) {
            throw new IllegalArgumentException(ERR_OP_NOT_STARTED);
        }
        if (n.get() <= 0L) {
            throw new IllegalArgumentException(ERR_OP_HALTED);
        }
        n.decrementAndGet();
        if (this.innerState.atOnceRequired.contains(bopId)) {
            this.innerState.atOnceRequired.remove(bopId);
        }
        if ((set = this.innerState.doneOn.get(bopId)) != null) {
            if (!set.remove(msg.getPartitionId()) && !set.remove(msg.getServiceId())) {
                throw new RuntimeException("Not in doneSet: msg=" + msg + ", doneSet=" + set);
            }
            if (set.isEmpty() && this.innerState.lastPassRequested.contains(bopId)) {
                this.innerState.totalLastPassRemainingCount.decrementAndGet();
            }
        }
    }

    private void messagesConsumed(int bopId, int nmessages) {
        this.innerState.totalAvailableCount.addAndGet(-nmessages);
        AtomicLong n = this.innerState.availableMap.get(bopId);
        if (n == null) {
            n = new AtomicLong();
            this.innerState.availableMap.put(bopId, n);
        }
        n.addAndGet(-nmessages);
    }

    private void messagesProduced(Integer targetId, int nmessages) {
        if (targetId == null) {
            throw new IllegalArgumentException();
        }
        if (nmessages < 0) {
            throw new IllegalArgumentException();
        }
        if (nmessages == 0) {
            return;
        }
        if (!this.innerState.bopIndex.containsKey(targetId)) {
            throw new IllegalArgumentException();
        }
        this.innerState.totalAvailableCount.addAndGet(nmessages);
        AtomicLong n = this.innerState.availableMap.get(targetId);
        if (n == null) {
            n = new AtomicLong();
            this.innerState.availableMap.put(targetId, n);
        }
        n.addAndGet(nmessages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        this.innerState.toString(sb);
        return sb.toString();
    }

    private String getTableHeader() {
        StringBuilder sb = new StringBuilder();
        Object[] bopIds = this.innerState.bopIndex.keySet().toArray(new Integer[0]);
        Arrays.sort(bopIds);
        sb.append("queryId");
        sb.append("\tbegin");
        sb.append("\telapsed");
        sb.append("\tstep");
        sb.append("\tlabel");
        sb.append("\tbopId");
        sb.append("\tserviceId");
        sb.append("\tevalContext");
        sb.append("\tcontroller");
        sb.append("\tcause");
        sb.append("\tbop");
        sb.append("\tshardId");
        sb.append("\tfanIO");
        sb.append("\tnservices");
        sb.append("\tnavail(query)");
        sb.append("\tnrun(query)");
        sb.append("\tnlastPassRemaining");
        sb.append("\tallDone");
        for (int i = 0; i < bopIds.length; ++i) {
            Object id = bopIds[i];
            BOp bop = this.innerState.bopIndex.get(id);
            if (!(bop instanceof PipelineOp)) continue;
            sb.append("\tnavail(id=" + id + ")");
            sb.append("\tnrun(id=" + id + ")");
            sb.append("\tnstartedOn(id=" + id + ")");
            sb.append("\tndoneOn(id=" + id + ")");
        }
        sb.append("\telapsed");
        sb.append("\tchunksIn");
        sb.append("\tunitsIn");
        sb.append("\tchunksOut");
        sb.append("\tunitsOut");
        sb.append("\taccessPathDups");
        sb.append("\taccessPathCount");
        sb.append("\taccessPathRangeCount");
        sb.append("\taccessPathChunksIn");
        sb.append("\taccessPathUnitsIn");
        sb.append('\n');
        return sb.toString();
    }

    private String getTableRow(String label, UUID serviceId, int bopId, int shardId, int fanIO, Throwable cause, BOpStats stats) {
        StringBuilder sb = new StringBuilder();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        long elapsed = System.currentTimeMillis() - this.innerState.begin;
        sb.append(this.innerState.queryId);
        sb.append('\t');
        sb.append(dateFormat.format(new Date(this.innerState.begin)));
        sb.append('\t');
        sb.append(elapsed);
        sb.append('\t');
        sb.append(Long.toString(this.innerState.stepCount.get()));
        sb.append('\t');
        sb.append(label);
        sb.append('\t');
        sb.append(Integer.toString(bopId));
        sb.append('\t');
        sb.append(serviceId == null ? "N/A" : serviceId.toString());
        BOp bop = this.innerState.bopIndex.get(bopId);
        sb.append('\t');
        sb.append((Object)bop.getEvaluationContext());
        sb.append('\t');
        sb.append(bop.getProperty(BOp.Annotations.CONTROLLER, false));
        sb.append('\t');
        if (cause != null) {
            sb.append(cause.getLocalizedMessage());
        }
        sb.append('\t');
        if (this.innerState.stepCount.get() == 1L) {
            sb.append(BOpUtility.toString(this.innerState.query).replace('\n', ' '));
        } else {
            sb.append(this.innerState.bopIndex.get(bopId).toString());
        }
        sb.append('\t');
        sb.append(Integer.toString(shardId));
        sb.append('\t');
        sb.append(Integer.toString(fanIO));
        sb.append('\t');
        sb.append(this.innerState.serviceIds.size());
        sb.append('\t');
        sb.append(Long.toString(this.innerState.totalAvailableCount.get()));
        sb.append('\t');
        sb.append(Long.toString(this.innerState.totalRunningCount.get()));
        sb.append('\t');
        sb.append(Long.toString(this.innerState.totalLastPassRemainingCount.get()));
        sb.append('\t');
        sb.append(this.innerState.allDone.get());
        Object[] bopIds = this.innerState.bopIndex.keySet().toArray(new Integer[0]);
        Arrays.sort(bopIds);
        for (int i = 0; i < bopIds.length; ++i) {
            Object id = bopIds[i];
            BOp bop2 = this.innerState.bopIndex.get(id);
            if (!(bop2 instanceof PipelineOp)) continue;
            AtomicLong nrunning = this.innerState.runningMap.get(id);
            AtomicLong navailable = this.innerState.availableMap.get(id);
            Set<?> startedSet = this.innerState.startedOn.get(id);
            Set doneSet = this.innerState.doneOn.get(id);
            sb.append("\t" + (navailable == null ? "N/A" : Long.valueOf(navailable.get())));
            sb.append("\t" + (nrunning == null ? "N/A" : Long.valueOf(nrunning.get())));
            sb.append("\t" + (startedSet == null ? "N/A" : Integer.valueOf(startedSet.size())));
            sb.append("\t" + (doneSet == null ? "N/A" : Integer.valueOf(doneSet.size())));
        }
        if (stats != null) {
            sb.append('\t');
            sb.append(stats.elapsed.get());
            sb.append('\t');
            sb.append(stats.chunksIn.get());
            sb.append('\t');
            sb.append(stats.unitsIn.get());
            sb.append('\t');
            sb.append(stats.chunksOut.get());
            sb.append('\t');
            sb.append(stats.unitsOut.get());
            if (stats instanceof PipelineJoinStats) {
                PipelineJoinStats t = (PipelineJoinStats)stats;
                sb.append('\t');
                sb.append(t.accessPathDups.get());
                sb.append('\t');
                sb.append(t.accessPathCount.get());
                sb.append('\t');
                sb.append(t.accessPathRangeCount.get());
                sb.append('\t');
                sb.append(t.accessPathChunksIn.get());
                sb.append('\t');
                sb.append(t.accessPathUnitsIn.get());
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    static enum RunStateEnum {
        Running,
        StartLastPass,
        RunningLastPass,
        AllDone;

    }

    static class InnerState {
        private final BOp query;
        final Map<Integer, BOp> bopIndex;
        final UUID queryId;
        final long begin;
        final AtomicLong deadline;
        final AtomicBoolean started = new AtomicBoolean(false);
        final AtomicBoolean allDone = new AtomicBoolean(false);
        final AtomicLong stepCount = new AtomicLong();
        final AtomicLong totalRunningCount = new AtomicLong();
        final AtomicLong totalAvailableCount = new AtomicLong();
        final AtomicLong totalLastPassRemainingCount = new AtomicLong();
        final Map<Integer, AtomicLong> availableMap = new LinkedHashMap<Integer, AtomicLong>();
        final Map<Integer, AtomicLong> runningMap = new LinkedHashMap<Integer, AtomicLong>();
        final Set<UUID> serviceIds = new LinkedHashSet<UUID>();
        final Map<Integer, Set<?>> startedOn = new LinkedHashMap();
        final Map<Integer, Set> doneOn = new LinkedHashMap<Integer, Set>();
        final Set<Integer> lastPassRequested = new LinkedHashSet<Integer>();
        final Set<Integer> atOnceRequired = new LinkedHashSet<Integer>();

        InnerState(BOp query, UUID queryId, long deadline, long begin, Map<Integer, BOp> bopIndex) {
            if (query == null) {
                throw new IllegalArgumentException();
            }
            if (queryId == null) {
                throw new IllegalArgumentException();
            }
            if (deadline <= 0L) {
                throw new IllegalArgumentException();
            }
            if (begin <= 0L) {
                throw new IllegalArgumentException();
            }
            if (bopIndex == null) {
                throw new IllegalArgumentException();
            }
            this.query = query;
            this.queryId = queryId;
            this.deadline = new AtomicLong(deadline);
            this.bopIndex = bopIndex;
            this.begin = begin;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        StringBuilder toString(StringBuilder sb) {
            sb.append("{nsteps=" + this.stepCount);
            sb.append(",allDone=" + this.allDone);
            sb.append(",totalRunning=" + this.totalRunningCount);
            sb.append(",totalAvailable=" + this.totalAvailableCount);
            sb.append(",totalLastPassRemaining=" + this.totalLastPassRemainingCount);
            sb.append(",services=" + this.serviceIds);
            sb.append(",startedOn=" + this.startedOn);
            sb.append(",doneOn=" + this.doneOn);
            sb.append(",running=" + this.runningMap);
            sb.append(",available=" + this.availableMap);
            sb.append(",lastPassRequested=" + this.lastPassRequested);
            sb.append(",atOnceRequired=" + this.atOnceRequired);
            sb.append("}");
            return sb;
        }
    }

    private static class TableLog {
        private static final Logger tableLog = Logger.getLogger(TableLog.class);

        private TableLog() {
        }
    }
}

