/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.fed;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.IChunkMessage;
import com.bigdata.bop.engine.IQueryClient;
import com.bigdata.bop.engine.IQueryDecl;
import com.bigdata.bop.engine.IQueryPeer;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.CancelQuery;
import com.bigdata.bop.fed.DelegateIndexManager;
import com.bigdata.bop.fed.FederatedQueryEngineCounters;
import com.bigdata.bop.fed.FederatedRunningQuery;
import com.bigdata.journal.IIndexManager;
import com.bigdata.service.DataService;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IDataService;
import com.bigdata.service.ManagedResourceService;
import com.bigdata.service.jini.JiniFederation;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class FederatedQueryEngine
extends QueryEngine {
    private static final transient Logger log = Logger.getLogger(FederatedQueryEngine.class);
    private final UUID serviceUUID;
    private final IBigdataFederation<?> fed;
    private final ManagedResourceService resourceService;
    private final boolean isDataService;
    private final IQueryClient clientProxy;
    private final AtomicReference<ExecutorService> acceptTaskService = new AtomicReference();
    private final ConcurrentHashMap<UUID, IQueryPeer> proxyMap = new ConcurrentHashMap();

    @Override
    public UUID getServiceUUID() {
        return this.serviceUUID;
    }

    @Override
    public IBigdataFederation<?> getFederation() {
        return this.fed;
    }

    public ManagedResourceService getResourceService() {
        return this.resourceService;
    }

    @Override
    public IQueryClient getProxy() {
        return this.clientProxy;
    }

    @Override
    public final boolean isScaleOut() {
        return true;
    }

    public final boolean isDataService() {
        return this.isDataService;
    }

    @Override
    public FederatedRunningQuery getRunningQuery(UUID queryId) {
        return (FederatedRunningQuery)super.getRunningQuery(queryId);
    }

    public String toString() {
        return this.getClass().getName() + "{serviceUUID=" + this.getServiceUUID() + "}";
    }

    public FederatedQueryEngine(DataService dataService) {
        this(dataService.getServiceUUID(), dataService.getFederation(), new DelegateIndexManager(dataService), dataService.getResourceManager().getResourceService(), true);
    }

    public FederatedQueryEngine(UUID thisService, IBigdataFederation<?> fed, IIndexManager indexManager, ManagedResourceService resourceService) {
        this(thisService, fed, indexManager, resourceService, false);
    }

    private FederatedQueryEngine(UUID thisService, IBigdataFederation<?> fed, IIndexManager localIndexManager, ManagedResourceService resourceService, boolean isDataService) {
        super(localIndexManager);
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (resourceService == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.serviceUUID = thisService;
        this.resourceService = resourceService;
        this.isDataService = isDataService;
        this.clientProxy = fed instanceof JiniFederation ? (IQueryClient)((JiniFederation)fed).getProxy(this, true) : this;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    protected void didShutdown() {
        ExecutorService s = this.acceptTaskService.get();
        if (s != null) {
            s.shutdownNow();
        }
        this.acceptTaskService.set(null);
    }

    @Override
    public void shutdownNow() {
        ExecutorService s = this.acceptTaskService.get();
        if (s != null) {
            s.shutdownNow();
        }
        this.acceptTaskService.set(null);
        super.shutdownNow();
    }

    @Override
    @Deprecated
    public void declareQuery(IQueryDecl queryDecl) throws RemoteException {
        UUID queryId = queryDecl.getQueryId();
        AbstractRunningQuery q = this.newRunningQuery(queryId, false, queryDecl.getQueryController(), queryDecl.getQueryController().getServiceUUID(), queryDecl.getQuery(), (IChunkMessage)null);
        this.putIfAbsent(queryId, q);
    }

    @Override
    public void bufferReady(IChunkMessage<IBindingSet> msg) {
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("msg=" + msg));
        }
        this.assertRunning();
        new MaterializeMessageTask(msg).run();
    }

    @Override
    public void cancelQuery(UUID queryId, Throwable cause) {
        FederatedRunningQuery q = this.getRunningQuery(queryId);
        if (q == null) {
            return;
        }
        try {
            this.execute(new CancelQuery(q, cause));
        }
        catch (RejectedExecutionException ex) {
            // empty catch block
        }
    }

    @Override
    protected FederatedRunningQuery newRunningQuery(UUID queryId, boolean controller, IQueryClient clientProxy, UUID queryControllerId, PipelineOp query, IChunkMessage<IBindingSet> realSource) {
        return new FederatedRunningQuery(this, queryId, controller, clientProxy, queryControllerId, query, realSource);
    }

    protected IQueryPeer getQueryPeer(UUID serviceUUID) {
        if (serviceUUID == null) {
            throw new IllegalArgumentException();
        }
        IQueryPeer proxy = this.proxyMap.get(serviceUUID);
        if (proxy == null) {
            IDataService dataService = this.getFederation().getDataService(serviceUUID);
            if (dataService == null) {
                throw new RuntimeException("No such service: " + serviceUUID);
            }
            try {
                proxy = dataService.getQueryEngine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (proxy == null) {
                throw new RuntimeException("No query engine on service: " + serviceUUID);
            }
            IQueryPeer tmp = this.proxyMap.putIfAbsent(serviceUUID, proxy);
            if (tmp != null) {
                proxy = tmp;
            }
        }
        return proxy;
    }

    @Override
    protected FederatedQueryEngineCounters newCounters() {
        return new FederatedQueryEngineCounters();
    }

    @Override
    protected FederatedQueryEngineCounters getQueryEngineCounters() {
        return (FederatedQueryEngineCounters)this.counters;
    }

    private class MaterializeMessageTask
    implements Runnable {
        private final IChunkMessage<IBindingSet> msg;
        private volatile FederatedRunningQuery q;

        public MaterializeMessageTask(IChunkMessage<IBindingSet> msg) {
            if (msg == null) {
                throw new IllegalArgumentException();
            }
            this.msg = msg;
        }

        @Override
        public void run() {
            try {
                if (!this.accept(this.msg)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("dropping: " + this.msg));
                    }
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("accepted: " + this.msg));
                }
                FederatedQueryEngine.this.acceptChunk(this.msg);
                FederatedQueryEngineCounters c = FederatedQueryEngine.this.getQueryEngineCounters();
                c.chunksIn.increment();
                c.solutionsIn.add(this.msg.getSolutionCount());
            }
            catch (Throwable t) {
                if (this.q != null) {
                    this.q.halt(t);
                }
                log.error((Object)t, t);
            }
        }

        private boolean accept(IChunkMessage<?> msg) throws RemoteException {
            UUID queryId = msg.getQueryId();
            if (queryId == null) {
                throw new AssertionError();
            }
            this.q = FederatedQueryEngine.this.getRunningQuery(queryId);
            if (this.q == null) {
                boolean isController = FederatedQueryEngine.this.getServiceUUID().equals(msg.getQueryControllerId());
                if (isController) {
                    throw new AssertionError((Object)("Query not running on controller: thisService=" + FederatedQueryEngine.this.getServiceUUID() + ", msg=" + msg));
                }
                try {
                    this.q = this.getDeclaredQuery(queryId);
                }
                catch (IllegalArgumentException ex) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Query is gone: isDataService=" + FederatedQueryEngine.this.isDataService() + ", message=" + msg), (Throwable)ex);
                    }
                    return false;
                }
                if (this.q == null) {
                    throw new AssertionError();
                }
            }
            if (!this.q.isCancelled() && !msg.isMaterialized()) {
                try {
                    msg.materialize(this.q);
                }
                catch (Throwable t) {
                    if (!AbstractRunningQuery.isRootCauseInterrupt(t)) {
                        log.error((Object)("Problem materializing message: " + msg), t);
                    }
                    return false;
                }
            }
            return !this.q.isCancelled();
        }

        private FederatedRunningQuery getDeclaredQuery(UUID queryId) throws RemoteException {
            IQueryClient queryController = this.msg.getQueryController();
            PipelineOp query = queryController.getQuery(this.msg.getQueryId());
            if (query == null) {
                throw new AssertionError();
            }
            AbstractRunningQuery q = FederatedQueryEngine.this.newRunningQuery(queryId, false, queryController, this.msg.getQueryControllerId(), query, (IChunkMessage)this.msg);
            return (FederatedRunningQuery)FederatedQueryEngine.this.putIfAbsent(queryId, q);
        }
    }

    public static interface Annotations
    extends QueryEngine.Annotations {
        public static final String CHUNK_HANDLER = FederatedQueryEngine.class.getName() + ".chunkHandler";
    }
}

