/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.fed;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IShardwisePipelineOp;
import com.bigdata.bop.engine.IChunkHandler;
import com.bigdata.bop.engine.IChunkMessage;
import com.bigdata.bop.engine.IQueryPeer;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.LocalChunkMessage;
import com.bigdata.bop.engine.StandaloneChunkHandler;
import com.bigdata.bop.fed.FederatedQueryEngineCounters;
import com.bigdata.bop.fed.FederatedRunningQuery;
import com.bigdata.bop.fed.NIOChunkMessage;
import com.bigdata.bop.fed.QueryContext;
import com.bigdata.bop.fed.ThickChunkMessage;
import com.bigdata.bop.fed.shards.MapBindingSetsOverShardsBuffer;
import com.bigdata.io.DirectBufferPoolAllocator;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.IBuffer;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class FederationChunkHandler<E>
extends StandaloneChunkHandler {
    private static final Logger log = Logger.getLogger(FederationChunkHandler.class);
    public static final IChunkHandler INSTANCE = new FederationChunkHandler(Integer.MAX_VALUE, false);
    public static final IChunkHandler TEST_INSTANCE = new FederationChunkHandler(Integer.MAX_VALUE, true);
    private final int nioThreshold;
    private final boolean usePOJO;

    public FederationChunkHandler(int nioThreshold, boolean usePOJO) {
        this.nioThreshold = nioThreshold;
        this.usePOJO = usePOJO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleChunk(IRunningQuery query, int bopId, int sinkId, IBindingSet[] chunk) {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        if (chunk == null) {
            throw new IllegalArgumentException();
        }
        if (chunk.length == 0) {
            return 0;
        }
        FederatedRunningQuery q = (FederatedRunningQuery)query;
        BOp targetOp = q.getBOpIndex().get(sinkId);
        if (targetOp == null) {
            throw new IllegalStateException("Not found: " + sinkId);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("queryId=" + query.getQueryId() + ", sourceBopId=" + bopId + ", sink=" + sinkId));
        }
        switch (targetOp.getEvaluationContext()) {
            case ANY: {
                return super.handleChunk(query, bopId, sinkId, chunk);
            }
            case HASHED: {
                throw new UnsupportedOperationException();
            }
            case SHARDED: {
                IPredicate pred = ((IShardwisePipelineOp)((Object)targetOp)).getPredicate();
                long timestamp = pred.getTimestamp();
                int capacity = 1000;
                int chunkOfChunksCapacity = Integer.MAX_VALUE;
                int chunkSize = 100;
                MapBindingSetsOverShardsBuffer mapper = new MapBindingSetsOverShardsBuffer<IBindingSet, E>(q.getFederation(), pred, timestamp, 1000){

                    @Override
                    protected IBuffer<IBindingSet[]> newBuffer(PartitionLocator locator) {
                        return new BlockingBuffer<IBindingSet[]>(Integer.MAX_VALUE, 100, 20L, BlockingBuffer.DEFAULT_CONSUMER_CHUNK_TIMEOUT_UNIT);
                    }
                };
                for (IBindingSet bset : chunk) {
                    mapper.add(bset);
                }
                mapper.flush();
                DirectBufferPoolAllocator.IAllocationContext allocationContext = q.getAllocationContext(new QueryContext(q.getQueryId()));
                int messageSendCount = 0;
                for (Map.Entry<PartitionLocator, IBuffer<IBindingSet[]>> e : mapper.getSinks().entrySet()) {
                    PartitionLocator locator = e.getKey();
                    IBlockingBuffer shardSink = (IBlockingBuffer)e.getValue();
                    shardSink.close();
                    int n = 0;
                    LinkedList<IBindingSet[]> lst = new LinkedList<IBindingSet[]>();
                    try (IAsynchronousIterator itr = shardSink.iterator();){
                        while (itr.hasNext()) {
                            IBindingSet[] t = (IBindingSet[])itr.next();
                            lst.add(t);
                            n += t.length;
                        }
                    }
                    IBindingSet[] a = new IBindingSet[n];
                    int i = 0;
                    for (IBindingSet[] t : lst) {
                        System.arraycopy(t, 0, a, i, t.length);
                        i += t.length;
                    }
                    if (a.length <= 0) continue;
                    this.sendChunkMessage(q, locator.getDataServiceUUID(), sinkId, locator.getPartitionId(), allocationContext, a);
                    ++messageSendCount;
                }
                return messageSendCount;
            }
            case CONTROLLER: {
                DirectBufferPoolAllocator.IAllocationContext allocationContext = q.getAllocationContext(new QueryContext(q.getQueryId()));
                this.sendChunkMessage(q, q.queryControllerUUID, sinkId, -1, allocationContext, chunk);
                return 1;
            }
        }
        throw new AssertionError((Object)targetOp.getEvaluationContext());
    }

    protected void sendChunkMessage(FederatedRunningQuery q, UUID serviceUUID, int sinkId, int partitionId, DirectBufferPoolAllocator.IAllocationContext allocationContext, IBindingSet[] source) {
        boolean thisService;
        if (serviceUUID == null) {
            throw new IllegalArgumentException();
        }
        if (allocationContext == null) {
            throw new IllegalArgumentException();
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        IQueryPeer peerProxy = q.getQueryPeer(serviceUUID);
        if (peerProxy == null) {
            throw new RuntimeException("Not found: serviceId=" + serviceUUID);
        }
        boolean bl = thisService = peerProxy == q.getQueryEngine();
        if (thisService) {
            LocalChunkMessage msg = new LocalChunkMessage(q.getQueryController(), q.getQueryId(), sinkId, partitionId, source);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending local message: " + msg));
            }
            q.acceptChunk(msg);
            return;
        }
        IChunkMessage<IBindingSet> msg = this.usePOJO ? new LocalChunkMessage(q.getQueryController(), q.getQueryId(), sinkId, partitionId, source) : (source.length <= this.nioThreshold ? new ThickChunkMessage(q.getQueryController(), q.getQueryId(), sinkId, partitionId, source) : new NIOChunkMessage<IBindingSet>(q.getQueryController(), q.getQueryId(), sinkId, partitionId, allocationContext, source, q.getQueryEngine().getResourceService().getAddr()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending remote message: " + msg));
        }
        FederatedQueryEngineCounters c = q.getQueryEngine().getQueryEngineCounters();
        c.chunksOut.increment();
        c.solutionsOut.add(source.length);
        try {
            peerProxy.bufferReady(msg);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }
}

