/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.fed;

import com.bigdata.bop.engine.IChunkAccessor;
import com.bigdata.bop.engine.IChunkMessage;
import com.bigdata.bop.engine.IQueryClient;
import com.bigdata.bop.fed.FederatedRunningQuery;
import com.bigdata.bop.fed.ShardContext;
import com.bigdata.io.DirectBufferPoolAllocator;
import com.bigdata.io.SerializerUtil;
import com.bigdata.service.ManagedResourceService;
import com.bigdata.service.ResourceService;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class NIOChunkMessage<E>
implements IChunkMessage<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IQueryClient queryController;
    private final UUID queryControllerId;
    private final UUID queryId;
    private final int bopId;
    private final int partitionId;
    private final int solutionCount;
    private final int nbytes;
    private final A[] allocations;
    private final InetSocketAddress addr;
    private volatile List<DirectBufferPoolAllocator.IAllocation> materialized = null;
    private volatile transient ChunkAccessor chunkAccessor = null;

    @Override
    public IQueryClient getQueryController() {
        return this.queryController;
    }

    @Override
    public UUID getQueryControllerId() {
        return this.queryControllerId;
    }

    @Override
    public UUID getQueryId() {
        return this.queryId;
    }

    @Override
    public int getBOpId() {
        return this.bopId;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isLastInvocation() {
        return false;
    }

    @Override
    public int getSolutionCount() {
        return this.solutionCount;
    }

    public int getBytesAvailable() {
        return this.nbytes;
    }

    public InetSocketAddress getServiceAddr() {
        return this.addr;
    }

    public String toString() {
        return this.getClass().getName() + "{queryId=" + this.queryId + ",bopId=" + this.bopId + ",partitionId=" + this.partitionId + ", controller=" + this.queryController + ",solutionCount=" + this.solutionCount + ", bytesAvailable=" + this.nbytes + ", nslices=" + this.allocations.length + ", serviceAddr=" + this.addr + "}";
    }

    public NIOChunkMessage(IQueryClient queryController, UUID queryId, int sinkId, int partitionId, DirectBufferPoolAllocator.IAllocationContext allocationContext, E[] source, InetSocketAddress addr) {
        if (queryController == null) {
            throw new IllegalArgumentException();
        }
        if (queryId == null) {
            throw new IllegalArgumentException();
        }
        if (allocationContext == null) {
            throw new IllegalArgumentException();
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (addr == null) {
            throw new IllegalArgumentException();
        }
        AtomicInteger nsolutions = new AtomicInteger();
        List<DirectBufferPoolAllocator.IAllocation> allocations = NIOChunkMessage.moveToNIOBuffers(allocationContext, source, nsolutions);
        this.queryController = queryController;
        try {
            this.queryControllerId = queryController.getServiceUUID();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        this.queryId = queryId;
        this.bopId = sinkId;
        this.partitionId = partitionId;
        int n = allocations.size();
        this.allocations = new A[n];
        int i = 0;
        int nbytes = 0;
        for (DirectBufferPoolAllocator.IAllocation alloc : allocations) {
            int len = alloc.getSlice().capacity();
            this.allocations[i++] = new A(alloc.getId(), len);
            nbytes += len;
        }
        this.solutionCount = nsolutions.get();
        this.nbytes = nbytes;
        this.addr = addr;
    }

    private static <E> List<DirectBufferPoolAllocator.IAllocation> moveToNIOBuffers(DirectBufferPoolAllocator.IAllocationContext allocationContext, E[] source, AtomicInteger nsolutions) {
        DirectBufferPoolAllocator.IAllocation[] tmp;
        int nbytes = 0;
        int n = 0;
        LinkedList<DirectBufferPoolAllocator.IAllocation> allocations = new LinkedList<DirectBufferPoolAllocator.IAllocation>();
        E[] chunk = source;
        n += chunk.length;
        byte[] data = SerializerUtil.serialize(chunk);
        nbytes += data.length;
        try {
            tmp = allocationContext.alloc(data.length);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        DirectBufferPoolAllocator.put(data, tmp);
        for (DirectBufferPoolAllocator.IAllocation a : tmp) {
            a.getSlice().flip();
            allocations.add(a);
        }
        nsolutions.addAndGet(n);
        return allocations;
    }

    @Override
    public boolean isMaterialized() {
        return this.materialized != null;
    }

    @Override
    public void materialize(FederatedRunningQuery runningQuery) {
        ShardContext key = new ShardContext(this.queryId, this.bopId, this.partitionId);
        DirectBufferPoolAllocator.IAllocationContext allocationContext = runningQuery.getAllocationContext(key);
        ManagedResourceService resourceService = runningQuery.getQueryEngine().getResourceService();
        this.materialize(resourceService, allocationContext);
    }

    @Override
    public void release() {
        List<DirectBufferPoolAllocator.IAllocation> tmp;
        if (this.chunkAccessor != null) {
            this.chunkAccessor.close();
        }
        if ((tmp = this.materialized) != null) {
            boolean interrupted = false;
            block2: for (DirectBufferPoolAllocator.IAllocation a : tmp) {
                while (true) {
                    try {
                        a.release();
                        continue block2;
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
            this.materialized = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected synchronized void materialize(ManagedResourceService resourceService, DirectBufferPoolAllocator.IAllocationContext allocationContext) {
        if (this.materialized != null) {
            return;
        }
        try {
            LinkedList<DirectBufferPoolAllocator.IAllocation> received = new LinkedList<DirectBufferPoolAllocator.IAllocation>();
            for (A a : this.allocations) {
                ByteBuffer buf = ByteBuffer.allocate(a.nbytes);
                new ResourceService.ReadBufferTask(this.addr, a.bufferId, buf).call();
                DirectBufferPoolAllocator.IAllocation[] tmp = allocationContext.alloc(a.nbytes);
                DirectBufferPoolAllocator.put(buf, tmp);
                for (DirectBufferPoolAllocator.IAllocation alloc : tmp) {
                    alloc.getSlice().flip();
                    received.add(alloc);
                }
            }
            this.materialized = received;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public IChunkAccessor<E> getChunkAccessor() {
        if (this.chunkAccessor == null) {
            this.chunkAccessor = new ChunkAccessor();
        }
        return this.chunkAccessor;
    }

    private class DeserializationIterator
    implements ICloseableIterator<E[]> {
        private final Iterator<DirectBufferPoolAllocator.IAllocation> src;
        private volatile boolean open = true;

        public DeserializationIterator(Iterator<DirectBufferPoolAllocator.IAllocation> src) {
            this.src = src;
        }

        @Override
        public void close() {
            if (this.open) {
                this.open = false;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.open && this.src.hasNext()) {
                return true;
            }
            this.close();
            return false;
        }

        @Override
        public E[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            DirectBufferPoolAllocator.IAllocation a = this.src.next();
            ByteBuffer b = a.getSlice().asReadOnlyBuffer();
            byte[] c = new byte[b.remaining()];
            b.get(c);
            return (Object[])SerializerUtil.deserialize(c);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ChunkAccessor
    implements IChunkAccessor<E> {
        private final ICloseableIterator<E[]> source;

        public ChunkAccessor() {
            List tmp = NIOChunkMessage.this.materialized;
            if (tmp == null) {
                throw new UnsupportedOperationException();
            }
            this.source = new DeserializationIterator(NIOChunkMessage.this.materialized.iterator());
        }

        @Override
        public ICloseableIterator<E[]> iterator() {
            return this.source;
        }

        public void close() {
            this.source.close();
        }
    }

    private static final class A
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final UUID bufferId;
        private final int nbytes;

        public A(UUID bufferId, int nbytes) {
            if (bufferId == null) {
                throw new IllegalArgumentException();
            }
            if (nbytes <= 0) {
                throw new IllegalArgumentException();
            }
            this.bufferId = bufferId;
            this.nbytes = nbytes;
        }
    }
}

