/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.fed;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.engine.IChunkAccessor;
import com.bigdata.bop.engine.IChunkMessage;
import com.bigdata.bop.engine.IQueryClient;
import com.bigdata.bop.fed.FederatedRunningQuery;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.LongPacker;
import com.bigdata.io.ShortPacker;
import com.bigdata.rdf.internal.encoder.IVSolutionSetDecoder;
import com.bigdata.rdf.internal.encoder.IVSolutionSetEncoder;
import com.bigdata.relation.accesspath.EmptyCloseableIterator;
import com.bigdata.relation.accesspath.ThickCloseableIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.UUID;

public class ThickChunkMessage<E>
implements IChunkMessage<E>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private IQueryClient queryController;
    private UUID queryControllerId;
    private UUID queryId;
    private int bopId;
    private int partitionId;
    private int solutionCount;
    private byte[] data;
    private volatile transient ChunkAccessor chunkAccessor = null;
    private static final transient short VERSION0 = 0;
    private static final transient short currentVersion = 0;

    @Override
    public IQueryClient getQueryController() {
        return this.queryController;
    }

    @Override
    public UUID getQueryControllerId() {
        return this.queryControllerId;
    }

    @Override
    public UUID getQueryId() {
        return this.queryId;
    }

    @Override
    public int getBOpId() {
        return this.bopId;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isLastInvocation() {
        return false;
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public int getSolutionCount() {
        return this.solutionCount;
    }

    public int getBytesAvailable() {
        return this.data.length;
    }

    public String toString() {
        return this.getClass().getName() + "{queryId=" + this.queryId + ",bopId=" + this.bopId + ",partitionId=" + this.partitionId + ",controller=" + this.queryController + ", solutionCount=" + this.solutionCount + ", bytesAvailable=" + this.data.length + "}";
    }

    public ThickChunkMessage() {
    }

    public ThickChunkMessage(IQueryClient queryController, UUID queryId, int bopId, int partitionId, IBindingSet[] source) {
        if (queryController == null) {
            throw new IllegalArgumentException();
        }
        if (queryId == null) {
            throw new IllegalArgumentException();
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (source.length == 0) {
            throw new IllegalArgumentException();
        }
        this.queryController = queryController;
        try {
            this.queryControllerId = queryController.getServiceUUID();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        this.queryId = queryId;
        this.bopId = bopId;
        this.partitionId = partitionId;
        this.solutionCount = source.length;
        if (this.solutionCount == 0) {
            this.data = null;
        } else {
            int initialCapacity = this.solutionCount * 24;
            DataOutputBuffer out = new DataOutputBuffer(initialCapacity);
            IVSolutionSetEncoder encoder = new IVSolutionSetEncoder();
            for (int i = 0; i < source.length; ++i) {
                encoder.encodeSolution(out, source[i]);
            }
            this.data = out.toByteArray();
        }
    }

    @Override
    public void materialize(FederatedRunningQuery runningQuery) {
    }

    @Override
    public void release() {
        if (this.chunkAccessor != null) {
            this.chunkAccessor.close();
        }
    }

    @Override
    public IChunkAccessor<E> getChunkAccessor() {
        return new ChunkAccessor();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ShortPacker.packShort(out, (short)0);
        out.writeObject(this.queryController);
        out.writeLong(this.queryControllerId.getMostSignificantBits());
        out.writeLong(this.queryControllerId.getLeastSignificantBits());
        out.writeLong(this.queryId.getMostSignificantBits());
        out.writeLong(this.queryId.getLeastSignificantBits());
        out.writeInt(this.bopId);
        out.writeInt(this.partitionId);
        LongPacker.packLong(out, (long)this.solutionCount);
        if (this.solutionCount > 0) {
            LongPacker.packLong(out, (long)this.data.length);
            out.write(this.data);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = ShortPacker.unpackShort(in);
        if (version != 0) {
            throw new IOException("Unknown version: " + version);
        }
        this.queryController = (IQueryClient)in.readObject();
        this.queryControllerId = new UUID(in.readLong(), in.readLong());
        this.queryId = new UUID(in.readLong(), in.readLong());
        this.bopId = in.readInt();
        this.partitionId = in.readInt();
        this.solutionCount = LongPacker.unpackInt(in);
        if (this.solutionCount > 0) {
            int len = LongPacker.unpackInt(in);
            this.data = new byte[len];
            in.readFully(this.data);
        }
    }

    private class ChunkAccessor
    implements IChunkAccessor<E> {
        private final ICloseableIterator<E[]> source;

        public ChunkAccessor() {
            if (ThickChunkMessage.this.solutionCount == 0) {
                this.source = new EmptyCloseableIterator<E[]>();
                return;
            }
            IVSolutionSetDecoder decoder = new IVSolutionSetDecoder();
            IBindingSet[] a = new IBindingSet[ThickChunkMessage.this.solutionCount];
            DataInputBuffer in = new DataInputBuffer(ThickChunkMessage.this.data, 0, ThickChunkMessage.this.data.length);
            for (int i = 0; i < ThickChunkMessage.this.solutionCount; ++i) {
                a[i] = decoder.decodeSolution(in, true);
            }
            this.source = new ThickCloseableIterator<E[]>((E[])new IBindingSet[][]{a});
        }

        @Override
        public ICloseableIterator<E[]> iterator() {
            return this.source;
        }

        public void close() {
            this.source.close();
        }
    }
}

