/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.HashMapAnnotations;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IQueryAttributes;
import com.bigdata.bop.ISingleThreadedOp;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.controller.NamedSetAnnotations;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.join.HashJoinAnnotations;
import com.bigdata.bop.join.IDistinctFilter;
import com.bigdata.bop.join.IHashJoinUtility;
import com.bigdata.bop.join.JVMDistinctFilter;
import com.bigdata.bop.join.JoinAnnotations;
import com.bigdata.bop.join.JoinTypeEnum;
import com.bigdata.bop.join.NamedSolutionSetStats;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.SingleValueIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public abstract class HashIndexOp
extends PipelineOp
implements ISingleThreadedOp {
    private static final long serialVersionUID = 1L;
    protected IDistinctFilter distinctVarFilter;

    public HashIndexOp(HashIndexOp op) {
        super(op);
    }

    public HashIndexOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        switch (this.getEvaluationContext()) {
            case CONTROLLER: 
            case SHARDED: 
            case HASHED: {
                break;
            }
            default: {
                throw new IllegalArgumentException(BOp.Annotations.EVALUATION_CONTEXT + "=" + (Object)((Object)this.getEvaluationContext()));
            }
        }
        this.assertMaxParallelOne();
        if (!this.isLastPassRequested()) {
            throw new IllegalArgumentException(PipelineOp.Annotations.LAST_PASS + "=" + this.isLastPassRequested());
        }
        this.getRequiredProperty("namedSetRef");
        JoinTypeEnum joinType = (JoinTypeEnum)((Object)this.getRequiredProperty(Annotations.JOIN_TYPE));
        IVariable[] joinVars = (IVariable[])this.getRequiredProperty(Annotations.JOIN_VARS);
        IVariable[] projectInVars = (IVariable[])this.getProperty(Annotations.PROJECT_IN_VARS);
        if (projectInVars != null) {
            this.distinctVarFilter = new JVMDistinctFilter(projectInVars, this.getProperty(HashMapAnnotations.INITIAL_CAPACITY, 16), this.getProperty(HashMapAnnotations.LOAD_FACTOR, Float.valueOf(0.75f)).floatValue(), 16);
        }
        for (IVariable var : joinVars) {
            if (var != null) continue;
            throw new IllegalArgumentException(Annotations.JOIN_VARS);
        }
    }

    public HashIndexOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    @Override
    public BOpStats newStats() {
        return new NamedSolutionSetStats();
    }

    protected abstract IHashJoinUtility newState(BOpContext<IBindingSet> var1, INamedSolutionSetRef var2, JoinTypeEnum var3);

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(this, context, this.distinctVarFilter));
    }

    private static class ChunkTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final HashIndexOp op;
        private final NamedSolutionSetStats stats;
        private final IHashJoinUtility state;
        private final IDistinctFilter distinctJoinVarFilter;
        private final boolean first;
        private final boolean sourceIsPipeline;

        public ChunkTask(HashIndexOp op, BOpContext<IBindingSet> context, IDistinctFilter distinctJoinVarFilter) {
            if (op == null) {
                throw new IllegalArgumentException();
            }
            if (context == null) {
                throw new IllegalArgumentException();
            }
            this.context = context;
            this.op = op;
            this.stats = (NamedSolutionSetStats)context.getStats();
            this.distinctJoinVarFilter = distinctJoinVarFilter;
            INamedSolutionSetRef namedSetRef = (INamedSolutionSetRef)op.getRequiredProperty("namedSetRef");
            IQueryAttributes attrs = context.getQueryAttributes(namedSetRef.getQueryId());
            IHashJoinUtility state = (IHashJoinUtility)attrs.get(namedSetRef);
            if (state == null) {
                JoinTypeEnum joinType = (JoinTypeEnum)((Object)op.getRequiredProperty(Annotations.JOIN_TYPE));
                state = op.newState(context, namedSetRef, joinType);
                if (attrs.putIfAbsent(namedSetRef, state) != null) {
                    throw new AssertionError();
                }
                this.first = true;
            } else {
                this.first = false;
            }
            this.state = state;
            this.sourceIsPipeline = op.getProperty("namedSetSourceRef") == null && op.getProperty("bindingSets") == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                if (this.sourceIsPipeline) {
                    this.acceptSolutions();
                    if (this.context.isLastInvocation()) {
                        this.checkpointSolutionSet();
                        this.outputSolutions();
                    }
                } else {
                    if (this.first) {
                        this.acceptSolutions();
                        this.checkpointSolutionSet();
                    }
                    BOpUtility.copy(this.context.getSource(), this.context.getSink(), null, null, null, null, this.stats);
                    this.context.getSink().flush();
                }
                Void void_ = null;
                return void_;
            }
            finally {
                this.context.getSource().close();
                this.context.getSink().close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acceptSolutions() {
            ICloseableIterator<IBindingSet[]> src;
            if (this.sourceIsPipeline) {
                src = this.context.getSource();
            } else if (this.op.getProperty("namedSetSourceRef") != null) {
                INamedSolutionSetRef namedSetSourceRef = (INamedSolutionSetRef)this.op.getRequiredProperty("namedSetSourceRef");
                src = this.context.getAlternateSource(namedSetSourceRef);
            } else if (this.op.getProperty("bindingSets") != null) {
                IBindingSet[] bindingSets = (IBindingSet[])this.op.getProperty("bindingSets");
                src = new SingleValueIterator<IBindingSet[]>(bindingSets);
            } else {
                throw new UnsupportedOperationException("Source was not specified");
            }
            try {
                this.state.acceptSolutions(src, this.stats);
            }
            finally {
                src.close();
            }
        }

        private void checkpointSolutionSet() {
            this.state.saveSolutionSet();
        }

        private void outputSolutions() {
            IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();
            UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer = new UnsyncLocalOutputBuffer<IBindingSet>(this.op.getChunkCapacity(), sink);
            this.state.outputSolutions(unsyncBuffer, this.distinctJoinVarFilter);
            unsyncBuffer.flush();
            sink.flush();
        }
    }

    public static interface Annotations
    extends HashJoinAnnotations,
    JoinAnnotations,
    NamedSetAnnotations {
        public static final String NAMED_SET_SOURCE_REF = "namedSetSourceRef";
        public static final String BINDING_SETS_SOURCE = "bindingSets";
    }
}

