/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.counters.CAT;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class JVMHashIndex {
    private static final Logger log = Logger.getLogger(JVMHashIndex.class);
    private static final int ONE = 1;
    private final IVariable<?>[] keyVars;
    private final boolean indexSolutionsHavingUnboundJoinVars;
    private final Map<Key, Bucket> map;

    private Key makeKey(IBindingSet bset) {
        IConstant[] vals = new IConstant[this.keyVars.length];
        for (int i = 0; i < this.keyVars.length; ++i) {
            IVariable<?> v = this.keyVars[i];
            vals[i] = bset.get(v);
        }
        int h = 1;
        for (int i = 0; i < this.keyVars.length; ++i) {
            IVariable<?> v = this.keyVars[i];
            IConstant c = vals[i];
            if (c == null) {
                if (this.indexSolutionsHavingUnboundJoinVars) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Join variable is not bound: var=" + v + ", solution=" + bset));
                }
                return null;
            }
            h = 31 * h + c.hashCode();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("hashCode=" + h + ", joinVars=" + Arrays.toString(this.keyVars) + " : " + bset));
        }
        return new Key(h, vals);
    }

    public JVMHashIndex(IVariable<?>[] keyVars, boolean indexSolutionsHavingUnboundJoinVars, Map<Key, Bucket> map) {
        if (keyVars == null) {
            throw new IllegalArgumentException();
        }
        if (map == null) {
            throw new IllegalArgumentException();
        }
        this.map = map;
        this.indexSolutionsHavingUnboundJoinVars = indexSolutionsHavingUnboundJoinVars;
        this.keyVars = keyVars;
    }

    public Key add(IBindingSet bset) {
        Key key = this.makeKey(bset);
        if (key == null) {
            return null;
        }
        Bucket b = this.map.get(key);
        if (b == null) {
            b = new Bucket(key.hash, bset);
            this.map.put(key, b);
        } else {
            b.add(bset);
        }
        return key;
    }

    public boolean addDistinct(IBindingSet bset) {
        Key key = this.makeKey(bset);
        assert (key != null);
        Bucket b = this.map.get(key);
        if (b == null) {
            b = new Bucket(key.hash, bset);
            this.map.put(key, b);
            return true;
        }
        return b.addDistinct(bset);
    }

    public Bucket getBucket(IBindingSet left) {
        Key key = this.makeKey(left);
        if (key == null) {
            return null;
        }
        return this.map.get(key);
    }

    public Iterator<Bucket> buckets() {
        return this.map.values().iterator();
    }

    public int bucketCount() {
        return this.map.size();
    }

    public Bucket[] toArray() {
        Iterator<Bucket> bucketIterator = this.map.values().iterator();
        Bucket[] a = new Bucket[this.map.size()];
        int i = 0;
        while (bucketIterator.hasNext()) {
            a[i++] = bucketIterator.next();
        }
        return a;
    }

    public static class Bucket
    implements Iterable<SolutionHit>,
    Comparable<Bucket> {
        private final int hashCode;
        private final List<SolutionHit> solutions = new LinkedList<SolutionHit>();

        public String toString() {
            return super.toString() + "{hashCode=" + this.hashCode + ",#solutions=" + this.solutions.size() + "}";
        }

        public Bucket(int hashCode, IBindingSet solution) {
            this.hashCode = hashCode;
            this.add(solution);
        }

        public void add(IBindingSet solution) {
            if (solution == null) {
                throw new IllegalArgumentException();
            }
            this.solutions.add(new SolutionHit(solution));
        }

        public boolean addDistinct(IBindingSet solution) {
            if (this.solutions.isEmpty()) {
                this.solutions.add(new SolutionHit(solution));
                return true;
            }
            for (SolutionHit aSolution : this.solutions) {
                if (!aSolution.solution.equals(solution)) continue;
                return false;
            }
            this.solutions.add(new SolutionHit(solution));
            return true;
        }

        @Override
        public final Iterator<SolutionHit> iterator() {
            return this.solutions.iterator();
        }

        @Override
        public final int compareTo(Bucket o) {
            if (this.hashCode > o.hashCode) {
                return 1;
            }
            if (this.hashCode < o.hashCode) {
                return -1;
            }
            return 0;
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public final boolean isEmpty() {
            return this.solutions.isEmpty();
        }
    }

    public static class SolutionHit {
        public final IBindingSet solution;
        public final CAT nhits = new CAT();

        private SolutionHit(IBindingSet solution) {
            if (solution == null) {
                throw new IllegalArgumentException();
            }
            this.solution = solution;
        }

        public String toString() {
            return this.getClass().getName() + "{nhits=" + this.nhits + ",solution=" + this.solution + "}";
        }
    }

    public static class Key {
        private final int hash;
        private final IConstant<?>[] vals;

        private Key(int hashCode, IConstant<?>[] vals) {
            this.vals = vals;
            this.hash = hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key t = (Key)o;
            if (this.vals.length != t.vals.length) {
                return false;
            }
            for (int i = 0; i < this.vals.length; ++i) {
                if (this.vals[i] == t.vals[i]) continue;
                if (this.vals[i] == null) {
                    return false;
                }
                if (this.vals[i].equals(t.vals[i])) continue;
                return false;
            }
            return true;
        }
    }
}

