/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IShardwisePipelineOp;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.join.AccessPathJoinAnnotations;
import com.bigdata.bop.join.PipelineJoinStats;
import com.bigdata.btree.BytesUtil;
import com.bigdata.concurrent.FutureTaskMon;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.AbstractUnsynchronizedArrayBuffer;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.ArrayAccessPath;
import com.bigdata.relation.accesspath.EmptyAccessPath;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IBindingSetAccessPath;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.ThreadLocalBufferFactory;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import com.bigdata.relation.rule.IStarJoin;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.util.concurrent.Haltable;
import com.bigdata.util.concurrent.LatchedExecutor;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class PipelineJoin<E>
extends PipelineOp
implements IShardwisePipelineOp<E> {
    private static final transient Logger log = Logger.getLogger(PipelineJoin.class);
    private static final long serialVersionUID = 1L;

    public PipelineJoin(PipelineJoin<E> op) {
        super(op);
    }

    public PipelineJoin(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    public PipelineJoin(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    @Override
    public IPredicate<E> getPredicate() {
        return (IPredicate)this.getRequiredProperty(Annotations.PREDICATE);
    }

    private boolean isOptional() {
        return this.getPredicate().isOptional();
    }

    public IConstraint[] constraints() {
        return this.getProperty(Annotations.CONSTRAINTS, null);
    }

    public int getMaxParallelChunks() {
        return this.getProperty(Annotations.MAX_PARALLEL_CHUNKS, 0);
    }

    public IVariable<?>[] variablesToKeep() {
        return this.getProperty(Annotations.SELECT, null);
    }

    @Override
    public PipelineJoinStats newStats() {
        return new PipelineJoinStats();
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTaskMon<Void>(new JoinTask(this, context));
    }

    private static class JoinTask<E>
    extends Haltable<Void>
    implements Callable<Void> {
        private final PipelineJoin<?> joinOp;
        private final IConstraint[] constraints;
        private final int maxParallelChunks;
        private final Executor service;
        private final boolean optional;
        private final IVariable<?>[] variablesToKeep;
        private final IPredicate<E> predicate;
        private final IRelation<E> relation;
        private final int partitionId;
        private final BOpContext<IBindingSet> context;
        private final PipelineJoinStats stats;
        private final long limit;
        private final boolean coalesceAccessPaths;
        private final boolean reorderAccessPaths;
        private final AtomicLong exactOutputCount = new AtomicLong();
        private final ICloseableIterator<IBindingSet[]> source;
        private final IBlockingBuffer<IBindingSet[]> sink;
        private final IBlockingBuffer<IBindingSet[]> sink2;
        private final TLBFactory threadLocalBufferFactory;
        private final TLBFactory threadLocalBufferFactory2;

        public JoinTask(PipelineJoin<E> joinOp, BOpContext<IBindingSet> context) {
            if (joinOp == null) {
                throw new IllegalArgumentException();
            }
            if (context == null) {
                throw new IllegalArgumentException();
            }
            this.joinOp = joinOp;
            this.predicate = joinOp.getPredicate();
            this.constraints = joinOp.constraints();
            this.maxParallelChunks = joinOp.getMaxParallelChunks();
            if (this.maxParallelChunks < 0) {
                throw new IllegalArgumentException(Annotations.MAX_PARALLEL_CHUNKS + "=" + this.maxParallelChunks);
            }
            this.service = this.maxParallelChunks > 0 ? new LatchedExecutor(context.getIndexManager().getExecutorService(), this.maxParallelChunks) : null;
            this.optional = ((PipelineJoin)joinOp).isOptional();
            this.variablesToKeep = joinOp.variablesToKeep();
            this.context = context;
            this.relation = context.getRelation(this.predicate);
            this.source = context.getSource();
            this.sink = context.getSink();
            this.sink2 = context.getSink2();
            this.partitionId = context.getPartitionId();
            this.stats = (PipelineJoinStats)context.getStats();
            this.limit = joinOp.getProperty(Annotations.LIMIT, Long.MAX_VALUE);
            this.coalesceAccessPaths = joinOp.getProperty(Annotations.COALESCE_DUPLICATE_ACCESS_PATHS, true);
            this.reorderAccessPaths = joinOp.getProperty(Annotations.REORDER_ACCESS_PATHS, true);
            this.threadLocalBufferFactory = new TLBFactory(this.sink);
            TLBFactory tLBFactory = this.threadLocalBufferFactory2 = this.sink2 == null ? null : new TLBFactory(this.sink2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("joinOp=" + joinOp));
            }
        }

        public String toString() {
            return this.getClass().getName() + "{ joinOp=" + this.joinOp + "}";
        }

        @Override
        public Void call() throws Exception {
            if (log.isDebugEnabled()) {
                log.debug((Object)("joinOp=" + this.joinOp));
            }
            try {
                this.consumeSource();
                this.threadLocalBufferFactory.flush();
                if (this.threadLocalBufferFactory2 != null) {
                    this.threadLocalBufferFactory2.flush();
                }
                this.flushAndCloseBuffersAndAwaitSinks();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JoinTask done: joinOp=" + this.joinOp));
                }
                this.halted();
                return null;
            }
            catch (Throwable t) {
                this.halt(t);
                try {
                    this.threadLocalBufferFactory.reset();
                    if (this.threadLocalBufferFactory2 != null) {
                        this.threadLocalBufferFactory2.reset();
                    }
                }
                catch (Throwable t2) {
                    log.error((Object)t2.getLocalizedMessage(), t2);
                }
                try {
                    this.cancelSinks();
                }
                catch (Throwable t2) {
                    log.error((Object)t2.getLocalizedMessage(), t2);
                }
                try {
                    this.closeSources();
                }
                catch (Throwable t2) {
                    log.error((Object)t2.getLocalizedMessage(), t2);
                }
                if (this.getCause() != null) {
                    throw new RuntimeException(t);
                }
                return null;
            }
        }

        protected void consumeSource() throws Exception {
            IBindingSet[] chunk;
            while (!this.isDone() && (chunk = this.nextChunk()) != null) {
                if (chunk.length == 0) continue;
                if (chunk.length <= 1) {
                    new BindingSetConsumerTask(null, chunk).call();
                    continue;
                }
                new BindingSetConsumerTask(this.service, chunk).call();
            }
        }

        protected void closeSources() {
            if (log.isInfoEnabled()) {
                log.info((Object)this.toString());
            }
            this.source.close();
        }

        protected void flushAndCloseBuffersAndAwaitSinks() throws InterruptedException, ExecutionException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("joinOp=" + this.joinOp));
            }
            this.sink.flush();
            this.sink.close();
            if (this.sink2 != null) {
                this.sink2.flush();
                this.sink2.close();
            }
        }

        @Override
        protected boolean isNormalTerminationCause(Throwable cause) {
            return super.isNormalTerminationCause(cause) || super.isDeadlineTerminationCause(cause);
        }

        protected void cancelSinks() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("joinOp=" + this.joinOp));
            }
            this.sink.reset();
            if (this.sink.getFuture() != null) {
                this.sink.getFuture().cancel(true);
            }
            if (this.sink2 != null) {
                this.sink2.reset();
                if (this.sink2.getFuture() != null) {
                    this.sink2.getFuture().cancel(true);
                }
            }
        }

        protected IBindingSet[] nextChunk() throws InterruptedException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("joinOp=" + this.joinOp));
            }
            if (this.source.hasNext()) {
                this.halted();
                IBindingSet[] chunk = (IBindingSet[])this.source.next();
                this.stats.chunksIn.increment();
                this.stats.unitsIn.add(chunk.length);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Read chunk from source: chunkSize=" + chunk.length + ", joinOp=" + this.joinOp));
                }
                return chunk;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Source exhausted: joinOp=" + this.joinOp));
            }
            return null;
        }

        private class TLBFactory
        extends ThreadLocalBufferFactory<AbstractUnsynchronizedArrayBuffer<IBindingSet>, IBindingSet> {
            private final IBlockingBuffer<IBindingSet[]> sink;

            public TLBFactory(IBlockingBuffer<IBindingSet[]> sink) {
                if (sink == null) {
                    throw new IllegalArgumentException();
                }
                this.sink = sink;
            }

            @Override
            protected AbstractUnsynchronizedArrayBuffer<IBindingSet> initialValue() {
                return new UnsyncLocalOutputBuffer<IBindingSet>(JoinTask.this.joinOp.getChunkCapacity(), this.sink);
            }

            @Override
            protected void halted() {
                JoinTask.this.halted();
            }
        }

        protected class ChunkTask
        implements Callable<Void> {
            private final IBindingSet[] bindingSets;
            private final int[] naccepted;
            private final AbstractUnsynchronizedArrayBuffer<IBindingSet> unsyncBuffer;
            private final Object[] chunk;

            public ChunkTask(IBindingSet[] bindingSet, int[] naccepted, AbstractUnsynchronizedArrayBuffer<IBindingSet> unsyncBuffer, Object[] chunk) {
                if (bindingSet == null) {
                    throw new IllegalArgumentException();
                }
                if (naccepted == null) {
                    throw new IllegalArgumentException();
                }
                if (unsyncBuffer == null) {
                    throw new IllegalArgumentException();
                }
                if (chunk == null) {
                    throw new IllegalArgumentException();
                }
                this.bindingSets = bindingSet;
                this.naccepted = naccepted;
                this.chunk = chunk;
                this.unsyncBuffer = unsyncBuffer;
            }

            @Override
            public Void call() throws Exception {
                try {
                    for (Object e : this.chunk) {
                        if (JoinTask.this.isDone()) {
                            return null;
                        }
                        int naccepted = 0;
                        ((JoinTask)JoinTask.this).stats.accessPathUnitsIn.increment();
                        int bindex = 0;
                        for (IBindingSet bset : this.bindingSets) {
                            bset = bset.clone();
                            if (BOpContext.bind(JoinTask.this.predicate, JoinTask.this.constraints, e, bset)) {
                                IBindingSet iBindingSet = bset = JoinTask.this.variablesToKeep == null ? bset : bset.copy(JoinTask.this.variablesToKeep);
                                if (JoinTask.this.limit != Long.MAX_VALUE && JoinTask.this.exactOutputCount.incrementAndGet() > JoinTask.this.limit) {
                                    if (log.isInfoEnabled()) {
                                        log.info((Object)("Breaking query @ limit: limit=" + JoinTask.this.limit + ", exactOutputCount=" + JoinTask.this.exactOutputCount.get()));
                                    }
                                    JoinTask.this.halt((Void)null);
                                    break;
                                }
                                this.unsyncBuffer.add(bset);
                                ++naccepted;
                                int n = bindex;
                                this.naccepted[n] = this.naccepted[n] + 1;
                                ((JoinTask)JoinTask.this).stats.outputSolutions.increment();
                            }
                            ++bindex;
                        }
                        if (!log.isDebugEnabled()) continue;
                        if (naccepted == 0) {
                            log.debug((Object)("Rejected element: " + e.toString()));
                            continue;
                        }
                        log.debug((Object)("Accepted element for " + naccepted + " of " + this.bindingSets.length + " possible bindingSet combinations: " + e.toString()));
                    }
                    return null;
                }
                catch (Throwable t) {
                    JoinTask.this.halt(t);
                    if (JoinTask.this.getCause() != null) {
                        throw new RuntimeException(t);
                    }
                    return null;
                }
            }
        }

        protected class AccessPathTask
        implements Callable<Void>,
        Comparable<AccessPathTask> {
            private final IBindingSet[] bindingSets;
            private final int[] naccepted;
            private final IAccessPath<E> accessPath;

            protected byte[] getFromKey() {
                if (this.accessPath instanceof EmptyAccessPath) {
                    return BytesUtil.EMPTY;
                }
                return ((AccessPath)this.accessPath).getFromKey();
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof AccessPathTask)) {
                    return false;
                }
                return this.accessPath.getPredicate().equals(((AccessPathTask)o).accessPath.getPredicate());
            }

            public AccessPathTask(IPredicate<E> predicate, Collection<IBindingSet> bindingSets) {
                if (predicate == null) {
                    throw new IllegalArgumentException();
                }
                if (bindingSets == null) {
                    throw new IllegalArgumentException();
                }
                int n = bindingSets.size();
                if (n == 0) {
                    throw new IllegalArgumentException();
                }
                this.accessPath = JoinTask.this.context.getAccessPath(JoinTask.this.relation, predicate);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("joinOp=" + JoinTask.this.joinOp));
                    log.debug((Object)("#bindingSets=" + n));
                    log.debug((Object)("accessPath=" + this.accessPath));
                }
                this.bindingSets = bindingSets.toArray(new IBindingSet[n]);
                this.naccepted = new int[n];
            }

            public String toString() {
                return JoinTask.this.getClass().getSimpleName() + "{ joinOp=" + JoinTask.this.joinOp + ", #bindingSets=" + this.bindingSets.length + "}";
            }

            @Override
            public Void call() throws Exception {
                JoinTask.this.halted();
                if (JoinTask.this.limit != Long.MAX_VALUE && JoinTask.this.exactOutputCount.get() > JoinTask.this.limit) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Breaking query @ limit: limit=" + JoinTask.this.limit + ", exactOutputCount=" + JoinTask.this.exactOutputCount.get()));
                    }
                    JoinTask.this.halt((Void)null);
                    return null;
                }
                long rangeCount = this.accessPath.rangeCount(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("range count: " + rangeCount));
                }
                ((JoinTask)JoinTask.this).stats.accessPathCount.increment();
                ((JoinTask)JoinTask.this).stats.accessPathRangeCount.add(rangeCount);
                if (this.accessPath.getPredicate() instanceof IStarJoin) {
                    this.handleStarJoin();
                } else if (this.accessPath instanceof IBindingSetAccessPath) {
                    this.handleJoin2();
                } else {
                    this.handleJoin();
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Deprecated
            protected void handleJoin() {
                long cutoffLimit = JoinTask.this.predicate.getProperty(IPredicate.Annotations.CUTOFF_LIMIT, Long.MAX_VALUE);
                try (IChunkedOrderedIterator itr = this.accessPath.iterator(0L, cutoffLimit, 0);){
                    AbstractUnsynchronizedArrayBuffer unsyncBuffer = (AbstractUnsynchronizedArrayBuffer)JoinTask.this.threadLocalBufferFactory.get();
                    ((JoinTask)JoinTask.this).stats.inputSolutions.add(this.bindingSets.length);
                    while (itr.hasNext()) {
                        JoinTask.this.halted();
                        Object[] chunk = itr.nextChunk();
                        ((JoinTask)JoinTask.this).stats.accessPathChunksIn.increment();
                        new ChunkTask(this.bindingSets, this.naccepted, unsyncBuffer, chunk).call();
                    }
                    if (JoinTask.this.optional) {
                        AbstractUnsynchronizedArrayBuffer unsyncBuffer2 = JoinTask.this.threadLocalBufferFactory2 == null ? null : (AbstractUnsynchronizedArrayBuffer)JoinTask.this.threadLocalBufferFactory2.get();
                        for (int bindex = 0; bindex < this.bindingSets.length; ++bindex) {
                            if (this.naccepted[bindex] > 0) continue;
                            IBindingSet bs = this.bindingSets[bindex];
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Passing on solution which fails an optional join: " + bs));
                            }
                            if (JoinTask.this.limit != Long.MAX_VALUE && JoinTask.this.exactOutputCount.incrementAndGet() > JoinTask.this.limit) {
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("Breaking query @ limit: limit=" + JoinTask.this.limit + ", exactOutputCount=" + JoinTask.this.exactOutputCount.get()));
                                }
                                JoinTask.this.halt((Void)null);
                                break;
                            }
                            if (unsyncBuffer2 == null) {
                                unsyncBuffer.add(bs);
                            } else {
                                unsyncBuffer2.add(bs);
                            }
                            ((JoinTask)JoinTask.this).stats.outputSolutions.increment();
                        }
                    }
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void handleJoin2() {
                long cutoffLimit = JoinTask.this.predicate.getProperty(IPredicate.Annotations.CUTOFF_LIMIT, Long.MAX_VALUE);
                try (ICloseableIterator<IBindingSet[]> itr = ((IBindingSetAccessPath)((Object)this.accessPath)).solutions(cutoffLimit, JoinTask.this.stats);){
                    AbstractUnsynchronizedArrayBuffer unsyncBuffer = (AbstractUnsynchronizedArrayBuffer)JoinTask.this.threadLocalBufferFactory.get();
                    ((JoinTask)JoinTask.this).stats.inputSolutions.add(this.bindingSets.length);
                    while (itr.hasNext()) {
                        IBindingSet[] rightChunk;
                        JoinTask.this.halted();
                        int naccepted = 0;
                        for (IBindingSet right : rightChunk = (IBindingSet[])itr.next()) {
                            int bindex = 0;
                            for (IBindingSet left : this.bindingSets) {
                                IBindingSet bset = BOpContext.bind(left, right, JoinTask.this.constraints, JoinTask.this.variablesToKeep);
                                if (bset != null) {
                                    if (JoinTask.this.limit != Long.MAX_VALUE && JoinTask.this.exactOutputCount.incrementAndGet() > JoinTask.this.limit) {
                                        if (log.isInfoEnabled()) {
                                            log.info((Object)("Breaking query @ limit: limit=" + JoinTask.this.limit + ", exactOutputCount=" + JoinTask.this.exactOutputCount.get()));
                                        }
                                        JoinTask.this.halt((Void)null);
                                        break;
                                    }
                                    unsyncBuffer.add(bset);
                                    ++naccepted;
                                    int n = bindex;
                                    this.naccepted[n] = this.naccepted[n] + 1;
                                    ((JoinTask)JoinTask.this).stats.outputSolutions.increment();
                                }
                                if (bindex++ % 50 != 0 || !Thread.interrupted()) continue;
                                throw new InterruptedException();
                            }
                            if (!log.isDebugEnabled()) continue;
                            if (naccepted == 0) {
                                log.debug((Object)("Rejected solution: " + right));
                                continue;
                            }
                            log.debug((Object)("Accepted solution for " + naccepted + " of " + this.bindingSets.length + " possible bindingSet combinations: " + right));
                        }
                    }
                    if (JoinTask.this.optional) {
                        AbstractUnsynchronizedArrayBuffer unsyncBuffer2 = JoinTask.this.threadLocalBufferFactory2 == null ? null : (AbstractUnsynchronizedArrayBuffer)JoinTask.this.threadLocalBufferFactory2.get();
                        for (int bindex = 0; bindex < this.bindingSets.length; ++bindex) {
                            if (this.naccepted[bindex] > 0) continue;
                            IBindingSet bs = this.bindingSets[bindex];
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Passing on solution which fails an optional join: " + bs));
                            }
                            if (JoinTask.this.limit != Long.MAX_VALUE && JoinTask.this.exactOutputCount.incrementAndGet() > JoinTask.this.limit) {
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("Breaking query @ limit: limit=" + JoinTask.this.limit + ", exactOutputCount=" + JoinTask.this.exactOutputCount.get()));
                                }
                                JoinTask.this.halt((Void)null);
                                break;
                            }
                            if (unsyncBuffer2 == null) {
                                unsyncBuffer.add(bs);
                            } else {
                                unsyncBuffer2.add(bs);
                            }
                            ((JoinTask)JoinTask.this).stats.outputSolutions.increment();
                        }
                    }
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            protected void handleStarJoin() {
                IBindingSet[] solutions = this.bindingSets;
                IStarJoin starJoin = (IStarJoin)this.accessPath.getPredicate();
                AbstractUnsynchronizedArrayBuffer unsyncBuffer = (AbstractUnsynchronizedArrayBuffer)JoinTask.this.threadLocalBufferFactory.get();
                int numElements = 0;
                try (IChunkedOrderedIterator itr = this.accessPath.iterator();){
                    Object[] elements;
                    int nchunks = 0;
                    LinkedList<E[]> chunks = new LinkedList<E[]>();
                    while (itr.hasNext()) {
                        E[] chunk = itr.nextChunk();
                        chunks.add(chunk);
                        numElements += chunk.length;
                        ((JoinTask)JoinTask.this).stats.accessPathChunksIn.increment();
                        ++nchunks;
                    }
                    if (nchunks == 0) {
                        return;
                    }
                    if (nchunks == 1) {
                        elements = (Object[])chunks.get(0);
                    } else {
                        elements = new Object[numElements];
                        int n = 0;
                        for (Object[] objectArray : chunks) {
                            System.arraycopy(objectArray, 0, elements, n, objectArray.length);
                            n += objectArray.length;
                        }
                    }
                    ((JoinTask)JoinTask.this).stats.accessPathUnitsIn.add(numElements);
                    if (numElements > 0) {
                        Iterator it = starJoin.getStarConstraints();
                        boolean constraintFailed = false;
                        while (it.hasNext()) {
                            IStarJoin.IStarConstraint<Object> constraint = it.next();
                            LinkedList<IBindingSet> constraintSolutions = null;
                            int n = constraint.getNumVars();
                            for (int i = 0; i < numElements; ++i) {
                                Object e = elements[i];
                                if (!constraint.isMatch(e)) continue;
                                if (constraintSolutions == null) {
                                    constraintSolutions = new LinkedList<IBindingSet>();
                                }
                                for (IBindingSet bs : solutions) {
                                    if (n > 0) {
                                        bs = bs.clone();
                                        constraint.bind(bs, e);
                                    }
                                    constraintSolutions.add(bs);
                                }
                                if (n == 0) break;
                            }
                            if (constraintSolutions == null) {
                                if (constraint.isOptional()) continue;
                                constraintFailed = true;
                                break;
                            }
                            solutions = constraintSolutions.toArray(new IBindingSet[constraintSolutions.size()]);
                        }
                        if (!constraintFailed) {
                            void var11_21;
                            IBindingSet[] arr$ = solutions;
                            int len$ = arr$.length;
                            boolean bl = false;
                            while (var11_21 < len$) {
                                IBindingSet bs = arr$[var11_21];
                                if (JoinTask.this.limit != Long.MAX_VALUE && JoinTask.this.exactOutputCount.incrementAndGet() > JoinTask.this.limit) {
                                    if (log.isInfoEnabled()) {
                                        log.info((Object)("Breaking query @ limit: limit=" + JoinTask.this.limit + ", exactOutputCount=" + JoinTask.this.exactOutputCount.get()));
                                    }
                                    JoinTask.this.halt((Void)null);
                                    break;
                                }
                                unsyncBuffer.add(bs);
                                ((JoinTask)JoinTask.this).stats.outputSolutions.increment();
                                ++var11_21;
                            }
                        }
                    }
                    return;
                }
            }

            @Override
            public int compareTo(AccessPathTask o) {
                if (this.accessPath instanceof ArrayAccessPath) {
                    return -1;
                }
                if (o.accessPath instanceof ArrayAccessPath) {
                    return 1;
                }
                return BytesUtil.compareBytes(this.getFromKey(), o.getFromKey());
            }
        }

        protected class BindingSetConsumerTask
        implements Callable<Void> {
            private final Executor executor;
            private final IBindingSet[] chunk;

            public BindingSetConsumerTask(Executor executor, IBindingSet[] chunk) {
                if (chunk == null) {
                    throw new IllegalArgumentException();
                }
                this.executor = executor;
                this.chunk = chunk;
            }

            @Override
            public Void call() throws Exception {
                try {
                    if (this.chunk.length == 1) {
                        this.runOneTask();
                        return null;
                    }
                    AccessPathTask[] tasks = this.generateAccessPaths(this.chunk);
                    if (JoinTask.this.reorderAccessPaths) {
                        this.reorderTasks(tasks);
                    }
                    this.executeTasks(tasks);
                    return null;
                }
                catch (Throwable t) {
                    JoinTask.this.halt(t);
                    if (JoinTask.this.getCause() != null) {
                        throw new RuntimeException(t);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Caught and ignored exception: " + t));
                    }
                    return null;
                }
            }

            private void runOneTask() throws Exception {
                if (this.chunk.length != 1) {
                    throw new AssertionError();
                }
                IBindingSet bindingSet = this.chunk[0];
                IPredicate asBound = JoinTask.this.predicate.asBound(bindingSet);
                if (asBound == null) {
                    return;
                }
                if (JoinTask.this.partitionId != -1) {
                    asBound = asBound.setPartitionId(JoinTask.this.partitionId);
                }
                new AccessPathTask(asBound, Arrays.asList(this.chunk)).call();
            }

            protected AccessPathTask[] generateAccessPaths(IBindingSet[] chunk) {
                AccessPathTask[] tasks;
                if (JoinTask.this.coalesceAccessPaths) {
                    Map map = this.combineBindingSets(chunk);
                    tasks = this.getAccessPathTasks(map);
                } else {
                    LinkedList<AccessPathTask> tmp = new LinkedList<AccessPathTask>();
                    for (int i = 0; i < chunk.length; ++i) {
                        IBindingSet bindingSet = chunk[i];
                        IPredicate asBound = JoinTask.this.predicate.asBound(bindingSet);
                        if (asBound == null) continue;
                        if (JoinTask.this.partitionId != -1) {
                            asBound = asBound.setPartitionId(JoinTask.this.partitionId);
                        }
                        tmp.add(new AccessPathTask(asBound, Collections.singletonList(bindingSet)));
                    }
                    tasks = tmp.toArray(new AccessPathTask[tmp.size()]);
                }
                return tasks;
            }

            protected Map<IPredicate<E>, Collection<IBindingSet>> combineBindingSets(IBindingSet[] chunk) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("chunkSize=" + chunk.length));
                }
                HashMap map = new HashMap(chunk.length);
                for (IBindingSet bindingSet : chunk) {
                    IPredicate hashedPred;
                    LinkedList<IBindingSet> values;
                    JoinTask.this.halted();
                    IPredicate asBound = JoinTask.this.predicate.asBound(bindingSet);
                    if (asBound == null) continue;
                    if (JoinTask.this.partitionId != -1) {
                        asBound = asBound.setPartitionId(JoinTask.this.partitionId);
                    }
                    if ((values = (LinkedList<IBindingSet>)map.get(hashedPred = asBound)) == null) {
                        values = new LinkedList<IBindingSet>();
                        map.put(hashedPred, values);
                    } else {
                        ((JoinTask)JoinTask.this).stats.accessPathDups.increment();
                    }
                    values.add(bindingSet);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("chunkSize=" + chunk.length + ", #distinct predicates=" + map.size()));
                }
                return map;
            }

            protected AccessPathTask[] getAccessPathTasks(Map<IPredicate<E>, Collection<IBindingSet>> map) {
                int n = map.size();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("#distinct predicates=" + n));
                }
                AccessPathTask[] tasks = new AccessPathTask[n];
                Iterator itr = map.entrySet().iterator();
                int i = 0;
                while (itr.hasNext()) {
                    JoinTask.this.halted();
                    Map.Entry entry = itr.next();
                    tasks[i++] = new AccessPathTask(entry.getKey(), entry.getValue());
                }
                return tasks;
            }

            protected void reorderTasks(AccessPathTask[] tasks) {
                if (tasks[0].accessPath instanceof AccessPath) {
                    Arrays.sort(tasks);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            protected void executeTasks(AccessPathTask[] tasks) throws Exception {
                if (this.executor == null) {
                    void var4_7;
                    AccessPathTask[] arr$ = tasks;
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var4_7 < len$) {
                        AccessPathTask task = arr$[var4_7];
                        task.call();
                        ++var4_7;
                    }
                    return;
                }
                LinkedList<FutureTaskMon<Void>> futureTasks = new LinkedList<FutureTaskMon<Void>>();
                for (AccessPathTask task : tasks) {
                    FutureTaskMon<Void> ft = new FutureTaskMon<Void>(task);
                    futureTasks.add(ft);
                }
                try {
                    for (FutureTask futureTask : futureTasks) {
                        JoinTask.this.halted();
                        this.executor.execute(futureTask);
                    }
                    for (FutureTask futureTask : futureTasks) {
                        if (JoinTask.this.isDone()) continue;
                        futureTask.get();
                    }
                }
                finally {
                    for (FutureTask futureTask : futureTasks) {
                        futureTask.cancel(true);
                    }
                }
            }
        }
    }

    public static interface Annotations
    extends AccessPathJoinAnnotations {
        public static final String MAX_PARALLEL_CHUNKS = (PipelineJoin.class.getName() + ".maxParallelChunks").intern();
        public static final int DEFAULT_MAX_PARALLEL_CHUNKS = 0;
        public static final String COALESCE_DUPLICATE_ACCESS_PATHS = (PipelineJoin.class.getName() + ".coalesceDuplicateAccessPaths").intern();
        public static final boolean DEFAULT_COALESCE_DUPLICATE_ACCESS_PATHS = true;
        public static final String REORDER_ACCESS_PATHS = (PipelineJoin.class.getName() + ".reorderAccessPaths").intern();
        public static final boolean DEFAULT_REORDER_ACCESS_PATHS = true;
    }
}

