/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.joinGraph;

import com.bigdata.bop.joinGraph.IEvaluationPlan;
import com.bigdata.bop.joinGraph.IEvaluationPlanFactory;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.eval.IJoinNexus;
import java.util.Arrays;

public class FixedEvaluationPlanFactory
implements IEvaluationPlanFactory {
    private static final long serialVersionUID = 4374802847795489346L;
    private final int[] order;

    public FixedEvaluationPlanFactory(int[] order) {
        if (order == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < order.length; ++i) {
            int nfound = 0;
            for (int j = 0; j < order.length; ++j) {
                if (order[j] != i) continue;
                ++nfound;
            }
            if (nfound == 0) {
                throw new IllegalArgumentException("tailIndex=" + i + " is not in the evaluation order: " + Arrays.toString(order));
            }
            if (nfound <= true) continue;
            throw new IllegalArgumentException("tailIndex=" + i + " occurs more than once in the evaluation order: " + Arrays.toString(order));
        }
        this.order = order;
    }

    @Override
    public IEvaluationPlan newPlan(final IJoinNexus joinNexus, final IRule rule) {
        int tailCount = rule.getTailCount();
        if (this.order.length != tailCount) {
            throw new IllegalArgumentException("tailCount=" + tailCount + ", but have order[] of length=" + this.order.length);
        }
        return new IEvaluationPlan(){

            @Override
            public int[] getOrder() {
                return FixedEvaluationPlanFactory.this.order;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public long rangeCount(int tailIndex) {
                return joinNexus.getRangeCountFactory().rangeCount(rule.getTail(tailIndex));
            }

            public String toString() {
                return "order=" + Arrays.toString(FixedEvaluationPlanFactory.this.order);
            }
        };
    }
}

