/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.joinGraph;

import com.bigdata.bop.IPredicate;
import com.bigdata.bop.joinGraph.IEvaluationPlan;
import com.bigdata.relation.rule.IAccessPathExpander;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.eval.IJoinNexus;

public class NoReorderEvaluationPlan
implements IEvaluationPlan {
    protected final IJoinNexus joinNexus;
    protected final IRule rule;
    protected final long[] rangeCount;
    protected final int[] order;
    private boolean empty = false;

    public NoReorderEvaluationPlan(IJoinNexus joinNexus, IRule rule) {
        if (joinNexus == null) {
            throw new IllegalArgumentException();
        }
        if (rule == null) {
            throw new IllegalArgumentException();
        }
        this.joinNexus = joinNexus;
        this.rule = rule;
        int tailCount = rule.getTailCount();
        this.rangeCount = new long[tailCount];
        this.order = new int[tailCount];
        for (int i = 0; i < tailCount; ++i) {
            this.order[i] = i;
            this.rangeCount[i] = -1L;
        }
    }

    @Override
    public int[] getOrder() {
        return this.order;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public long rangeCount(int tailIndex) {
        if (this.rangeCount[tailIndex] == -1L) {
            long rangeCount;
            IPredicate predicate = this.rule.getTail(tailIndex);
            IAccessPathExpander expander = predicate.getAccessPathExpander();
            if (expander != null && expander.runFirst()) {
                return -1L;
            }
            this.rangeCount[tailIndex] = rangeCount = this.joinNexus.getRangeCountFactory().rangeCount(this.rule.getTail(tailIndex));
        }
        return this.rangeCount[tailIndex];
    }
}

