/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.mutation;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IShardwisePipelineOp;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class InsertOp<E>
extends PipelineOp
implements IShardwisePipelineOp<E> {
    private static final long serialVersionUID = 1L;

    public InsertOp(InsertOp<E> op) {
        super(op);
    }

    public InsertOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        this.getRequiredProperty(Annotations.SELECTED);
    }

    @Override
    public IPredicate<E> getPredicate() {
        return (IPredicate)this.getRequiredProperty(Annotations.SELECTED);
    }

    public String getRelation() {
        return (String)this.getRequiredProperty(Annotations.RELATION);
    }

    public IKeyOrder<E> getKeyOrder() {
        return (IKeyOrder)this.getRequiredProperty(Annotations.KEY_ORDER);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new InsertTask(this, context));
    }

    private static class InsertTask<E>
    implements Callable<Void> {
        private final BOpStats stats;
        private final BOpContext<IBindingSet> context;
        private final ICloseableIterator<IBindingSet[]> source;
        private final IBlockingBuffer<IBindingSet[]> sink;
        private IPredicate<E> predicate;
        private final IRelation<E> relation;
        private final IKeyOrder<E> keyOrder;

        InsertTask(InsertOp<E> op, BOpContext<IBindingSet> context) {
            this.context = context;
            this.stats = context.getStats();
            this.source = context.getSource();
            this.sink = context.getSink();
            this.predicate = op.getPredicate();
            this.relation = context.getRelation(this.predicate);
            this.keyOrder = op.getKeyOrder();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            ILocalBTreeView ndx = this.getMutableLocalIndexView(this.relation, this.keyOrder, this.context.getPartitionId());
            IKeyBuilder keyBuilder = ndx.getIndexMetadata().getKeyBuilder();
            ITupleSerializer tupleSer = ndx.getIndexMetadata().getTupleSerializer();
            try {
                while (this.source.hasNext()) {
                    IBindingSet[] chunk = (IBindingSet[])this.source.next();
                    this.stats.chunksIn.increment();
                    this.stats.unitsIn.add(chunk.length);
                    int nwritten = 0;
                    List<BOp> args = this.predicate.args();
                    for (int i = 0; i < chunk.length; ++i) {
                        IBindingSet bset = chunk[i];
                        E e = this.relation.newElement(args, bset);
                        byte[] key = this.keyOrder.getKey(keyBuilder, e);
                        if (ndx.contains(key)) continue;
                        byte[] val = tupleSer.serializeVal(e);
                        ndx.insert(key, val);
                        ++nwritten;
                    }
                    if (nwritten <= 0) continue;
                    this.stats.unitsOut.add(nwritten);
                    this.stats.chunksOut.increment();
                }
                Void void_ = null;
                return void_;
            }
            finally {
                this.sink.close();
            }
        }

        public <T> ILocalBTreeView getMutableLocalIndexView(IRelation<T> relation, IKeyOrder<T> keyOrder, int partitionId) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String SELECTED = (InsertOp.class.getName() + ".selected").intern();
        public static final String RELATION = (InsertOp.class.getName() + ".relation").intern();
        public static final String KEY_ORDER = (InsertOp.class.getName() + ".keyOrder").intern();
    }
}

