/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.solutions;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpBase;
import com.bigdata.bop.IBind;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableFactory;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.bop.aggregate.IAggregate;
import com.bigdata.bop.solutions.IGroupByRewriteState;
import com.bigdata.bop.solutions.IGroupByState;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class GroupByRewriter
implements IGroupByRewriteState,
IVariableFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private final LinkedHashMap<IAggregate<?>, IVariable<?>> aggExpr;
    private final IValueExpression<?>[] select2;
    private final IConstraint[] having2;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{aggExpr=" + this.aggExpr);
        sb.append(",select2=" + Arrays.toString(this.select2));
        sb.append(",having2=" + Arrays.toString(this.having2));
        sb.append("}");
        return sb.toString();
    }

    @Override
    public LinkedHashMap<IAggregate<?>, IVariable<?>> getAggExpr() {
        return this.aggExpr;
    }

    @Override
    public IValueExpression<?>[] getSelect2() {
        return this.select2;
    }

    @Override
    public IConstraint[] getHaving2() {
        return this.having2;
    }

    public GroupByRewriter(IGroupByRewriteState rewrittenState) {
        this.select2 = rewrittenState.getSelect2();
        this.having2 = rewrittenState.getHaving2();
        LinkedHashMap<IAggregate<?>, IVariable<?>> aggExpr = rewrittenState.getAggExpr();
        this.aggExpr = new LinkedHashMap();
        for (Map.Entry<IAggregate<?>, IVariable<?>> e : aggExpr.entrySet()) {
            this.aggExpr.put((IAggregate)e.getKey().clone(), e.getValue());
        }
    }

    public GroupByRewriter(IGroupByState groupByState) {
        BOp e;
        int i;
        if (groupByState == null) {
            throw new IllegalArgumentException();
        }
        this.aggExpr = new LinkedHashMap();
        IValueExpression<?>[] select = groupByState.getSelectClause();
        this.select2 = new IValueExpression[select.length];
        IConstraint[] having = groupByState.getHavingClause();
        if (having == null || having.length == 0) {
            this.having2 = null;
        } else {
            this.having2 = new IConstraint[having.length];
            for (i = 0; i < having.length; ++i) {
                e = having[i];
                this.having2[i] = GroupByRewriter.rewrite(e, (IVariableFactory)this, this.aggExpr);
            }
        }
        for (i = 0; i < select.length; ++i) {
            e = select[i];
            this.select2[i] = GroupByRewriter.rewrite(e, (IVariableFactory)this, this.aggExpr);
        }
    }

    public static IConstraint rewrite(IConstraint e, IVariableFactory f, LinkedHashMap<IAggregate<?>, IVariable<?>> aggExpr) {
        IValueExpression oldInnerExpr = (IValueExpression)e.get(0);
        IValueExpression<?> newInnerExpr = GroupByRewriter.rewrite(oldInnerExpr, f, aggExpr);
        if (newInnerExpr == oldInnerExpr) {
            return e;
        }
        return (IConstraint)((Object)((BOpBase)((Object)e)).setArg(0, newInnerExpr));
    }

    public static IValueExpression<?> rewrite(IValueExpression<?> e, IVariableFactory f, LinkedHashMap<IAggregate<?>, IVariable<?>> aggExpr) {
        IValueExpression expr;
        if (e instanceof IBind && (expr = ((IBind)e).getExpr()) instanceof IVariableOrConstant) {
            return e;
        }
        return GroupByRewriter.rewrite2(e, f, aggExpr);
    }

    private static IValueExpression<?> rewrite2(IValueExpression<?> expr, IVariableFactory f, LinkedHashMap<IAggregate<?>, IVariable<?>> aggExpr) {
        if (expr instanceof IVariableOrConstant || expr.arity() == 0) {
            return expr;
        }
        int index = 0;
        Iterator<BOp> itr = expr.argIterator();
        while (itr.hasNext()) {
            IValueExpression c = (IValueExpression)itr.next();
            IValueExpression<?> newC = GroupByRewriter.rewrite(c, f, aggExpr);
            if (newC != c) {
                expr = (IValueExpression)((Object)((BOpBase)((Object)expr)).setArg(index, newC));
            }
            ++index;
        }
        if (expr instanceof IAggregate) {
            IAggregate t = (IAggregate)expr;
            IVariable<?> anonVar = aggExpr.get(t);
            if (anonVar == null) {
                anonVar = f.var();
                aggExpr.put(t, anonVar);
            }
            return anonVar;
        }
        return expr;
    }

    @Override
    public IVariable<?> var() {
        return Var.var();
    }
}

