/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.solutions;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.HTreeAnnotations;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IQueryAttributes;
import com.bigdata.bop.ISingleThreadedOp;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.controller.NamedSetAnnotations;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.join.HTreeHashJoinUtility;
import com.bigdata.bop.join.JoinTypeEnum;
import com.bigdata.bop.solutions.DistinctAnnotations;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class HTreeDistinctBindingSetsOp
extends PipelineOp
implements ISingleThreadedOp {
    private static final long serialVersionUID = 1L;

    public HTreeDistinctBindingSetsOp(HTreeDistinctBindingSetsOp op) {
        super(op);
    }

    public HTreeDistinctBindingSetsOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        switch (this.getEvaluationContext()) {
            case CONTROLLER: 
            case HASHED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(Annotations.EVALUATION_CONTEXT + "=" + (Object)((Object)this.getEvaluationContext()));
            }
        }
        this.assertMaxParallelOne();
        INamedSolutionSetRef namedSetRef = (INamedSolutionSetRef)this.getRequiredProperty("namedSetRef");
        IVariable[] vars = (IVariable[])this.getProperty(Annotations.VARIABLES);
        if (vars == null || vars.length == 0) {
            throw new IllegalArgumentException();
        }
    }

    public HTreeDistinctBindingSetsOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new DistinctTask(this, context));
    }

    private static class DistinctTask
    implements Callable<Void> {
        private final HTreeDistinctBindingSetsOp op;
        private final BOpContext<IBindingSet> context;
        private final HTreeHashJoinUtility state;

        DistinctTask(HTreeDistinctBindingSetsOp op, BOpContext<IBindingSet> context) {
            this.op = op;
            this.context = context;
            INamedSolutionSetRef namedSetRef = (INamedSolutionSetRef)op.getRequiredProperty("namedSetRef");
            IQueryAttributes attrs = context.getQueryAttributes(namedSetRef.getQueryId());
            HTreeHashJoinUtility state = (HTreeHashJoinUtility)attrs.get(namedSetRef);
            if (state == null && attrs.putIfAbsent(namedSetRef, state = new HTreeHashJoinUtility(context.getMemoryManager(namedSetRef.getQueryId()), op, JoinTypeEnum.Filter)) != null) {
                throw new AssertionError();
            }
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BOpStats stats = this.context.getStats();
            ICloseableIterator<IBindingSet[]> itr = this.context.getSource();
            IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();
            try {
                UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer = new UnsyncLocalOutputBuffer<IBindingSet>(this.op.getChunkCapacity(), sink);
                this.state.filterSolutions(itr, stats, unsyncBuffer);
                unsyncBuffer.flush();
                sink.flush();
                Void void_ = null;
                return void_;
            }
            finally {
                if (this.context.isLastInvocation()) {
                    this.state.release();
                }
                sink.close();
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations,
    HTreeAnnotations,
    DistinctAnnotations,
    NamedSetAnnotations {
    }
}

