/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.solutions;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.HashMapAnnotations;
import com.bigdata.bop.IBind;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.ISingleThreadedOp;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.aggregate.IAggregate;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.solutions.GroupByOp;
import com.bigdata.bop.solutions.IGroupByRewriteState;
import com.bigdata.bop.solutions.IGroupByState;
import com.bigdata.bop.solutions.TypeErrorLog;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.util.InnerCause;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public class PipelinedAggregationOp
extends GroupByOp
implements ISingleThreadedOp {
    private static final transient Logger log = Logger.getLogger(PipelinedAggregationOp.class);
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isPipelinedAggregationOp() {
        return true;
    }

    public PipelinedAggregationOp(PipelinedAggregationOp op) {
        super(op);
    }

    public PipelinedAggregationOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        switch (this.getEvaluationContext()) {
            case CONTROLLER: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(Annotations.EVALUATION_CONTEXT + "=" + (Object)((Object)this.getEvaluationContext()));
            }
        }
        this.getRequiredProperty(Annotations.GROUP_BY_STATE);
        this.getRequiredProperty(Annotations.GROUP_BY_REWRITE);
        if (!this.isSharedState()) {
            throw new UnsupportedOperationException(Annotations.SHARED_STATE + "=" + this.isSharedState());
        }
        if (!this.isLastPassRequested()) {
            throw new UnsupportedOperationException(Annotations.LAST_PASS + "=" + this.isLastPassRequested());
        }
        this.assertMaxParallelOne();
    }

    public int getInitialCapacity() {
        return this.getProperty(Annotations.INITIAL_CAPACITY, 16);
    }

    public float getLoadFactor() {
        return this.getProperty(Annotations.LOAD_FACTOR, Float.valueOf(0.75f)).floatValue();
    }

    @Override
    public BOpStats newStats() {
        return new AggregateStats(this);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(this, context));
    }

    private static void doAggregate(LinkedHashMap<IAggregate<?>, IVariable<?>> aggExpr, IBindingSet bset, BOpStats stats) {
        for (IAggregate<?> a : aggExpr.keySet()) {
            try {
                a.get(bset);
            }
            catch (Throwable t) {
                if (!InnerCause.isInnerCause(t, SparqlTypeErrorException.class)) continue;
                TypeErrorLog.handleTypeError(t, a, stats);
            }
        }
    }

    private static void finalizeAggregates(LinkedHashMap<IAggregate<?>, IVariable<?>> aggExpr, IBindingSet aggregates, BOpStats stats) {
        for (Map.Entry<IAggregate<?>, IVariable<?>> e : aggExpr.entrySet()) {
            Object val;
            IAggregate<?> expr = e.getKey();
            try {
                val = expr.done();
            }
            catch (Throwable t) {
                if (InnerCause.isInnerCause(t, SparqlTypeErrorException.class)) {
                    TypeErrorLog.handleTypeError(t, expr, stats);
                    continue;
                }
                throw new RuntimeException(t);
            }
            if (val == null) continue;
            aggregates.set(e.getValue(), new Constant(val));
        }
    }

    private static class ChunkTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final LinkedHashMap<SolutionGroup, SolutionGroupState> map;
        private final LinkedHashMap<IAggregate<?>, IVariable<?>> aggExpr;
        private final IGroupByState groupByState;
        private final IGroupByRewriteState rewrite;
        private final IValueExpression<?>[] groupBy;
        private final Object sharedStateKey;
        private final BOpStats stats;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ChunkTask(PipelinedAggregationOp op, BOpContext<IBindingSet> context) {
            SharedState sharedState;
            this.context = context;
            this.sharedStateKey = op.getId();
            AggregateStats stats = (AggregateStats)context.getStats();
            this.stats = stats;
            AggregateStats aggregateStats = stats;
            synchronized (aggregateStats) {
                if (stats.first) {
                    stats.first = false;
                    sharedState = new SharedState(op, stats);
                    context.getRunningQuery().getAttributes().put(this.sharedStateKey, sharedState);
                } else {
                    sharedState = (SharedState)context.getRunningQuery().getAttributes().get(this.sharedStateKey);
                }
            }
            this.map = sharedState.map;
            this.aggExpr = sharedState.aggExpr;
            this.groupByState = stats.groupByState;
            this.rewrite = stats.rewrite;
            this.groupBy = stats.groupByState.getGroupByClause();
        }

        private void release() {
            this.context.getRunningQuery().getAttributes().remove(this.sharedStateKey);
        }

        private void accept(IBindingSet bset) {
            if (this.groupBy == null || this.groupBy.length == 0) {
                throw new IllegalArgumentException();
            }
            if (bset == null) {
                throw new IllegalArgumentException();
            }
            SolutionGroup s = SolutionGroup.newInstance(this.groupBy, bset, this.stats);
            if (s == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dropping solution: " + bset));
                }
                return;
            }
            SolutionGroupState m = this.map.get(s);
            if (m == null) {
                m = new SolutionGroupState(this.groupBy, this.rewrite.getAggExpr(), bset);
                this.map.put(s, m);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Accepting solution: " + bset));
            }
            PipelinedAggregationOp.doAggregate(m.aggExpr, bset, this.stats);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            ICloseableIterator<IBindingSet[]> itr = this.context.getSource();
            try (IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();){
                while (itr.hasNext()) {
                    IBindingSet[] a = (IBindingSet[])itr.next();
                    this.stats.chunksIn.increment();
                    this.stats.unitsIn.add(a.length);
                    for (IBindingSet bset : a) {
                        if (this.groupBy == null) {
                            PipelinedAggregationOp.doAggregate(this.aggExpr, bset, this.stats);
                            continue;
                        }
                        this.accept(bset);
                    }
                }
                if (this.context.isLastInvocation()) {
                    LinkedList<IBindingSet> outList = new LinkedList<IBindingSet>();
                    if (this.groupBy == null) {
                        ListBindingSet aggregates = new ListBindingSet();
                        PipelinedAggregationOp.finalizeAggregates(this.aggExpr, aggregates, this.stats);
                        for (IValueExpression<?> expr : this.rewrite.getSelect2()) {
                            try {
                                expr.get(aggregates);
                            }
                            catch (SparqlTypeErrorException ex) {
                                TypeErrorLog.handleTypeError(ex, expr, this.stats);
                            }
                            catch (IllegalArgumentException ex) {
                                TypeErrorLog.handleTypeError(ex, expr, this.stats);
                            }
                        }
                        IConstraint[] having2 = this.rewrite.getHaving2();
                        boolean drop = having2 != null && !BOpUtility.isConsistent(having2, aggregates);
                        if (log.isInfoEnabled()) {
                            log.info((Object)((drop ? "drop" : "keep") + " : " + aggregates));
                        }
                        if (!drop) {
                            IBindingSet out = aggregates.copy(this.groupByState.getSelectVars().toArray(new IVariable[0]));
                            outList.add(out);
                        }
                    } else {
                        for (SolutionGroupState groupState : this.map.values()) {
                            IBindingSet aggregates = groupState.aggregates;
                            PipelinedAggregationOp.finalizeAggregates(groupState.aggExpr, aggregates, this.stats);
                            for (IValueExpression<?> expr : this.rewrite.getSelect2()) {
                                try {
                                    expr.get(aggregates);
                                }
                                catch (SparqlTypeErrorException ex) {
                                    TypeErrorLog.handleTypeError(ex, expr, this.stats);
                                }
                                catch (IllegalArgumentException ex) {
                                    TypeErrorLog.handleTypeError(ex, expr, this.stats);
                                }
                            }
                            IConstraint[] having2 = this.rewrite.getHaving2();
                            boolean drop = having2 != null && !BOpUtility.isConsistent(having2, aggregates);
                            if (log.isInfoEnabled()) {
                                log.info((Object)((drop ? "drop" : "keep") + " : " + aggregates));
                            }
                            if (drop) continue;
                            IBindingSet out = aggregates.copy(this.groupByState.getSelectVars().toArray(new IVariable[0]));
                            outList.add(out);
                        }
                    }
                    if (!outList.isEmpty()) {
                        sink.add(outList.toArray(new IBindingSet[0]));
                        sink.flush();
                    }
                    this.release();
                }
                Void void_ = null;
                return void_;
            }
        }
    }

    private static class SharedState {
        private final LinkedHashMap<SolutionGroup, SolutionGroupState> map;
        private final LinkedHashMap<IAggregate<?>, IVariable<?>> aggExpr;

        SharedState(PipelinedAggregationOp op, AggregateStats stats) {
            if (stats.groupByState.getGroupByClause() == null) {
                this.map = null;
                this.aggExpr = stats.rewrite.getAggExpr();
            } else {
                this.map = new LinkedHashMap(op.getInitialCapacity(), op.getLoadFactor());
                this.aggExpr = null;
            }
        }
    }

    private static class AggregateStats
    extends BOpStats {
        private static final long serialVersionUID = 1L;
        private boolean first = true;
        private final IGroupByState groupByState;
        private final IGroupByRewriteState rewrite;

        public AggregateStats(PipelinedAggregationOp op) {
            this.groupByState = (IGroupByState)op.getRequiredProperty(Annotations.GROUP_BY_STATE);
            this.rewrite = (IGroupByRewriteState)op.getRequiredProperty(Annotations.GROUP_BY_REWRITE);
            if (this.groupByState.isAnyDistinct()) {
                throw new UnsupportedOperationException("DISTINCT not allowed with pipelined aggregation.");
            }
            if (this.groupByState.isNestedAggregates()) {
                throw new UnsupportedOperationException("Nested aggregates not allowed with pipelined aggregation.");
            }
        }
    }

    private static class SolutionGroupState {
        private final LinkedHashMap<IAggregate<?>, IVariable<?>> aggExpr = new LinkedHashMap();
        private final IBindingSet aggregates;

        SolutionGroupState(IValueExpression<?>[] groupBy, LinkedHashMap<IAggregate<?>, IVariable<?>> aggExpr, IBindingSet bset) {
            for (Map.Entry<IAggregate<?>, IVariable<?>> e : aggExpr.entrySet()) {
                this.aggExpr.put((IAggregate)e.getKey().clone(), e.getValue());
            }
            this.aggregates = new ListBindingSet();
            IBindingSet aSolution = bset;
            for (IValueExpression<?> expr : groupBy) {
                Constant val;
                if (expr instanceof IVariable) {
                    IVariable var = (IVariable)expr;
                    val = new Constant(var.get(aSolution));
                    this.aggregates.set(var, val);
                    continue;
                }
                if (!(expr instanceof IBind)) continue;
                IBind bindExpr = (IBind)expr;
                val = new Constant(bindExpr.get(aSolution));
                IVariable ovar = ((IBind)expr).getVar();
                this.aggregates.set(ovar, val);
            }
        }
    }

    private static class SolutionGroup {
        private final int hash;
        private final IConstant<?>[] vals;

        public String toString() {
            return super.toString() + "{group=" + Arrays.toString(this.vals) + "}";
        }

        static SolutionGroup newInstance(IValueExpression<?>[] groupBy, IBindingSet bset, BOpStats stats) {
            IConstant[] r = new IConstant[groupBy.length];
            for (int i = 0; i < groupBy.length; ++i) {
                Constant x;
                Object asBound;
                IValueExpression<?> expr = groupBy[i];
                try {
                    asBound = expr.get(bset);
                }
                catch (SparqlTypeErrorException ex) {
                    TypeErrorLog.handleTypeError(ex, expr, stats);
                    return null;
                }
                if (asBound == null) {
                    return null;
                }
                r[i] = x = new Constant(asBound);
            }
            return new SolutionGroup(r);
        }

        private SolutionGroup(IConstant<?>[] vals) {
            this.vals = vals;
            this.hash = Arrays.hashCode(vals);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SolutionGroup)) {
                return false;
            }
            SolutionGroup t = (SolutionGroup)o;
            if (this.vals.length != t.vals.length) {
                return false;
            }
            for (int i = 0; i < this.vals.length; ++i) {
                if (this.vals[i] == t.vals[i]) continue;
                if (this.vals[i] == null) {
                    return false;
                }
                if (this.vals[i].equals(t.vals[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations,
    HashMapAnnotations,
    GroupByOp.Annotations {
    }
}

