/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.solutions;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.join.JoinAnnotations;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class ProjectionOp
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public ProjectionOp(ProjectionOp op) {
        super(op);
    }

    public ProjectionOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public ProjectionOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    public IVariable<?>[] getVariables() {
        return (IVariable[])this.getRequiredProperty(Annotations.SELECT);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(this, context));
    }

    private static class ChunkTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final IVariable<?>[] vars;

        ChunkTask(ProjectionOp op, BOpContext<IBindingSet> context) {
            this.context = context;
            this.vars = op.getVariables();
            if (this.vars == null) {
                throw new IllegalArgumentException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BOpStats stats = this.context.getStats();
            ICloseableIterator<IBindingSet[]> itr = this.context.getSource();
            try (IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();){
                while (itr.hasNext()) {
                    IBindingSet[] a = (IBindingSet[])itr.next();
                    stats.chunksIn.increment();
                    stats.unitsIn.add(a.length);
                    for (int i = 0; i < a.length; ++i) {
                        a[i] = a[i].copy(this.vars);
                    }
                    sink.add(a);
                }
                sink.flush();
                Void void_ = null;
                return void_;
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String SELECT = JoinAnnotations.SELECT;
    }
}

