/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.solutions;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.solutions.ISolutionSet;
import com.bigdata.btree.BaseIndexStats;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.io.SerializerUtil;
import com.bigdata.rawstore.IPSOutputStream;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.rdf.internal.encoder.SolutionSetStreamDecoder;
import com.bigdata.rdf.internal.encoder.SolutionSetStreamEncoder;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import com.bigdata.stream.Stream;
import com.bigdata.striterator.Chunkerator;
import cutthecrap.utils.striterators.ArrayIterator;
import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.Striterator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class SolutionSetStream
extends Stream
implements ISolutionSet {
    private static final Logger log = Logger.getLogger(SolutionSetStream.class);
    private MySolutionSetStats solutionSetStats;

    public SolutionSetStream(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
        super(store, checkpoint, metadata, readOnly);
    }

    public static SolutionSetStream create(IRawStore store, Stream.StreamIndexMetadata metadata) {
        metadata.setStreamClassName(SolutionSetStream.class.getName());
        return Stream.create(store, metadata);
    }

    @Override
    public ISolutionSetStats getStats() {
        return this.solutionSetStats;
    }

    public long getStatsAddr() {
        if (this.solutionSetStats != null) {
            return this.solutionSetStats.addr;
        }
        return this.getCheckpoint().getBloomFilterAddr();
    }

    @Override
    public ICloseableIterator<IBindingSet[]> get() {
        if (this.rootAddr == 0L) {
            throw new IllegalStateException();
        }
        DataInputStream in = new DataInputStream(this.wrapInputStream(this.getStore().getInputStream(this.rootAddr)));
        SolutionSetStreamDecoder decoder = new SolutionSetStreamDecoder(this.metadata.getName(), in, this.rangeCount());
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ICloseableIterator<IBindingSet[]> src2) {
        long newAddr;
        if (src2 == null) {
            throw new IllegalArgumentException();
        }
        this.assertNotReadOnly();
        String name = this.metadata.getName();
        SolutionSetStreamEncoder encoder = new SolutionSetStreamEncoder(name);
        IPSOutputStream out = this.getStore().getOutputStream();
        try {
            DataOutputStream os = new DataOutputStream(this.wrapOutputStream(out));
            try {
                encoder.encode(os, src2);
                os.flush();
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            out.flush();
            newAddr = out.getAddr();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (this.rootAddr != 0L) {
            this.recycle(this.rootAddr);
        }
        if (this.solutionSetStats != null && this.solutionSetStats.addr != 0L) {
            this.recycle(this.solutionSetStats.addr);
        }
        this.rootAddr = newAddr;
        this.entryCount = encoder.getSolutionCount();
        this.solutionSetStats = new MySolutionSetStats(encoder.getStats());
        this.fireDirtyEvent();
    }

    @Override
    public ICloseableIterator<IBindingSet> scan() {
        return (ICloseableIterator)((Object)new Striterator(this.get()).addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator expand(Object obj) {
                return new ArrayIterator<IBindingSet>((IBindingSet[])obj);
            }
        }));
    }

    @Override
    public void clear() {
        super.clear();
        this.solutionSetStats = null;
    }

    @Override
    protected boolean needsCheckpoint() {
        if (super.needsCheckpoint()) {
            return true;
        }
        if (this.solutionSetStats != null && this.solutionSetStats.addr != this.getCheckpoint().getBloomFilterAddr()) {
            return true;
        }
        return this.solutionSetStats == null && this.getCheckpoint().getBloomFilterAddr() != 0L;
    }

    @Override
    protected void flush() {
        super.flush();
        if (this.solutionSetStats != null && (this.solutionSetStats.addr == 0L || this.solutionSetStats.addr != this.getCheckpoint().getBloomFilterAddr())) {
            this.solutionSetStats.addr = this.getStore().write(ByteBuffer.wrap(SerializerUtil.serialize(this.solutionSetStats.delegate)));
        }
    }

    @Override
    protected void setCheckpoint(Checkpoint checkpoint) {
        super.setCheckpoint(checkpoint);
        long addr = checkpoint.getBloomFilterAddr();
        if (addr != 0L) {
            this.solutionSetStats = new MySolutionSetStats((ISolutionSetStats)SerializerUtil.deserialize(this.getStore().read(addr)));
            this.solutionSetStats.addr = addr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ICloseableIterator<?> src) {
        try {
            this.put(new Chunkerator(src));
        }
        finally {
            src.close();
        }
    }

    @Override
    public BaseIndexStats dumpPages(boolean recursive) {
        return new BaseIndexStats(this);
    }

    private final class MySolutionSetStats
    implements ISolutionSetStats {
        private ISolutionSetStats delegate;
        private long addr;

        public MySolutionSetStats(ISolutionSetStats stats) {
            this.delegate = stats;
        }

        @Override
        public long getSolutionSetSize() {
            return this.delegate.getSolutionSetSize();
        }

        @Override
        public Set<IVariable<?>> getUsedVars() {
            return this.delegate.getUsedVars();
        }

        @Override
        public Set<IVariable<?>> getAlwaysBound() {
            return this.delegate.getAlwaysBound();
        }

        @Override
        public Set<IVariable<?>> getNotAlwaysBound() {
            return this.delegate.getNotAlwaysBound();
        }

        @Override
        public Set<IVariable<?>> getMaterialized() {
            return this.delegate.getMaterialized();
        }

        @Override
        public Map<IVariable<?>, IConstant<?>> getConstants() {
            return this.delegate.getConstants();
        }
    }
}

