/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.counters.CAT;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.Instrument;
import java.util.concurrent.atomic.AtomicLong;

public final class BTreeCounters
implements Cloneable,
ICounterSetAccess {
    public final AtomicLong ninserts = new AtomicLong();
    public final AtomicLong nremoves = new AtomicLong();
    public final CAT nindexOf = new CAT();
    public final CAT ngetKey = new CAT();
    public final CAT ngetValue = new CAT();
    public final CAT nrangeCount = new CAT();
    public final CAT nrangeIterator = new CAT();
    public int rootsSplit = 0;
    public int rootsJoined = 0;
    public int nodesSplit = 0;
    public int nodesJoined = 0;
    public int leavesSplit = 0;
    public int leavesJoined = 0;
    public int tailSplit = 0;
    public int headSplit = 0;
    public int nodesCopyOnWrite = 0;
    public int leavesCopyOnWrite = 0;
    public long ntupleInsertValue = 0L;
    public long ntupleInsertDelete = 0L;
    public long ntupleUpdateValue = 0L;
    public long ntupleUpdateDelete = 0L;
    public long ntupleRemove = 0L;
    public final CAT nodesRead = new CAT();
    public final CAT leavesRead = new CAT();
    public final CAT bytesRead = new CAT();
    public final CAT readNanos = new CAT();
    public final CAT deserializeNanos = new CAT();
    public final CAT rawRecordsRead = new CAT();
    public final CAT rawRecordsBytesRead = new CAT();
    public int nodesWritten = 0;
    public int leavesWritten = 0;
    public long bytesWritten = 0L;
    public long bytesReleased = 0L;
    public long writeNanos = 0L;
    public long serializeNanos = 0L;
    public long rawRecordsWritten = 0L;
    public long rawRecordsBytesWritten = 0L;
    public final AtomicLong bytesOnStore_rawRecords = new AtomicLong();
    public final AtomicLong bytesOnStore_nodesAndLeaves = new AtomicLong();

    public BTreeCounters() {
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public BTreeCounters(BTreeCounters c) {
        this.add(c);
    }

    public BTreeCounters clone() {
        BTreeCounters tmp = new BTreeCounters();
        tmp.add(this);
        return tmp;
    }

    public void add(BTreeCounters o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        this.ninserts.addAndGet(o.ninserts.get());
        this.nremoves.addAndGet(o.nremoves.get());
        this.nindexOf.add(o.nindexOf.get());
        this.ngetKey.add(o.ngetKey.get());
        this.ngetValue.add(o.ngetValue.get());
        this.nrangeCount.add(o.nrangeCount.get());
        this.nrangeIterator.add(o.nrangeIterator.get());
        this.rootsSplit += o.rootsSplit;
        this.rootsJoined += o.rootsJoined;
        this.nodesSplit += o.nodesSplit;
        this.nodesJoined += o.nodesJoined;
        this.leavesSplit += o.leavesSplit;
        this.leavesJoined += o.leavesJoined;
        this.headSplit += o.headSplit;
        this.tailSplit += o.tailSplit;
        this.nodesCopyOnWrite += o.nodesCopyOnWrite;
        this.leavesCopyOnWrite += o.leavesCopyOnWrite;
        this.ntupleInsertValue += o.ntupleInsertValue;
        this.ntupleInsertDelete += o.ntupleInsertDelete;
        this.ntupleUpdateValue += o.ntupleUpdateValue;
        this.ntupleUpdateDelete += o.ntupleUpdateDelete;
        this.ntupleRemove += o.ntupleRemove;
        this.nodesRead.add(o.nodesRead.get());
        this.leavesRead.add(o.leavesRead.get());
        this.bytesRead.add(o.bytesRead.get());
        this.readNanos.add(o.readNanos.get());
        this.deserializeNanos.add(o.deserializeNanos.get());
        this.rawRecordsRead.add(o.rawRecordsRead.get());
        this.rawRecordsBytesRead.add(o.rawRecordsBytesRead.get());
        this.nodesWritten += o.nodesWritten;
        this.leavesWritten += o.leavesWritten;
        this.bytesWritten += o.bytesWritten;
        this.bytesReleased += o.bytesReleased;
        this.writeNanos += o.writeNanos;
        this.serializeNanos += o.serializeNanos;
        this.rawRecordsWritten += o.rawRecordsWritten;
        this.rawRecordsBytesWritten += o.rawRecordsBytesWritten;
    }

    public BTreeCounters subtract(BTreeCounters o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        BTreeCounters t = new BTreeCounters(this);
        t.ninserts.addAndGet(-o.ninserts.get());
        t.nremoves.addAndGet(-o.nremoves.get());
        t.nindexOf.add(-o.nindexOf.get());
        t.ngetKey.add(-o.ngetKey.get());
        t.ngetValue.add(-o.ngetValue.get());
        t.nrangeCount.add(-o.nrangeCount.get());
        t.nrangeIterator.add(-o.nrangeIterator.get());
        t.rootsSplit -= o.rootsSplit;
        t.rootsJoined -= o.rootsJoined;
        t.nodesSplit -= o.nodesSplit;
        t.nodesJoined -= o.nodesJoined;
        t.leavesSplit -= o.leavesSplit;
        t.leavesJoined -= o.leavesJoined;
        t.headSplit -= o.headSplit;
        t.tailSplit -= o.tailSplit;
        t.nodesCopyOnWrite -= o.nodesCopyOnWrite;
        t.leavesCopyOnWrite -= o.leavesCopyOnWrite;
        t.ntupleInsertValue -= o.ntupleInsertValue;
        t.ntupleInsertDelete -= o.ntupleInsertDelete;
        t.ntupleUpdateValue -= o.ntupleUpdateValue;
        t.ntupleUpdateDelete -= o.ntupleUpdateDelete;
        t.ntupleRemove -= o.ntupleRemove;
        t.nodesRead.add(-o.nodesRead.get());
        t.leavesRead.add(-o.leavesRead.get());
        t.bytesRead.add(-o.bytesRead.get());
        t.readNanos.add(-o.readNanos.get());
        t.deserializeNanos.add(-o.deserializeNanos.get());
        t.rawRecordsRead.add(-o.rawRecordsRead.get());
        t.rawRecordsBytesRead.add(-o.rawRecordsBytesRead.get());
        t.nodesWritten -= o.nodesWritten;
        t.leavesWritten -= o.leavesWritten;
        t.bytesWritten -= o.bytesWritten;
        t.bytesReleased -= o.bytesReleased;
        t.serializeNanos -= o.serializeNanos;
        t.writeNanos -= o.writeNanos;
        t.rawRecordsWritten -= o.rawRecordsWritten;
        t.rawRecordsBytesWritten -= o.rawRecordsBytesWritten;
        return t;
    }

    public double computeRawReadWriteScore() {
        return this.serializeNanos + this.deserializeNanos.get() + (this.writeNanos + this.readNanos.get());
    }

    public double computeRawReadScore() {
        return this.deserializeNanos.get() + this.readNanos.get();
    }

    public double computeRawWriteScore() {
        return this.serializeNanos + this.writeNanos;
    }

    public static double normalize(double rawScore, double totalRawScore) {
        if (totalRawScore == 0.0) {
            return 0.0;
        }
        return rawScore / totalRawScore;
    }

    public final int getNodesWritten() {
        return this.nodesWritten;
    }

    public final int getLeavesWritten() {
        return this.leavesWritten;
    }

    public final long getBytesRead() {
        return this.bytesRead.get();
    }

    public final long getBytesWritten() {
        return this.bytesWritten;
    }

    public final long getBytesReleased() {
        return this.bytesReleased;
    }

    @Override
    public CounterSet getCounters() {
        CounterSet counterSet = new CounterSet();
        CounterSet tmp = counterSet.makePath("KeySearch");
        tmp.addCounter("insert", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.ninserts.get());
            }
        });
        tmp.addCounter("remove", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.nremoves.get());
            }
        });
        tmp = counterSet.makePath("LinearList");
        tmp.addCounter("indexOf", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.nindexOf.get());
            }
        });
        tmp.addCounter("getKey", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.ngetKey.get());
            }
        });
        tmp.addCounter("getValue", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.ngetValue.get());
            }
        });
        tmp = counterSet.makePath("RangeQuery");
        tmp.addCounter("rangeCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.nrangeCount.get());
            }
        });
        tmp.addCounter("rangeIterator", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.nrangeIterator.get());
            }
        });
        tmp = counterSet.makePath("Structure");
        tmp.addCounter("rootSplit", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.rootsSplit);
            }
        });
        tmp.addCounter("rootJoined", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.rootsJoined);
            }
        });
        tmp.addCounter("nodeSplit", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.nodesSplit);
            }
        });
        tmp.addCounter("nodeJoined", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.nodesJoined);
            }
        });
        tmp.addCounter("leafSplit", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.leavesSplit);
            }
        });
        tmp.addCounter("leafJoined", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.leavesJoined);
            }
        });
        tmp.addCounter("headSplit", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.headSplit);
            }
        });
        tmp.addCounter("tailSplit", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.tailSplit);
            }
        });
        tmp.addCounter("leafCopyOnWrite", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.leavesCopyOnWrite);
            }
        });
        tmp.addCounter("nodeCopyOnWrite", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.nodesCopyOnWrite);
            }
        });
        tmp = counterSet.makePath("Tuples");
        tmp.addCounter("insertValue", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.ntupleInsertValue);
            }
        });
        tmp.addCounter("insertDelete", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.ntupleInsertDelete);
            }
        });
        tmp.addCounter("updateValue", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.ntupleUpdateValue);
            }
        });
        tmp.addCounter("updateDelete", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.ntupleUpdateDelete);
            }
        });
        tmp.addCounter("tupleRemove", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.ntupleRemove);
            }
        });
        tmp = counterSet.makePath("IO");
        tmp.addCounter("bytesOnStoreNodesAndLeaves", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.bytesOnStore_nodesAndLeaves.get());
            }
        });
        tmp.addCounter("bytesOnStoreRawRecords", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.bytesOnStore_rawRecords.get());
            }
        });
        tmp.addCounter("bytesOnStoreTotal", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.bytesOnStore_nodesAndLeaves.get() + BTreeCounters.this.bytesOnStore_rawRecords.get());
            }
        });
        tmp.addCounter("leafReadCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.leavesRead.get());
            }
        });
        tmp.addCounter("nodeReadCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.nodesRead.get());
            }
        });
        tmp.addCounter("leafWriteCount", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.leavesWritten);
            }
        });
        tmp.addCounter("nodeWriteCount", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.nodesWritten);
            }
        });
        tmp.addCounter("bytesRead", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.bytesRead.get());
            }
        });
        tmp.addCounter("readSecs", new Instrument<Double>(){

            @Override
            public void sample() {
                double elapsedReadSecs = (double)BTreeCounters.this.readNanos.get() / 1.0E9;
                this.setValue(elapsedReadSecs);
            }
        });
        tmp.addCounter("bytesReadPerSec", new Instrument<Double>(){

            @Override
            public void sample() {
                double readSecs = (double)BTreeCounters.this.readNanos.get() / 1.0E9;
                double bytesReadPerSec = readSecs == 0.0 ? 0.0 : (double)BTreeCounters.this.bytesRead.get() / readSecs;
                this.setValue(bytesReadPerSec);
            }
        });
        tmp.addCounter("bytesWritten", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.bytesWritten);
            }
        });
        tmp.addCounter("writeSecs", new Instrument<Double>(){

            @Override
            public void sample() {
                double writeSecs = (double)BTreeCounters.this.writeNanos / 1.0E9;
                this.setValue(writeSecs);
            }
        });
        tmp.addCounter("bytesWrittenPerSec", new Instrument<Double>(){

            @Override
            public void sample() {
                double writeSecs = (double)BTreeCounters.this.writeNanos / 1.0E9;
                double bytesWrittenPerSec = writeSecs == 0.0 ? 0.0 : (double)BTreeCounters.this.bytesWritten / writeSecs;
                this.setValue(bytesWrittenPerSec);
            }
        });
        tmp.addCounter("serializeSecs", new Instrument<Double>(){

            @Override
            public void sample() {
                double serializeSecs = (double)BTreeCounters.this.serializeNanos / 1.0E9;
                this.setValue(serializeSecs);
            }
        });
        tmp.addCounter("serializePerSec", new Instrument<Double>(){

            @Override
            public void sample() {
                double serializeSecs = (double)BTreeCounters.this.serializeNanos / 1.0E9;
                double serializePerSec = serializeSecs == 0.0 ? 0.0 : (double)(BTreeCounters.this.nodesRead.get() + BTreeCounters.this.leavesRead.get()) / serializeSecs;
                this.setValue(serializePerSec);
            }
        });
        tmp.addCounter("deserializeSecs", new Instrument<Double>(){

            @Override
            public void sample() {
                double deserializeSecs = (double)BTreeCounters.this.deserializeNanos.get() / 1.0E9;
                this.setValue(deserializeSecs);
            }
        });
        tmp.addCounter("deserializePerSec", new Instrument<Double>(){

            @Override
            public void sample() {
                double deserializeSecs = (double)BTreeCounters.this.deserializeNanos.get() / 1.0E9;
                double deserializePerSec = deserializeSecs == 0.0 ? 0.0 : (double)(BTreeCounters.this.nodesRead.get() + BTreeCounters.this.leavesRead.get()) / deserializeSecs;
                this.setValue(deserializePerSec);
            }
        });
        tmp.addCounter("totalReadWriteSecs", new Instrument<Double>(){

            @Override
            public void sample() {
                double secs = BTreeCounters.this.computeRawReadWriteScore() / 1.0E9;
                this.setValue(secs);
            }
        });
        tmp.addCounter("totalReadSecs", new Instrument<Double>(){

            @Override
            public void sample() {
                double secs = BTreeCounters.this.computeRawReadScore() / 1.0E9;
                this.setValue(secs);
            }
        });
        tmp.addCounter("totalWriteSecs", new Instrument<Double>(){

            @Override
            public void sample() {
                double secs = BTreeCounters.this.computeRawWriteScore() / 1.0E9;
                this.setValue(secs);
            }
        });
        tmp.addCounter("rawRecordsRead", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.rawRecordsRead.get());
            }
        });
        tmp.addCounter("rawRecordsBytesRead", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.rawRecordsBytesRead.get());
            }
        });
        tmp.addCounter("rawRecordsWritten", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.rawRecordsWritten);
            }
        });
        tmp.addCounter("rawRecordsBytesWritten", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.rawRecordsBytesWritten);
            }
        });
        tmp.addCounter("bytesReleased", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(BTreeCounters.this.bytesReleased);
            }
        });
        return counterSet;
    }

    public String toString() {
        return this.getCounters().asXML(null);
    }
}

