/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.filter.TupleFilter;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class BigdataMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V> {
    final IIndex ndx;
    final boolean deleteMarkers;
    final ITupleSerializer tupleSer;
    final byte[] fromKey;
    final byte[] toKey;

    public IIndex getIndex() {
        return this.ndx;
    }

    public BigdataMap(IIndex ndx) {
        this(ndx, null, null);
    }

    BigdataMap(IIndex ndx, byte[] fromKey, byte[] toKey) {
        if (ndx == null) {
            throw new IllegalArgumentException();
        }
        this.ndx = ndx;
        IndexMetadata md = ndx.getIndexMetadata();
        this.deleteMarkers = md.getDeleteMarkers();
        this.tupleSer = md.getTupleSerializer();
        this.fromKey = fromKey;
        this.toKey = toKey;
    }

    private boolean rangeCheck(Object key, boolean allowUpperBound) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.rangeCheck(this.tupleSer.serializeKey(key), allowUpperBound);
    }

    private boolean rangeCheck(byte[] key, boolean allowUpperBound) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.fromKey == null && this.toKey == null) {
            return true;
        }
        byte[] k = this.tupleSer.serializeKey(key);
        if (BytesUtil.compareBytes(k, this.fromKey) < 0) {
            throw new RuntimeException("KeyBeforeRange: key=" + BytesUtil.toString(k));
        }
        if (this.toKey != null) {
            int ret = BytesUtil.compareBytes(k, this.toKey);
            if (allowUpperBound) {
                if (ret > 0) {
                    throw new RuntimeException("KeyAfterRange: key=" + BytesUtil.toString(k) + ", allowUpperBound=" + allowUpperBound);
                }
            } else if (ret >= 0) {
                throw new RuntimeException("KeyAfterRange: key=" + BytesUtil.toString(k) + ", allowUpperBound=" + allowUpperBound);
            }
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.fromKey == null && this.toKey == null && this.ndx instanceof AbstractBTree) {
            ((AbstractBTree)this.ndx).removeAll();
        } else {
            this.ndx.rangeIterator(this.fromKey, this.toKey, 0, 16, null);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        super.putAll(t);
    }

    @Override
    public V get(Object key) {
        this.rangeCheck(key, false);
        return (V)this.ndx.lookup(key);
    }

    @Override
    public V put(K key, V val) {
        this.rangeCheck(key, false);
        return (V)this.ndx.insert(key, val);
    }

    @Override
    public V remove(Object key) {
        this.rangeCheck(key, false);
        return (V)this.ndx.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        this.rangeCheck(key, false);
        return this.ndx.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        final byte[] val = this.tupleSer.serializeVal(value);
        ITupleIterator itr = this.ndx.rangeIterator(this.fromKey, this.toKey, 0, 2, new TupleFilter(){
            private static final long serialVersionUID = 1L;

            protected boolean isValid(ITuple tuple) {
                return BytesUtil.bytesEqual(tuple.getValue(), val);
            }
        });
        return itr.hasNext();
    }

    @Override
    public int size() {
        long n = this.rangeCount(true);
        if (n > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)n;
    }

    @Override
    public boolean isEmpty() {
        if (this.ndx instanceof AbstractBTree && ((AbstractBTree)this.ndx).getEntryCount() == 0L) {
            return true;
        }
        ITupleIterator itr = this.ndx.rangeIterator(this.fromKey, this.toKey, 0, 0, null);
        return !itr.hasNext();
    }

    public long rangeCount(boolean exactCount) {
        if (exactCount && this.ndx.getIndexMetadata().getDeleteMarkers()) {
            long n = 0L;
            ITupleIterator itr = this.ndx.rangeIterator(this.fromKey, this.toKey, 0, 0, null);
            while (itr.hasNext()) {
                itr.next();
                ++n;
            }
            return n;
        }
        return this.ndx.rangeCount(this.fromKey, this.toKey);
    }

    @Override
    public final Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public K firstKey() {
        ITupleIterator itr = this.ndx.rangeIterator(this.fromKey, this.toKey, 1, 3, null);
        if (!itr.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.tupleSer.deserializeKey(itr.next());
    }

    @Override
    public K lastKey() {
        ITupleIterator itr = this.ndx.rangeIterator(this.fromKey, this.toKey, 1, 67, null);
        if (!itr.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.tupleSer.deserializeKey(itr.next());
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        byte[] k = this.tupleSer.serializeKey(toKey);
        this.rangeCheck(k, false);
        return new BigdataMap<K, V>(this.ndx, k, this.fromKey);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        byte[] kf = this.tupleSer.serializeKey(fromKey);
        byte[] kt = this.tupleSer.serializeKey(toKey);
        this.rangeCheck(kf, false);
        this.rangeCheck(kt, true);
        return new BigdataMap<K, V>(this.ndx, kf, kt);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        byte[] k = this.tupleSer.serializeKey(fromKey);
        this.rangeCheck(k, false);
        return new BigdataMap<K, V>(this.ndx, this.toKey, k);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    protected class Entry
    implements Map.Entry<K, V> {
        private final ITuple tuple;
        private K key;
        private V val;

        public Entry(ITuple tuple) {
            if (tuple == null) {
                throw new IllegalArgumentException();
            }
            this.tuple = tuple;
        }

        @Override
        public K getKey() {
            if (this.key == null) {
                this.key = BigdataMap.this.tupleSer.deserializeKey(this.tuple);
            }
            return this.key;
        }

        @Override
        public V getValue() {
            if (this.val == null) {
                this.val = BigdataMap.this.tupleSer.deserialize(this.tuple);
            }
            return this.val;
        }

        @Override
        public V setValue(V value) {
            this.val = value;
            return BigdataMap.this.put(this.getKey(), value);
        }
    }

    protected class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        private final ITupleIterator src;

        EntrySetIterator(ITupleIterator src) {
            if (src == null) {
                throw new IllegalArgumentException();
            }
            this.src = src;
        }

        @Override
        public boolean hasNext() {
            return this.src.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.src.hasNext()) {
                throw new NoSuchElementException();
            }
            return new Entry(this.src.next());
        }

        @Override
        public void remove() {
            this.src.remove();
        }
    }

    protected class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        protected EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(BigdataMap.this.ndx.rangeIterator(BigdataMap.this.fromKey, BigdataMap.this.toKey));
        }

        @Override
        public int size() {
            return BigdataMap.this.size();
        }
    }
}

