/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.AbstractBTreeTupleCursor;
import com.bigdata.btree.AbstractNode;
import com.bigdata.btree.BTree;
import com.bigdata.btree.BloomFilter;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.ICheckpoint;
import com.bigdata.btree.ICounter;
import com.bigdata.btree.IDirtyListener;
import com.bigdata.btree.ILeafCursor;
import com.bigdata.btree.INodeFactory;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexSegmentAddressManager;
import com.bigdata.btree.IndexSegmentCheckpoint;
import com.bigdata.btree.IndexSegmentStore;
import com.bigdata.btree.Leaf;
import com.bigdata.btree.Node;
import com.bigdata.btree.SeekEnum;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.btree.data.INodeData;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.ReadOnlyKeysRaba;
import com.bigdata.btree.raba.ReadOnlyValuesRaba;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.FixedByteArrayBuffer;
import com.bigdata.service.Event;
import com.bigdata.service.EventResource;
import com.bigdata.service.EventType;
import java.io.IOException;

public class IndexSegment
extends AbstractBTree {
    private final IndexSegmentStore fileStore;
    private volatile Event openCloseEvent = null;

    @Override
    public final int getHeight() {
        return this.fileStore.getCheckpoint().height;
    }

    @Override
    public final long getNodeCount() {
        return this.fileStore.getCheckpoint().nnodes;
    }

    @Override
    public final long getLeafCount() {
        return this.fileStore.getCheckpoint().nleaves;
    }

    @Override
    public final long getEntryCount() {
        return this.fileStore.getCheckpoint().nentries;
    }

    @Override
    public final ICheckpoint getCheckpoint() {
        return this.fileStore.getCheckpoint();
    }

    @Override
    public long getRecordVersion() {
        return this.getCheckpoint().getRecordVersion();
    }

    @Override
    public long getMetadataAddr() {
        return this.getCheckpoint().getMetadataAddr();
    }

    @Override
    public long getRootAddr() {
        return this.getCheckpoint().getRootAddr();
    }

    @Override
    public void setLastCommitTime(long lastCommitTime) {
        throw new UnsupportedOperationException("Read-only");
    }

    @Override
    public long writeCheckpoint() {
        throw new UnsupportedOperationException("Read-only");
    }

    @Override
    public Checkpoint writeCheckpoint2() {
        throw new UnsupportedOperationException("Read-only");
    }

    @Override
    public IDirtyListener getDirtyListener() {
        throw new UnsupportedOperationException("Read-only");
    }

    @Override
    public void setDirtyListener(IDirtyListener listener) {
        throw new UnsupportedOperationException("Read-only");
    }

    @Override
    public long handleCommit(long commitTime) {
        throw new UnsupportedOperationException("Read-only");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{ ");
        IndexMetadata metadata = this.fileStore.getIndexMetadata();
        if (metadata.getName() != null) {
            sb.append("name=" + metadata.getName());
        } else {
            sb.append("uuid=" + metadata.getIndexUUID());
        }
        IndexSegmentCheckpoint chk = this.fileStore.getCheckpoint();
        sb.append(", m=" + this.branchingFactor);
        sb.append(", height=" + chk.height);
        sb.append(", entryCount=" + chk.nentries);
        sb.append(", nodeCount=" + chk.nnodes);
        sb.append(", leafCount=" + chk.nleaves);
        sb.append(", lastCommitTime=" + chk.commitTime);
        sb.append("}");
        return sb.toString();
    }

    public IndexSegment(IndexSegmentStore fileStore) {
        super(fileStore, ImmutableNodeFactory.INSTANCE, true, fileStore.getIndexMetadata(), fileStore.getIndexMetadata().getIndexSegmentRecordCompressorFactory());
        this.fileStore = fileStore;
        this._reopen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.root == null) {
            throw new IllegalStateException("Closed");
        }
        this.fileStore.lock.lock();
        try {
            super.close();
            this.fileStore.close();
            if (this.openCloseEvent != null) {
                this.openCloseEvent.end();
                this.openCloseEvent = null;
            }
        }
        finally {
            this.fileStore.lock.unlock();
        }
    }

    @Override
    public final IndexSegmentStore getStore() {
        return this.fileStore;
    }

    protected void finalize() throws Throwable {
        if (this.isOpen()) {
            if (INFO) {
                log.info((Object)("Closing IndexSegment: " + this.fileStore.getFile()));
            }
            this.close();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _reopen() {
        block10: {
            this.fileStore.lock.lock();
            try {
                long addrRoot;
                if (this.fileStore.fed != null) {
                    this.openCloseEvent = new Event(this.fileStore.fed, new EventResource(this.fileStore.getIndexMetadata(), this.fileStore.file), (Object)EventType.IndexSegmentOpenClose);
                }
                if (!this.fileStore.isOpen()) {
                    this.fileStore.reopen();
                }
                IndexSegmentCheckpoint checkpoint = this.fileStore.getCheckpoint();
                boolean bufferNodes = this.metadata.getIndexSegmentBufferNodes();
                if (checkpoint.nnodes > 0 && bufferNodes) {
                    try {
                        this.fileStore.bufferIndexNodes();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                this.root = (addrRoot = checkpoint.addrRoot) == 0L ? new ImmutableNodeFactory.ImmutableLeaf(this) : this.readNodeOrLeaf(addrRoot);
                if (checkpoint.addrBloom == 0L) break block10;
                try {
                    this.bloomFilter = this.fileStore.readBloomFilter();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            finally {
                this.fileStore.lock.unlock();
            }
        }
    }

    @Override
    public final BloomFilter getBloomFilter() {
        this.reopen();
        return this.bloomFilter;
    }

    @Override
    public final long getLastCommitTime() {
        return this.fileStore.getCheckpoint().commitTime;
    }

    @Override
    public final long getRevisionTimestamp() {
        throw new UnsupportedOperationException("Read-only");
    }

    @Override
    public final ICounter getCounter() {
        throw new UnsupportedOperationException("Read-only");
    }

    @Override
    public final void removeAll() {
        throw new UnsupportedOperationException("Read-only");
    }

    public ImmutableNodeFactory.ImmutableLeaf readLeaf(long addr) {
        ImmutableNodeFactory.ImmutableLeaf leaf = (ImmutableNodeFactory.ImmutableLeaf)this.readNodeOrLeaf(addr);
        return leaf;
    }

    @Override
    protected AbstractNode<?> readNodeOrLeaf(long addr) {
        if (!this.fileStore.isOpen()) {
            this.fileStore.reopen();
        }
        AbstractNode<?> node = super.readNodeOrLeaf(addr);
        return node;
    }

    public ImmutableNodeFactory.ImmutableLeaf findLeaf(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        assert (this.rangeCheck(key, true));
        if (this.getStore().getCheckpoint().height == 0) {
            return (ImmutableNodeFactory.ImmutableLeaf)this.getRoot();
        }
        return this.readLeaf(this.findLeafAddr(key));
    }

    public long findLeafAddr(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        assert (this.rangeCheck(key, true));
        int height = this.getStore().getCheckpoint().height;
        if (height == 0) {
            return this.getStore().getCheckpoint().addrRoot;
        }
        IndexSegmentAddressManager am = this.getStore().getAddressManager();
        Node node = this.getRootOrFinger(key);
        int i = 0;
        while (true) {
            int childIndex;
            long childAddr;
            if (am.isLeafAddr(childAddr = ((Node)node).getChildAddr(childIndex = ((Node)node).findChild(key)))) {
                return childAddr;
            }
            node = (Node)((Node)node).getChild(childIndex);
            assert (++i <= height) : "Exceeded tree height";
        }
    }

    @Override
    public ImmutableLeafCursor newLeafCursor(SeekEnum where) {
        return new ImmutableLeafCursor(where);
    }

    @Override
    public ImmutableLeafCursor newLeafCursor(byte[] key) {
        return new ImmutableLeafCursor(key);
    }

    @Override
    public BTree getMutableBTree() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSourceCount() {
        return 1;
    }

    @Override
    public AbstractBTree[] getSources() {
        return new AbstractBTree[]{this};
    }

    public class ImmutableLeafCursor
    implements ILeafCursor<ImmutableNodeFactory.ImmutableLeaf> {
        private ImmutableNodeFactory.ImmutableLeaf leaf;

        @Override
        public ImmutableNodeFactory.ImmutableLeaf leaf() {
            return this.leaf;
        }

        @Override
        public IndexSegment getBTree() {
            return IndexSegment.this;
        }

        public ImmutableLeafCursor clone() {
            return new ImmutableLeafCursor(this);
        }

        private ImmutableLeafCursor(ImmutableLeafCursor src) {
            if (src == null) {
                throw new IllegalArgumentException();
            }
            this.leaf = src.leaf;
        }

        public ImmutableLeafCursor(SeekEnum where) {
            switch (where) {
                case First: {
                    this.first();
                    break;
                }
                case Last: {
                    this.last();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown seek directive: " + (Object)((Object)where)));
                }
            }
        }

        public ImmutableLeafCursor(byte[] key) {
            this.seek(key);
        }

        @Override
        public ImmutableNodeFactory.ImmutableLeaf seek(byte[] key) {
            this.leaf = IndexSegment.this.findLeaf(key);
            return this.leaf;
        }

        @Override
        public ImmutableNodeFactory.ImmutableLeaf seek(ILeafCursor<ImmutableNodeFactory.ImmutableLeaf> src) {
            if (src == null) {
                throw new IllegalArgumentException();
            }
            if (src == this) {
                return this.leaf;
            }
            if (src.getBTree() != IndexSegment.this) {
                throw new IllegalArgumentException();
            }
            this.leaf = src.leaf();
            return this.leaf;
        }

        @Override
        public ImmutableNodeFactory.ImmutableLeaf first() {
            long addr = IndexSegment.this.getStore().getCheckpoint().addrFirstLeaf;
            this.leaf = IndexSegment.this.readLeaf(addr);
            return this.leaf;
        }

        @Override
        public ImmutableNodeFactory.ImmutableLeaf last() {
            long addr = IndexSegment.this.getStore().getCheckpoint().addrLastLeaf;
            this.leaf = IndexSegment.this.readLeaf(addr);
            return this.leaf;
        }

        @Override
        public ImmutableNodeFactory.ImmutableLeaf next() {
            ImmutableNodeFactory.ImmutableLeaf l = this.leaf.nextLeaf();
            if (l == null) {
                return null;
            }
            this.leaf = l;
            return l;
        }

        @Override
        public ImmutableNodeFactory.ImmutableLeaf prior() {
            ImmutableNodeFactory.ImmutableLeaf l = this.leaf.priorLeaf();
            if (l == null) {
                return null;
            }
            this.leaf = l;
            return l;
        }
    }

    public static class IndexSegmentTupleCursor<E>
    extends AbstractBTreeTupleCursor<IndexSegment, ImmutableNodeFactory.ImmutableLeaf, E> {
        public IndexSegmentTupleCursor(IndexSegment btree, Tuple<E> tuple, byte[] fromKey, byte[] toKey) {
            super(btree, tuple, fromKey, toKey);
        }

        protected final CursorPosition<E> newPosition(ILeafCursor<ImmutableNodeFactory.ImmutableLeaf> leafCursor, int index, byte[] key) {
            CursorPosition pos = new CursorPosition(this, leafCursor, index, key);
            return pos;
        }

        protected CursorPosition<E> newTemporaryPosition(AbstractBTreeTupleCursor.ICursorPosition<ImmutableNodeFactory.ImmutableLeaf, E> p) {
            return new CursorPosition((CursorPosition)p);
        }
    }

    private static class CursorPosition<E>
    extends AbstractBTreeTupleCursor.AbstractCursorPosition<ImmutableNodeFactory.ImmutableLeaf, E> {
        @Override
        public IndexSegmentTupleCursor<E> getCursor() {
            return (IndexSegmentTupleCursor)this.cursor;
        }

        public CursorPosition(IndexSegmentTupleCursor<E> cursor, ILeafCursor<ImmutableNodeFactory.ImmutableLeaf> leafCursor, int index, byte[] key) {
            super(cursor, leafCursor, index, key);
        }

        public CursorPosition(CursorPosition<E> p) {
            super(p);
        }
    }

    protected static class ImmutableNodeFactory
    implements INodeFactory {
        public static final INodeFactory INSTANCE = new ImmutableNodeFactory();

        private ImmutableNodeFactory() {
        }

        @Override
        public Leaf allocLeaf(AbstractBTree btree, long addr, ILeafData data) {
            return new ImmutableLeaf(btree, addr, data);
        }

        @Override
        public Node allocNode(AbstractBTree btree, long addr, INodeData data) {
            return new ImmutableNode(btree, addr, data);
        }

        public static class ImmutableLeaf
        extends Leaf {
            protected ImmutableLeaf(AbstractBTree btree) {
                super(btree);
                this.data = new EmptyReadOnlyLeafData(btree.getIndexMetadata().getDeleteMarkers(), btree.getIndexMetadata().getVersionTimestamps(), btree.getIndexMetadata().getRawRecords());
            }

            protected ImmutableLeaf(AbstractBTree btree, long addr, ILeafData data) {
                super(btree, addr, data);
            }

            @Override
            public void delete() {
                throw new UnsupportedOperationException("Read-only");
            }

            @Override
            public Tuple insert(byte[] key, byte[] val, boolean deleted, long timestamp, Tuple tuple) {
                throw new UnsupportedOperationException("Read-only");
            }

            @Override
            public Tuple remove(byte[] key, Tuple tuple) {
                throw new UnsupportedOperationException("Read-only");
            }

            public ImmutableLeaf nextLeaf() {
                long nextAddr = this.getNextAddr();
                if (nextAddr == 0L) {
                    if (INFO) {
                        log.info((Object)"No more leaves");
                    }
                    return null;
                }
                return ((IndexSegment)this.btree).readLeaf(nextAddr);
            }

            public ImmutableLeaf priorLeaf() {
                long priorAddr = this.getPriorAddr();
                if (priorAddr == 0L) {
                    if (INFO) {
                        log.info((Object)"No more leaves");
                    }
                    return null;
                }
                return ((IndexSegment)this.btree).readLeaf(priorAddr);
            }
        }

        private static class EmptyReadOnlyLeafData
        implements ILeafData {
            private final boolean deleteMarkers;
            private final boolean versionTimestamps;
            private final boolean rawRecords;

            public EmptyReadOnlyLeafData(boolean deleteMarkers, boolean versionTimestamps, boolean rawRecords) {
                this.deleteMarkers = deleteMarkers;
                this.versionTimestamps = versionTimestamps;
                this.rawRecords = rawRecords;
            }

            @Override
            public final boolean hasDeleteMarkers() {
                return this.deleteMarkers;
            }

            @Override
            public final boolean hasVersionTimestamps() {
                return this.versionTimestamps;
            }

            @Override
            public final boolean hasRawRecords() {
                return this.rawRecords;
            }

            @Override
            public final int getValueCount() {
                return 0;
            }

            @Override
            public final IRaba getValues() {
                return ReadOnlyValuesRaba.EMPTY;
            }

            @Override
            public final boolean getDeleteMarker(int index) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public final long getVersionTimestamp(int index) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public final long getRawRecord(int index) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public final boolean isDoubleLinked() {
                return true;
            }

            @Override
            public final long getNextAddr() {
                return 0L;
            }

            @Override
            public final long getPriorAddr() {
                return 0L;
            }

            @Override
            public final int getKeyCount() {
                return 0;
            }

            @Override
            public final IRaba getKeys() {
                return ReadOnlyKeysRaba.EMPTY;
            }

            @Override
            public final long getMaximumVersionTimestamp() {
                return Long.MIN_VALUE;
            }

            @Override
            public final long getMinimumVersionTimestamp() {
                return Long.MAX_VALUE;
            }

            @Override
            public final boolean isLeaf() {
                return true;
            }

            @Override
            public final boolean isReadOnly() {
                return true;
            }

            @Override
            public final boolean isCoded() {
                return true;
            }

            @Override
            public final AbstractFixedByteArrayBuffer data() {
                return FixedByteArrayBuffer.EMPTY;
            }
        }

        public static class ImmutableNode
        extends Node {
            protected ImmutableNode(AbstractBTree btree, long addr, INodeData data) {
                super(btree, addr, data);
            }

            @Override
            public void delete() {
                throw new UnsupportedOperationException("Read-only");
            }

            @Override
            public Tuple insert(byte[] key, byte[] val, boolean deleted, long timestamp, Tuple tuple) {
                throw new UnsupportedOperationException("Read-only");
            }

            @Override
            public Tuple remove(byte[] key, Tuple tuple) {
                throw new UnsupportedOperationException("Read-only");
            }
        }
    }
}

