/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.LRUNexus;
import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.BloomFilter;
import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.IBloomFilter;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.INodeFactory;
import com.bigdata.btree.IOverflowHandler;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.IndexSegmentCheckpoint;
import com.bigdata.btree.IndexSegmentPlan;
import com.bigdata.btree.IndexSegmentRegion;
import com.bigdata.btree.IndexSegmentStore;
import com.bigdata.btree.Leaf;
import com.bigdata.btree.MutableLeafData;
import com.bigdata.btree.Node;
import com.bigdata.btree.NodeSerializer;
import com.bigdata.btree.ViewStatistics;
import com.bigdata.btree.data.IAbstractNodeData;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.btree.data.INodeData;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.MutableKeyBuffer;
import com.bigdata.btree.raba.MutableValueBuffer;
import com.bigdata.cache.IGlobalLRU;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.NOPReopener;
import com.bigdata.io.SerializerUtil;
import com.bigdata.io.writecache.WriteCache;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Name2Addr;
import com.bigdata.journal.TemporaryRawStore;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.mdi.SegmentMetadata;
import com.bigdata.rawstore.IBlock;
import com.bigdata.rawstore.WormAddressManager;
import com.bigdata.util.ChecksumUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class IndexSegmentBuilder
implements Callable<IndexSegmentCheckpoint> {
    private static final Logger log = Logger.getLogger(IndexSegmentBuilder.class);
    protected static final String ERR_TOO_MANY_TUPLES = "Too many tuples";
    protected static final String ERR_NO_TUPLES = "No tuples";
    final String mode = "rw";
    public final File outFile;
    public final long entryCount;
    private final ITupleIterator<?> entryIterator;
    public final long commitTime;
    public final boolean compactingMerge;
    final String name;
    public final IndexMetadata metadata;
    final boolean isolatable;
    final boolean deleteMarkers;
    final boolean versionTimestamps;
    final boolean rawRecords;
    private final ByteArrayBuffer recordAddrBuf;
    public final UUID segmentUUID;
    private final IGlobalLRU.ILRUCache<Long, Object> storeCache;
    private final NodeSerializer nodeSer;
    final int offsetBits = 38;
    private final WormAddressManager addressManager;
    final IBloomFilter bloomFilter;
    private final boolean useChecksums = false;
    private final ChecksumUtility checker = new ChecksumUtility();
    protected RandomAccessFile out = null;
    private IndexSegmentCheckpoint checkpoint;
    private WriteCache.FileChannelWriteCache leafWriteCache;
    private TemporaryRawStore nodeBuffer;
    private List<NodeMetadata> nodeList;
    protected final boolean bufferNodes;
    private TemporaryRawStore blobBuffer;
    private final IOverflowHandler overflowHandler;
    private long addrFirstLeaf = 0L;
    private long addrLastLeaf = 0L;
    int maxNodeOrLeafLength = 0;
    long ntuplesWritten;
    int nnodesWritten = 0;
    int nleavesWritten = 0;
    final int[] writtenInLevel;
    final AbstractSimpleNodeData[] stack;
    final SimpleLeafData leaf;
    public final IndexSegmentPlan plan;
    private long begin_build;
    public final long elapsed_setup;
    public long elapsed_build;
    public long elapsed_write;
    public long elapsed;
    public float mbPerSec;
    private final AtomicLong leafAddrFactory = new AtomicLong(0L);
    private final AtomicLong nodeAddrFactory = new AtomicLong(0L);
    private long addrPriorLeaf = 0L;
    private long bufLastLeafAddr = 0L;
    private ILeafData lastLeafData;
    private SegmentMetadata segmentMetadata = null;

    public IndexSegmentCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    public long getStartTime() {
        return this.begin_build;
    }

    public static IndexSegmentBuilder newInstance(ILocalBTreeView src, File outFile, File tmpDir, boolean compactingMerge, long createTime, byte[] fromKey, byte[] toKey) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (outFile == null) {
            throw new IllegalArgumentException();
        }
        if (tmpDir == null) {
            throw new IllegalArgumentException();
        }
        if (createTime <= 0L) {
            throw new IllegalArgumentException();
        }
        int m = src.getIndexMetadata().getIndexSegmentBranchingFactor();
        long fastRangeCount = src.rangeCount(fromKey, toKey);
        ViewStatistics stats = new ViewStatistics(src);
        long MAX_SIZE_ON_DISK = 0x19000000L;
        long MAX_TUPLES_IN_VIEW = 0x800000L;
        return IndexSegmentBuilder.newInstanceTwoPass(src, outFile, tmpDir, m, compactingMerge, createTime, fromKey, toKey, false);
    }

    protected static IndexSegmentBuilder newInstanceTwoPass(ILocalBTreeView src, File outFile, File tmpDir, int m, boolean compactingMerge, long createTime, byte[] fromKey, byte[] toKey, boolean bufferNodes) throws IOException {
        int nentries;
        long n;
        int flags;
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (outFile == null) {
            throw new IllegalArgumentException();
        }
        if (tmpDir == null) {
            throw new IllegalArgumentException();
        }
        if (createTime <= 0L) {
            throw new IllegalArgumentException();
        }
        if (compactingMerge) {
            flags = 3;
            n = src.rangeCountExact(fromKey, toKey);
            if (n > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException(ERR_TOO_MANY_TUPLES);
            }
            nentries = (int)n;
        } else {
            flags = 7;
            n = src.rangeCountExactWithDeleted(fromKey, toKey);
            if (n > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException(ERR_TOO_MANY_TUPLES);
            }
            nentries = (int)n;
        }
        ITupleIterator itr = src.rangeIterator(fromKey, toKey, 0, flags, null);
        IndexMetadata indexMetadata = src.getIndexMetadata();
        return IndexSegmentBuilder.newInstance(outFile, tmpDir, nentries, itr, m, indexMetadata, createTime, compactingMerge, bufferNodes);
    }

    protected static IndexSegmentBuilder newInstanceFullyBuffered(ILocalBTreeView src, File outFile, File tmpDir, int m, boolean compactingMerge, long createTime, byte[] fromKey, byte[] toKey, boolean bufferNodes) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (outFile == null) {
            throw new IllegalArgumentException();
        }
        if (tmpDir == null) {
            throw new IllegalArgumentException();
        }
        if (createTime <= 0L) {
            throw new IllegalArgumentException();
        }
        IndexMetadata indexMetadata = src.getIndexMetadata();
        long fastRangeCount = src.rangeCount(fromKey, toKey);
        boolean hasVersionTimestamps = indexMetadata.getVersionTimestamps();
        boolean hasDeleteMarkers = indexMetadata.getDeleteMarkers();
        boolean hasRawRecords = indexMetadata.getRawRecords();
        MutableLeafData tleaf = new MutableLeafData((int)fastRangeCount, hasVersionTimestamps, hasDeleteMarkers, hasRawRecords);
        int flags = compactingMerge ? 3 : 7;
        ITupleIterator titr = src.rangeIterator(fromKey, toKey, (int)fastRangeCount, flags, null);
        int i = 0;
        long minimumVersionTimestamp = Long.MAX_VALUE;
        long maximumVersionTimestamp = Long.MIN_VALUE;
        while (titr.hasNext()) {
            ITuple tuple = titr.next();
            tleaf.keys.keys[i] = tuple.getKey();
            if (hasVersionTimestamps) {
                long t;
                tleaf.versionTimestamps[i] = t = tuple.getVersionTimestamp();
                if (t < minimumVersionTimestamp) {
                    minimumVersionTimestamp = t;
                }
                if (t > maximumVersionTimestamp) {
                    maximumVersionTimestamp = t;
                }
            }
            if (hasDeleteMarkers && tuple.isDeletedVersion()) {
                tleaf.deleteMarkers[i] = true;
            } else {
                tleaf.vals.values[i] = tuple.getValue();
            }
            ++i;
        }
        tleaf.keys.nkeys = i;
        tleaf.vals.nvalues = i;
        tleaf.maximumVersionTimestamp = maximumVersionTimestamp;
        tleaf.minimumVersionTimestamp = minimumVersionTimestamp;
        int nentries = i;
        MyTupleIterator itr = new MyTupleIterator(tleaf, flags);
        return IndexSegmentBuilder.newInstance(outFile, tmpDir, nentries, itr, m, indexMetadata, createTime, compactingMerge, bufferNodes);
    }

    public static IndexSegmentBuilder newInstance(Object[] a, int alen, IndexMetadata indexMetadata, File outFile, File tmpDir, int m, boolean compactingMerge, long createTime, boolean bufferNodes) throws IOException {
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (alen < 0) {
            throw new IllegalArgumentException();
        }
        if (alen > a.length) {
            throw new IllegalArgumentException();
        }
        if (indexMetadata == null) {
            throw new IllegalArgumentException();
        }
        if (outFile == null) {
            throw new IllegalArgumentException();
        }
        if (tmpDir == null) {
            throw new IllegalArgumentException();
        }
        if (createTime <= 0L) {
            throw new IllegalArgumentException();
        }
        boolean hasVersionTimestamps = indexMetadata.getVersionTimestamps();
        if (hasVersionTimestamps) {
            throw new IllegalArgumentException("versionTimestamps not available in source [].");
        }
        boolean hasDeleteMarkers = indexMetadata.getDeleteMarkers();
        if (hasDeleteMarkers && !compactingMerge) {
            throw new IllegalArgumentException("deleteMarkers not available in source [].");
        }
        boolean hasRawRecords = indexMetadata.getRawRecords();
        MutableLeafData tleaf = new MutableLeafData(alen, hasVersionTimestamps, hasDeleteMarkers, hasRawRecords);
        int flags = compactingMerge ? 3 : 7;
        long minimumVersionTimestamp = Long.MAX_VALUE;
        long maximumVersionTimestamp = Long.MIN_VALUE;
        ITupleSerializer tupSer = indexMetadata.getTupleSerializer();
        for (int i = 0; i < alen; ++i) {
            tleaf.keys.keys[i] = tupSer.serializeKey(a[i]);
            tleaf.vals.values[i] = tupSer.serializeVal(a[i]);
        }
        tleaf.keys.nkeys = alen;
        tleaf.vals.nvalues = alen;
        tleaf.maximumVersionTimestamp = maximumVersionTimestamp;
        tleaf.minimumVersionTimestamp = minimumVersionTimestamp;
        int nentries = alen;
        MyTupleIterator itr = new MyTupleIterator(tleaf, flags);
        return IndexSegmentBuilder.newInstance(outFile, tmpDir, nentries, itr, m, indexMetadata, createTime, compactingMerge, bufferNodes);
    }

    public static IndexSegmentBuilder newInstance(File outFile, File tmpDir, long entryCount, ITupleIterator<?> entryIterator, int m, IndexMetadata metadata, long commitTime, boolean compactingMerge, boolean bufferNodes) throws IOException {
        return new IndexSegmentBuilder(outFile, tmpDir, entryCount, entryIterator, m, metadata, commitTime, compactingMerge, bufferNodes);
    }

    protected IndexSegmentBuilder(File outFile, File tmpDir, long entryCount, ITupleIterator<?> entryIterator, int m, IndexMetadata metadata, long commitTime, boolean compactingMerge, boolean bufferNodes) throws IOException {
        if (outFile == null) {
            throw new IllegalArgumentException();
        }
        if (tmpDir == null) {
            throw new IllegalArgumentException();
        }
        if (entryCount < 0L) {
            throw new IllegalArgumentException();
        }
        if (entryCount == 0L && log.isInfoEnabled()) {
            log.info((Object)ERR_NO_TUPLES);
        }
        if (entryIterator == null) {
            throw new IllegalArgumentException();
        }
        if (commitTime <= 0L) {
            throw new IllegalArgumentException();
        }
        long begin_setup = System.currentTimeMillis();
        this.segmentUUID = UUID.randomUUID();
        this.entryCount = entryCount;
        this.entryIterator = entryIterator;
        this.name = metadata.getPartitionMetadata() == null ? (metadata.getName() == null ? "N/A" : metadata.getName()) : metadata.getName() + "#" + metadata.getPartitionMetadata().getPartitionId();
        this.metadata = metadata = metadata.clone();
        LocalPartitionMetadata pmd = this.metadata.getPartitionMetadata();
        if (pmd != null) {
            this.metadata.setPartitionMetadata(new LocalPartitionMetadata(pmd.getPartitionId(), pmd.getSourcePartitionId(), pmd.getLeftSeparatorKey(), pmd.getRightSeparatorKey(), null, pmd.getIndexPartitionCause()));
        }
        this.isolatable = metadata.isIsolatable();
        this.versionTimestamps = metadata.getVersionTimestamps();
        this.deleteMarkers = metadata.getDeleteMarkers();
        this.rawRecords = metadata.getRawRecords();
        this.recordAddrBuf = this.rawRecords ? new ByteArrayBuffer(8) : null;
        this.commitTime = commitTime;
        this.compactingMerge = compactingMerge;
        this.bufferNodes = bufferNodes;
        this.metadata.setBranchingFactor(m);
        this.metadata.setBTreeClassName(IndexSegment.class.getName());
        this.addressManager = new WormAddressManager(38);
        this.storeCache = LRUNexus.INSTANCE != null && LRUNexus.getIndexSegmentBuildPopulatesCache() ? LRUNexus.INSTANCE.getCache(this.segmentUUID, this.addressManager) : null;
        this.plan = new IndexSegmentPlan(m, entryCount);
        this.stack = new AbstractSimpleNodeData[this.plan.height + 1];
        this.writtenInLevel = new int[this.plan.height + 1];
        for (int h = 0; h < this.plan.height; ++h) {
            SimpleNodeData node = new SimpleNodeData(h, this.plan.m, this.versionTimestamps);
            node.max = this.plan.numInNode[h][0];
            this.stack[h] = node;
        }
        this.leaf = new SimpleLeafData(this.plan.height, this.plan.m, metadata);
        this.leaf.max = entryCount == 0L ? 0 : this.plan.numInNode[this.plan.height][0];
        this.stack[this.plan.height] = this.leaf;
        if (metadata.getBloomFilterFactory() != null && this.plan.nentries > 0L && this.plan.nentries < Integer.MAX_VALUE) {
            double p = metadata.getBloomFilterFactory().p;
            this.bloomFilter = new BloomFilter((int)this.plan.nentries, p);
        } else {
            this.bloomFilter = null;
        }
        this.nodeSer = new NodeSerializer(this.addressManager, NOPNodeFactory.INSTANCE, this.plan.m, 0, metadata, false, metadata.getIndexSegmentRecordCompressorFactory());
        this.overflowHandler = metadata.getOverflowHandler();
        this.outFile = outFile;
        this.elapsed_setup = System.currentTimeMillis() - begin_setup;
        if (log.isInfoEnabled()) {
            log.info((Object)("name=" + this.name + ", nentries=" + entryCount + ", compactingMerge=" + compactingMerge));
        }
    }

    @Override
    public IndexSegmentCheckpoint call() throws Exception {
        this.begin_build = System.currentTimeMillis();
        if (this.outFile.exists() && this.outFile.length() != 0L) {
            throw new IllegalArgumentException("File exists and is not empty: " + this.outFile.getAbsoluteFile());
        }
        try {
            this.out = new RandomAccessFile(this.outFile, "rw");
            FileChannel outChannel = this.out.getChannel();
            WriteCache.FileChannelWriteCache fileChannelWriteCache = this.leafWriteCache = this.plan.nleaves == 0L ? null : new WriteCache.FileChannelWriteCache(421L, null, false, false, false, new NOPReopener(this.out), 0L);
            if (this.plan.nnodes == 0L) {
                this.nodeBuffer = null;
                this.nodeList = null;
            } else if (this.bufferNodes) {
                this.nodeBuffer = null;
                this.nodeList = new LinkedList<NodeMetadata>();
            } else {
                this.nodeBuffer = new TemporaryRawStore(38);
                this.nodeList = null;
            }
            this.blobBuffer = this.rawRecords || this.overflowHandler != null ? new TemporaryRawStore(38) : null;
            this.buildBTree();
            assert (this.plan.nleaves == (long)this.nleavesWritten);
            assert (this.plan.nnodes == (long)this.nnodesWritten);
            this.elapsed_build = System.currentTimeMillis() - this.begin_build;
            long begin_write = System.currentTimeMillis();
            this.checkpoint = this.writeIndexSegment(outChannel, this.commitTime);
            outChannel.force(true);
            this.out.close();
            this.elapsed_write = System.currentTimeMillis() - begin_write;
            this.elapsed = System.currentTimeMillis() - this.begin_build + this.elapsed_setup;
            float f = this.mbPerSec = this.elapsed == 0L ? 0.0f : (float)(this.checkpoint.length / 0x100000L) / ((float)this.elapsed / 1000.0f);
            if (log.isInfoEnabled()) {
                NumberFormat cf = NumberFormat.getNumberInstance();
                cf.setGroupingUsed(true);
                NumberFormat fpf = NumberFormat.getNumberInstance();
                fpf.setGroupingUsed(false);
                fpf.setMaximumFractionDigits(2);
                log.info((Object)("finished: total(ms)=" + this.elapsed + "= setup(" + this.elapsed_setup + ")" + "+ build(" + this.elapsed_build + ")" + "+ write(" + this.elapsed_write + ")" + "; branchingFactor=" + this.plan.m + ", nentries=(" + this.ntuplesWritten + " actual, " + this.plan.nentries + " plan)" + ", nnodes=(" + this.nnodesWritten + " actual, " + this.plan.nnodes + " plan)" + ", nleaves=(" + this.nleavesWritten + " actual, " + this.plan.nleaves + " plan)" + ", length=" + fpf.format((double)this.checkpoint.length / 1048576.0) + "MB" + ", rate=" + fpf.format(this.mbPerSec) + "MB/sec"));
            }
            IndexSegmentCheckpoint indexSegmentCheckpoint = this.checkpoint;
            return indexSegmentCheckpoint;
        }
        catch (Exception ex) {
            this.deleteOutputFile();
            throw ex;
        }
        catch (Throwable ex) {
            this.deleteOutputFile();
            throw new RuntimeException(ex);
        }
        finally {
            if (this.leafWriteCache != null) {
                try {
                    this.leafWriteCache.close();
                }
                catch (Throwable t) {
                    log.warn((Object)t, t);
                }
            }
            if (this.nodeBuffer != null && this.nodeBuffer.isOpen()) {
                try {
                    this.nodeBuffer.close();
                }
                catch (Throwable t) {
                    log.warn((Object)t, t);
                }
            }
        }
    }

    protected void buildBTree() {
        if (this.plan.nentries == 0L) {
            this.leaf.reset(this.plan.numInNode[this.leaf.level][0]);
            this.flushNodeOrLeaf(this.leaf);
            return;
        }
        int i = 0;
        while ((long)i < this.plan.nleaves && this.entryIterator.hasNext()) {
            this.leaf.reset(this.plan.numInNode[this.leaf.level][i]);
            int limit = this.leaf.max;
            for (int j = 0; j < limit && this.entryIterator.hasNext(); ++j) {
                this.copyTuple(j, this.entryIterator.next());
                if (i <= 0 || j != 0) continue;
                this.addSeparatorKey(this.leaf);
            }
            this.flushNodeOrLeaf(this.leaf);
            ++i;
        }
    }

    private void copyTuple(int j, ITuple<?> tuple) {
        if (this.ntuplesWritten == 0L) {
            this.assertIteratorOk(tuple);
        }
        ++this.ntuplesWritten;
        MutableKeyBuffer keys = this.leaf.keys;
        assert (keys.nkeys == j);
        keys.keys[j] = tuple.getKey();
        if (this.deleteMarkers) {
            this.leaf.deleteMarkers[j] = tuple.isDeletedVersion();
        }
        if (this.versionTimestamps) {
            long t;
            this.leaf.versionTimestamps[j] = t = tuple.getVersionTimestamp();
            if (t < this.leaf.minimumVersionTimestamp) {
                this.leaf.minimumVersionTimestamp = t;
            }
            if (t > this.leaf.maximumVersionTimestamp) {
                this.leaf.maximumVersionTimestamp = t;
            }
        }
        byte[] val = this.deleteMarkers && tuple.isDeletedVersion() ? null : (this.overflowHandler != null ? this.overflowHandler.handle(tuple, this.blobBuffer) : tuple.getValue());
        if (this.rawRecords) {
            long maxRecLen = this.metadata.getMaxRecLen();
            if (val != null && (long)val.length > maxRecLen) {
                long addr1 = this.blobBuffer.write(ByteBuffer.wrap(val));
                int nbytes = this.blobBuffer.getByteCount(addr1);
                long offset = this.blobBuffer.getOffset(addr1);
                long addr = this.addressManager.toAddr(nbytes, IndexSegmentRegion.BLOB.encodeOffset(offset));
                this.leaf.vals.values[j] = AbstractBTree.encodeRecordAddr(this.recordAddrBuf, addr);
                this.leaf.rawRecords[j] = true;
            } else {
                this.leaf.vals.values[j] = val;
                this.leaf.rawRecords[j] = false;
            }
        } else {
            this.leaf.vals.values[j] = val;
        }
        if (this.bloomFilter != null) {
            this.bloomFilter.add(keys.keys[j]);
        }
        ++keys.nkeys;
        ++this.leaf.vals.nvalues;
    }

    private void assertIteratorOk(ITuple<?> tuple) {
        if (!tuple.getKeysRequested()) {
            throw new RuntimeException("keys not reported by itr.");
        }
        if (!tuple.getValuesRequested()) {
            throw new RuntimeException("vals not reported by itr.");
        }
        if (!this.compactingMerge && this.deleteMarkers && (tuple.flags() & 4) == 0) {
            throw new RuntimeException("delete markers not reported by itr.");
        }
        assert (!this.isolatable || this.isolatable && (tuple.flags() & 4) == 0) : "version metadata not reported by itr for isolatable index";
    }

    private void deleteOutputFile() {
        if (this.out != null && this.out.getChannel().isOpen()) {
            try {
                this.out.close();
            }
            catch (Throwable t) {
                log.error((Object)("Ignoring: " + t), t);
            }
        }
        if (!this.outFile.delete()) {
            log.warn((Object)("Could not delete: file=" + this.outFile.getAbsolutePath()));
        }
        if (this.storeCache != null) {
            this.storeCache.clear();
        }
    }

    protected void flushNodeOrLeaf(AbstractSimpleNodeData node) {
        int h = node.level;
        int col = this.writtenInLevel[h];
        assert ((long)col < this.plan.numInLevel[h]);
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing " + (node.isLeaf() ? "leaf" : "node") + "; h=" + h + ", col=" + col + ", max=" + node.max + ", nkeys=" + node.keys.size()));
        }
        long addr = this.writeNodeOrLeaf(node);
        SimpleNodeData parent = this.getParent(node);
        if (parent != null) {
            this.addChild(parent, addr, node);
        }
        int n = h;
        this.writtenInLevel[n] = this.writtenInLevel[n] + 1;
    }

    protected void addChild(SimpleNodeData parent, long childAddr, AbstractSimpleNodeData child) {
        long nentries;
        long l = nentries = child.isLeaf() ? (long)child.getKeyCount() : ((INodeData)((Object)child)).getSpannedTupleCount();
        if (parent.nchildren == parent.max) {
            this.resetNode(parent);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setting " + (child.isLeaf() ? "leaf" : "node") + " as child(" + parent.nchildren + ")" + " at h=" + parent.level + ", col=" + this.writtenInLevel[parent.level] + ", addr=" + this.addressManager.toString(childAddr)));
        }
        int nchildren = parent.nchildren;
        parent.childAddr[nchildren] = childAddr;
        parent.childEntryCount[nchildren] = nentries;
        parent.nentries += nentries;
        if (this.versionTimestamps) {
            parent.minimumVersionTimestamp = Math.min(parent.minimumVersionTimestamp, child.minimumVersionTimestamp);
            parent.maximumVersionTimestamp = Math.max(parent.maximumVersionTimestamp, child.maximumVersionTimestamp);
        }
        ++parent.nchildren;
        if (parent.nchildren == parent.max) {
            this.flushNodeOrLeaf(parent);
        }
    }

    protected void resetNode(SimpleNodeData parent) {
        int h = parent.level;
        int col = this.writtenInLevel[h] - 1;
        if ((long)(col + 1) >= this.plan.numInLevel[h]) {
            throw new AssertionError();
        }
        parent.reset(this.plan.numInNode[h][col + 1]);
    }

    protected void addSeparatorKey(SimpleLeafData leaf) {
        SimpleNodeData parent = this.getParent(leaf);
        if (parent == null) {
            return;
        }
        byte[] separatorKey = leaf.keys.get(0);
        if (separatorKey == null) {
            throw new AssertionError();
        }
        this.addSeparatorKey(parent, separatorKey);
    }

    private void addSeparatorKey(SimpleNodeData parent, byte[] separatorKey) {
        if (parent == null) {
            throw new AssertionError();
        }
        if (separatorKey == null) {
            throw new AssertionError();
        }
        int maxKeys = parent.max - 1;
        MutableKeyBuffer parentKeys = parent.keys;
        if (parentKeys.nkeys < maxKeys) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("h=" + parent.level + ", col=" + this.writtenInLevel[parent.level] + ", separatorKey=" + BytesUtil.toString(separatorKey)));
            }
            parentKeys.keys[parentKeys.nkeys++] = separatorKey;
        } else {
            this.addSeparatorKey(this.getParent(parent), separatorKey);
        }
    }

    protected SimpleNodeData getParent(AbstractSimpleNodeData node) {
        if (node.level == 0) {
            return null;
        }
        return (SimpleNodeData)this.stack[node.level - 1];
    }

    protected long writeNodeOrLeaf(AbstractSimpleNodeData node) {
        return node.isLeaf() ? this.writeLeaf((SimpleLeafData)node) : this.writeNode((SimpleNodeData)node);
    }

    protected long writeLeaf(SimpleLeafData leaf) {
        ILeafData thisLeafData = this.nodeSer.encodeLive(leaf);
        long addr1 = this.allocateLeafAddr(thisLeafData.data().len());
        long addr = this.encodeLeafAddr(addr1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("allocated storage for leaf data record: addr=" + this.addressManager.toString(addr)));
        }
        if (this.nleavesWritten > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("updating previous leaf: addr=" + this.addressManager.toString(this.encodeLeafAddr(this.bufLastLeafAddr)) + ", priorAddr=" + this.addressManager.toString(this.addrPriorLeaf) + ", nextAddr=" + this.addressManager.toString(addr)));
            } else if (log.isInfoEnabled()) {
                System.err.print(".");
                if (this.nleavesWritten % 80 == 0) {
                    System.err.print("\n");
                }
            }
            ByteBuffer bufLastLeaf = this.lastLeafData.data().asByteBuffer();
            this.nodeSer.updateLeaf(bufLastLeaf, this.addrPriorLeaf, addr);
            assert (this.lastLeafData.getPriorAddr() == this.addrPriorLeaf);
            assert (this.lastLeafData.getNextAddr() == addr);
            this.writeLeafForReal(this.bufLastLeafAddr, bufLastLeaf);
            this.addrPriorLeaf = this.encodeLeafAddr(this.bufLastLeafAddr);
            if (this.storeCache != null) {
                this.storeCache.putIfAbsent(this.addrPriorLeaf, this.lastLeafData);
            }
        }
        this.lastLeafData = thisLeafData;
        this.bufLastLeafAddr = addr1;
        if (this.nleavesWritten == 0) {
            this.addrFirstLeaf = addr;
        }
        this.addrLastLeaf = addr;
        ++this.nleavesWritten;
        if (this.plan.nleaves == (long)this.nleavesWritten) {
            assert (this.plan.nentries == 0L || this.lastLeafData.getKeyCount() > 0) : "Last leaf is empty?";
            if (log.isDebugEnabled()) {
                log.debug((Object)("updating last leaf: addr=" + this.addressManager.toString(this.encodeLeafAddr(this.bufLastLeafAddr)) + ", priorAddr=" + this.addressManager.toString(this.addrPriorLeaf) + ", nextAddr=0L"));
            } else if (log.isInfoEnabled()) {
                System.err.print(".");
            }
            ByteBuffer bufLastLeaf = this.lastLeafData.data().asByteBuffer();
            this.nodeSer.updateLeaf(bufLastLeaf, this.addrPriorLeaf, 0L);
            assert (this.lastLeafData.getPriorAddr() == this.addrPriorLeaf);
            assert (this.lastLeafData.getNextAddr() == 0L);
            this.writeLeafForReal(this.bufLastLeafAddr, bufLastLeaf);
            if (this.storeCache != null) {
                this.storeCache.putIfAbsent(this.addrLastLeaf, this.lastLeafData);
            }
        }
        return addr;
    }

    private long allocateLeafAddr(int nbytes) {
        long offset = this.leafAddrFactory.get();
        this.leafAddrFactory.addAndGet(nbytes);
        long addr1 = this.addressManager.toAddr(nbytes, offset);
        return addr1;
    }

    private void writeLeafForReal(long addr, ByteBuffer data) {
        long offset = this.addressManager.getOffset(addr);
        try {
            int chk = 0;
            if (!this.leafWriteCache.write(offset, data, chk)) {
                this.leafWriteCache.flush(false);
                this.leafWriteCache.reset();
                if (!this.leafWriteCache.write(offset, data, chk)) {
                    FileChannelUtility.writeAll(this.leafWriteCache.opener, data, offset);
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private long allocateNodeAddr(int nbytes) {
        if (!this.bufferNodes) {
            throw new UnsupportedOperationException();
        }
        long offset = this.nodeAddrFactory.get();
        this.nodeAddrFactory.addAndGet(nbytes);
        long addr1 = this.addressManager.toAddr(nbytes, offset);
        return addr1;
    }

    private long encodeLeafAddr(long addr1) {
        int nbytes = this.addressManager.getByteCount(addr1);
        if (nbytes > this.maxNodeOrLeafLength) {
            this.maxNodeOrLeafLength = nbytes;
        }
        long offset = this.addressManager.getOffset(addr1) + 421L;
        long addr = this.addressManager.toAddr(nbytes, IndexSegmentRegion.BASE.encodeOffset(offset));
        return addr;
    }

    protected long writeNode(SimpleNodeData node) {
        long addr;
        long tempAddr;
        INodeData codedNodeData = this.nodeSer.encodeLive(node);
        if (this.nodeBuffer != null) {
            tempAddr = this.nodeBuffer.write(codedNodeData.data().asByteBuffer());
        } else {
            tempAddr = this.allocateNodeAddr(codedNodeData.data().len());
            this.nodeList.add(new NodeMetadata(tempAddr, codedNodeData));
        }
        long offset = this.addressManager.getOffset(tempAddr);
        int nbytes = this.addressManager.getByteCount(tempAddr);
        if (nbytes > this.maxNodeOrLeafLength) {
            this.maxNodeOrLeafLength = nbytes;
        }
        ++this.nnodesWritten;
        if (log.isInfoEnabled()) {
            System.err.print("x");
        }
        node.addr = addr = this.addressManager.toAddr(nbytes, IndexSegmentRegion.NODE.encodeOffset(offset));
        if (this.storeCache != null) {
            this.storeCache.putIfAbsent(addr, codedNodeData);
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexSegmentCheckpoint writeIndexSegment(FileChannel outChannel, long commitTime) throws IOException, InterruptedException {
        long addrBloom;
        long offsetBlobs;
        long extentBlobs;
        long addrRoot;
        long extentNodes;
        long offsetNodes;
        long extentLeaves;
        long offsetLeaves;
        outChannel.write(ByteBuffer.allocate(421));
        if (this.plan.nleaves == 0L) {
            offsetLeaves = 0L;
            extentLeaves = 0L;
            offsetNodes = 0L;
            extentNodes = 0L;
            addrRoot = 0L;
        } else {
            offsetLeaves = 421L;
            extentLeaves = this.leafAddrFactory.get();
            offsetNodes = this.plan.nnodes != 0L ? 421L + extentLeaves : 0L;
            try {
                this.leafWriteCache.flush(false);
                this.leafWriteCache.close();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (this.nodeBuffer != null) {
                outChannel.position(offsetNodes);
                assert (outChannel.position() == offsetNodes) : "position=" + outChannel.position() + ", but offsetNodes=" + offsetNodes;
                extentNodes = this.nodeBuffer.getBufferStrategy().transferTo(this.out);
                this.nodeBuffer.close();
                addrRoot = ((SimpleNodeData)this.stack[0]).addr;
            } else if (this.nodeList != null) {
                try (WriteCache.FileChannelWriteCache writeCache = new WriteCache.FileChannelWriteCache(offsetNodes, null, false, false, false, new NOPReopener(this.out), 0L);){
                    int nbytes = 0;
                    for (NodeMetadata md : this.nodeList) {
                        int chk;
                        long addr = md.addr;
                        long offset = this.addressManager.getOffset(addr);
                        AbstractFixedByteArrayBuffer slice = md.data.data();
                        nbytes += slice.len();
                        ByteBuffer data = slice.asByteBuffer();
                        if (writeCache.write(offset, data, chk = 0)) continue;
                        writeCache.flush(false);
                        writeCache.reset();
                        if (writeCache.write(offset, data, chk)) continue;
                        FileChannelUtility.writeAll(writeCache.opener, data, offset);
                    }
                    writeCache.flush(false);
                    writeCache.reset();
                    extentNodes = nbytes;
                }
                addrRoot = ((SimpleNodeData)this.stack[0]).addr;
            } else {
                extentNodes = 0L;
                addrRoot = this.addrLastLeaf;
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("addrRoot: " + addrRoot + ", " + this.addressManager.toString(addrRoot)));
        }
        if (this.blobBuffer == null || this.blobBuffer.getBufferStrategy().size() == 0L) {
            extentBlobs = 0L;
            offsetBlobs = 0L;
        } else {
            offsetBlobs = this.out.length();
            this.out.seek(offsetBlobs);
            extentBlobs = this.blobBuffer.getBufferStrategy().transferTo(this.out);
            this.blobBuffer.close();
        }
        if (this.bloomFilter == null) {
            addrBloom = 0L;
        } else {
            byte[] bloomBytes = SerializerUtil.serialize(this.bloomFilter);
            long offset = this.out.length();
            this.out.seek(offset);
            this.out.write(bloomBytes, 0, bloomBytes.length);
            addrBloom = this.addressManager.toAddr(bloomBytes.length, IndexSegmentRegion.BASE.encodeOffset(offset));
            if (this.storeCache != null) {
                this.storeCache.putIfAbsent(addrBloom, this.bloomFilter);
            }
        }
        byte[] metadataBytes = SerializerUtil.serialize(this.metadata);
        long offset = this.out.length();
        this.out.seek(offset);
        this.out.write(metadataBytes, 0, metadataBytes.length);
        long addrMetadata = this.addressManager.toAddr(metadataBytes.length, IndexSegmentRegion.BASE.encodeOffset(offset));
        if (this.storeCache != null) {
            this.storeCache.putIfAbsent(addrMetadata, this.metadata);
        }
        outChannel.position(0L);
        if (this.nnodesWritten > Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        if (this.nleavesWritten > Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        IndexSegmentCheckpoint md = new IndexSegmentCheckpoint(this.addressManager.getOffsetBits(), this.plan.height, this.nleavesWritten, this.nnodesWritten, this.ntuplesWritten, this.maxNodeOrLeafLength, offsetLeaves, extentLeaves, offsetNodes, extentNodes, offsetBlobs, extentBlobs, addrRoot, addrMetadata, addrBloom, this.addrFirstLeaf, this.addrLastLeaf, this.out.length(), this.compactingMerge, false, this.segmentUUID, commitTime);
        md.write(this.out);
        if (log.isInfoEnabled()) {
            log.info((Object)md.toString());
        }
        this.segmentMetadata = new SegmentMetadata(this.outFile, this.segmentUUID, commitTime);
        return md;
    }

    public IResourceMetadata getSegmentMetadata() {
        if (this.segmentMetadata == null) {
            throw new IllegalStateException();
        }
        return this.segmentMetadata;
    }

    protected static void usage(String[] args, String msg, int exitCode) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println("usage: [opts] journal [name]*");
        System.err.println("    journal is the name of the journal file.");
        System.err.println("    [name]* is the name of one or more indices (defaults to all).");
        System.err.println("    [opts] is any of:");
        System.err.println("       -m #\tThe branching factor for the output index segments.");
        System.err.println("       -alg (FullyBuffered|TwoPass)\tThe algorithm to use.");
        System.err.println("       -merge (true|false)\tWhen true, performs a compacting merge (default is merge).");
        System.err.println("       -O outDir\tThe output directory.");
        System.err.println("       -bufferNodes (true|false)\tWhen true, the nodes are fully buffered in memory (default true).");
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int i;
        Integer branchingFactorOverride = null;
        boolean verify = false;
        File journalFile = null;
        LinkedList<String> names = new LinkedList<String>();
        File outDir = new File(".");
        boolean compactingMerge = true;
        boolean bufferNodes = true;
        BuildEnum buildEnum = BuildEnum.TwoPass;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tmpDir.exists() && !tmpDir.mkdir()) {
            throw new IOException("Temporary directory does not exist / can not be created: " + tmpDir);
        }
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            String arg = args[i];
            if (arg.equals("-m")) {
                branchingFactorOverride = Integer.valueOf(args[++i]);
                continue;
            }
            if (arg.equals("-O")) {
                outDir = new File(args[++i]);
                continue;
            }
            if (arg.equals("-verify")) {
                verify = true;
                continue;
            }
            if (arg.equals("-merge")) {
                compactingMerge = true;
                continue;
            }
            if (arg.equals("-build")) {
                compactingMerge = false;
                continue;
            }
            if (arg.equals("-bufferNodes")) {
                bufferNodes = Boolean.valueOf(args[++i]);
                continue;
            }
            if (arg.equals("-alg")) {
                buildEnum = BuildEnum.valueOf(args[++i]);
                continue;
            }
            if (arg.equals("-help") || arg.equals("--?")) {
                IndexSegmentBuilder.usage(args, null, 1);
                continue;
            }
            throw new UnsupportedOperationException("Unknown option: " + arg);
        }
        if (i == args.length) {
            IndexSegmentBuilder.usage(args, "journal name is required.", 1);
        }
        if (!(journalFile = new File(args[i++])).exists()) {
            throw new FileNotFoundException(journalFile.toString());
        }
        while (i < args.length) {
            names.add(args[i++]);
        }
        if (journalFile == null) {
            throw new RuntimeException("The journal file was not specified.");
        }
        if (names == null) {
            throw new RuntimeException("The index name was not specified.");
        }
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new IOException("Output directory does not exist and could not be created: " + outDir);
        }
        Properties properties = new Properties();
        properties.setProperty(Journal.Options.FILE, journalFile.toString());
        properties.setProperty(Journal.Options.READ_ONLY, Boolean.TRUE.toString());
        try (Journal journal = new Journal(properties);){
            if (names.isEmpty()) {
                ITupleIterator itr = journal.getName2Addr().rangeIterator();
                while (itr.hasNext()) {
                    names.add(((Name2Addr.Entry)itr.next().getObject()).name);
                }
            } else {
                for (String name : names) {
                    if (journal.getIndex(name) == null) {
                        throw new RuntimeException("Index not found: " + name);
                    }
                    File outFile = new File(outDir, name + ".seg");
                    if (!outFile.exists() || outFile.length() == 0L) continue;
                    throw new RuntimeException("Output file exists and is non-empty: " + outFile);
                }
            }
            System.out.println("Will process " + names.size() + " indices.");
            long beginAll = System.currentTimeMillis();
            for (String name : names) {
                IndexSegmentBuilder builder;
                BTree btree = journal.getIndex(name);
                File outFile = new File(outDir, name + ".seg");
                int m = branchingFactorOverride == null ? btree.getIndexMetadata().getIndexSegmentBranchingFactor() : branchingFactorOverride.intValue();
                long begin = System.currentTimeMillis();
                long commitTime = btree.getLastCommitTime();
                System.out.println("Building index segment: in(m=" + btree.getBranchingFactor() + ", rangeCount=" + btree.rangeCount() + "), out(m=" + m + "), alg=" + (Object)((Object)buildEnum));
                switch (buildEnum) {
                    case TwoPass: {
                        builder = IndexSegmentBuilder.newInstanceTwoPass(btree, outFile, tmpDir, m, compactingMerge, commitTime, null, null, bufferNodes);
                        break;
                    }
                    case FullyBuffered: {
                        builder = IndexSegmentBuilder.newInstanceFullyBuffered(btree, outFile, tmpDir, m, compactingMerge, commitTime, null, null, bufferNodes);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)buildEnum.toString());
                    }
                }
                IndexSegmentCheckpoint checkpoint = builder.call();
                long elapsed = System.currentTimeMillis() - begin;
                String results = "name=" + name + " : elapsed=" + elapsed + "ms, setup=" + builder.elapsed_setup + "ms, write=" + builder.elapsed_write + "ms, m=" + builder.plan.m + ", size=" + builder.outFile.length() / 0x100000L + "mb, mb/sec=" + builder.mbPerSec;
                System.out.println(results);
                if (!verify) continue;
                if (LRUNexus.INSTANCE != null) {
                    System.out.println("Flushing index segment cache: " + builder.outFile);
                    LRUNexus.INSTANCE.deleteCache(checkpoint.segmentUUID);
                }
                try (IndexSegmentStore segStore = new IndexSegmentStore(outFile);
                     IndexSegment seg = segStore.loadIndexSegment();){
                    System.out.println("Verifying index segment: " + builder.outFile);
                    IndexSegmentBuilder.assertSameEntryIterator(name, btree.rangeIterator(), seg.rangeIterator());
                }
            }
            long elapsedAll = System.currentTimeMillis() - beginAll;
            System.out.println("Processed " + names.size() + " indices in " + elapsedAll + "ms");
        }
    }

    private static void assertSameEntryIterator(String name, ITupleIterator<?> expectedItr, ITupleIterator<?> actualItr) {
        long nvisited = 0L;
        while (expectedItr.hasNext()) {
            if (!actualItr.hasNext()) {
                throw new RuntimeException(name + ":: Expecting another index entry: nvisited=" + nvisited);
            }
            ITuple<?> expectedTuple = expectedItr.next();
            ITuple<?> actualTuple = actualItr.next();
            ++nvisited;
            if (!BytesUtil.bytesEqual(expectedTuple.getKey(), actualTuple.getKey())) {
                throw new RuntimeException(name + ":: Wrong key: nvisited=" + nvisited + ", expected=" + expectedTuple + ", actual=" + actualTuple);
            }
            if (BytesUtil.bytesEqual(expectedTuple.getValue(), actualTuple.getValue())) continue;
            throw new RuntimeException(name + ":: Wrong value: nvisited=" + nvisited + ", expected=" + expectedTuple + ", actual=" + actualTuple);
        }
        if (actualItr.hasNext()) {
            throw new RuntimeException(name + ":: Not expecting more tuples");
        }
    }

    static enum BuildEnum {
        TwoPass,
        FullyBuffered;

    }

    private static class MyTupleIterator<E>
    implements ITupleIterator<E> {
        private final boolean hasVersionTimestamp;
        private final boolean hasDeleteMarkers;
        private final boolean visitDeleted;
        private final MutableLeafData leaf;
        private final MyTuple tuple;
        private int i;
        private final int fromIndex;
        private final int toIndex;

        public MyTupleIterator(MutableLeafData leaf, int flags) {
            this.leaf = leaf;
            this.tuple = new MyTuple(flags);
            this.hasVersionTimestamp = leaf.hasVersionTimestamps();
            this.hasDeleteMarkers = leaf.hasDeleteMarkers();
            this.visitDeleted = (flags & 4) != 0;
            this.fromIndex = 0;
            this.toIndex = leaf.getKeyCount();
        }

        @Override
        public boolean hasNext() {
            while (this.i >= this.fromIndex && this.i < this.toIndex) {
                if (!this.hasDeleteMarkers || this.visitDeleted || !this.leaf.getDeleteMarker(this.i)) {
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        @Override
        public ITuple<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.tuple.leafIndex = this.i++;
            return this.tuple;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class MyTuple
        implements ITuple<E> {
            private int leafIndex;
            private final int flags;
            private final boolean needsKeys;
            private final boolean needsVals;

            public MyTuple(int flags) {
                this.flags = flags;
                this.needsKeys = (flags & 1) != 0;
                boolean bl = this.needsVals = (flags & 2) != 0;
                if (!this.needsKeys) {
                    throw new UnsupportedOperationException();
                }
                if (!this.needsVals) {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public int flags() {
                return this.flags;
            }

            @Override
            public boolean getKeysRequested() {
                return this.needsKeys;
            }

            @Override
            public boolean getValuesRequested() {
                return this.needsVals;
            }

            @Override
            public long getVisitCount() {
                return this.leafIndex;
            }

            @Override
            public byte[] getKey() {
                return ((MyTupleIterator)MyTupleIterator.this).leaf.keys.keys[this.leafIndex];
            }

            @Override
            public byte[] getValue() {
                return ((MyTupleIterator)MyTupleIterator.this).leaf.vals.values[this.leafIndex];
            }

            @Override
            public boolean isDeletedVersion() {
                if (!MyTupleIterator.this.hasDeleteMarkers) {
                    return false;
                }
                return ((MyTupleIterator)MyTupleIterator.this).leaf.deleteMarkers[this.leafIndex];
            }

            @Override
            public boolean isNull() {
                return ((MyTupleIterator)MyTupleIterator.this).leaf.vals.values[this.leafIndex] == null;
            }

            @Override
            public long getVersionTimestamp() {
                if (!MyTupleIterator.this.hasVersionTimestamp) {
                    return 0L;
                }
                return ((MyTupleIterator)MyTupleIterator.this).leaf.versionTimestamps[this.leafIndex];
            }

            @Override
            public ByteArrayBuffer getKeyBuffer() {
                throw new UnsupportedOperationException();
            }

            @Override
            public DataInputBuffer getKeyStream() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ByteArrayBuffer getValueBuffer() {
                throw new UnsupportedOperationException();
            }

            @Override
            public DataInputBuffer getValueStream() {
                throw new UnsupportedOperationException();
            }

            @Override
            public E getObject() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getSourceIndex() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ITupleSerializer getTupleSerializer() {
                throw new UnsupportedOperationException();
            }

            @Override
            public IBlock readBlock(long addr) {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static class NOPNodeFactory
    implements INodeFactory {
        public static final INodeFactory INSTANCE = new NOPNodeFactory();

        private NOPNodeFactory() {
        }

        @Override
        public Leaf allocLeaf(AbstractBTree btree, long addr, ILeafData data) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node allocNode(AbstractBTree btree, long addr, INodeData data) {
            throw new UnsupportedOperationException();
        }
    }

    protected static class SimpleNodeData
    extends AbstractSimpleNodeData
    implements INodeData {
        long addr = 0L;
        final long[] childAddr;
        int nchildren = 0;
        long nentries;
        final long[] childEntryCount;
        final boolean hasVersionTimestamps;

        @Override
        public final long getSpannedTupleCount() {
            return this.nentries;
        }

        @Override
        public final long getChildAddr(int index) {
            if (index < 0 || index > this.keys.size() + 1) {
                throw new IllegalArgumentException();
            }
            return this.childAddr[index];
        }

        @Override
        public final long getChildEntryCount(int index) {
            if (index < 0 || index > this.keys.size() + 1) {
                throw new IllegalArgumentException();
            }
            return this.childEntryCount[index];
        }

        public SimpleNodeData(int level, int m, boolean hasVersionTimestamps) {
            super(level, m);
            this.childAddr = new long[m];
            this.childEntryCount = new long[m];
            this.hasVersionTimestamps = hasVersionTimestamps;
        }

        @Override
        protected void reset(int max) {
            super.reset(max);
            this.addr = 0L;
            this.nchildren = 0;
            this.nentries = 0L;
        }

        @Override
        public final int getChildCount() {
            return this.keys.size() + 1;
        }

        @Override
        public final boolean isLeaf() {
            return false;
        }

        @Override
        public final boolean hasVersionTimestamps() {
            return this.hasVersionTimestamps;
        }
    }

    protected static class SimpleLeafData
    extends AbstractSimpleNodeData
    implements ILeafData {
        final MutableValueBuffer vals;
        final boolean[] deleteMarkers;
        final long[] versionTimestamps;
        final boolean[] rawRecords;

        @Override
        public final IRaba getValues() {
            return this.vals;
        }

        public SimpleLeafData(int level, int m, IndexMetadata metadata) {
            super(level, m);
            this.vals = new MutableValueBuffer(m);
            this.deleteMarkers = metadata.getDeleteMarkers() ? new boolean[m] : null;
            this.versionTimestamps = metadata.getVersionTimestamps() ? new long[m] : null;
            this.rawRecords = metadata.getRawRecords() ? new boolean[m] : null;
        }

        @Override
        protected void reset(int max) {
            super.reset(max);
            this.vals.nvalues = 0;
        }

        @Override
        public final int getValueCount() {
            return this.keys.size();
        }

        @Override
        public final boolean isLeaf() {
            return true;
        }

        @Override
        public final boolean getDeleteMarker(int index) {
            if (this.deleteMarkers == null) {
                throw new UnsupportedOperationException();
            }
            return this.deleteMarkers[index];
        }

        @Override
        public final long getVersionTimestamp(int index) {
            if (this.versionTimestamps == null) {
                throw new UnsupportedOperationException();
            }
            return this.versionTimestamps[index];
        }

        @Override
        public final long getRawRecord(int index) {
            if (this.rawRecords == null) {
                throw new UnsupportedOperationException();
            }
            if (!this.rawRecords[index]) {
                return 0L;
            }
            return AbstractBTree.decodeRecordAddr(this.vals.get(index));
        }

        @Override
        public final boolean hasDeleteMarkers() {
            return this.deleteMarkers != null;
        }

        @Override
        public final boolean hasVersionTimestamps() {
            return this.versionTimestamps != null;
        }

        @Override
        public final boolean hasRawRecords() {
            return this.rawRecords != null;
        }

        @Override
        public final boolean isDoubleLinked() {
            return true;
        }

        @Override
        public final long getNextAddr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final long getPriorAddr() {
            throw new UnsupportedOperationException();
        }
    }

    protected static abstract class AbstractSimpleNodeData
    implements IAbstractNodeData {
        final int level;
        final int m;
        final MutableKeyBuffer keys;
        long minimumVersionTimestamp;
        long maximumVersionTimestamp;
        int max = -1;

        protected AbstractSimpleNodeData(int level, int m) {
            this.level = level;
            this.m = m;
            this.keys = new MutableKeyBuffer(m);
            this.minimumVersionTimestamp = Long.MAX_VALUE;
            this.maximumVersionTimestamp = Long.MIN_VALUE;
        }

        protected void reset(int max) {
            this.max = max;
            this.keys.nkeys = 0;
            this.minimumVersionTimestamp = Long.MAX_VALUE;
            this.maximumVersionTimestamp = Long.MIN_VALUE;
        }

        public final int getKeyCount() {
            return this.keys.size();
        }

        public final IRaba getKeys() {
            return this.keys;
        }

        @Override
        public final boolean isReadOnly() {
            return true;
        }

        @Override
        public final boolean isCoded() {
            return false;
        }

        @Override
        public final AbstractFixedByteArrayBuffer data() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final long getMaximumVersionTimestamp() {
            if (!this.hasVersionTimestamps()) {
                throw new UnsupportedOperationException();
            }
            return this.minimumVersionTimestamp;
        }

        @Override
        public final long getMinimumVersionTimestamp() {
            if (!this.hasVersionTimestamps()) {
                throw new UnsupportedOperationException();
            }
            return this.maximumVersionTimestamp;
        }
    }

    private static class NodeMetadata {
        public final long addr;
        public final INodeData data;

        public NodeMetadata(long addr, INodeData data) {
            this.addr = addr;
            this.data = data;
        }
    }
}

