/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.data;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.data.AbstractReadOnlyNodeData;
import com.bigdata.btree.data.IAbstractNodeDataCoder;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.ICodedRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.io.OutputBitStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DefaultLeafCoder
implements IAbstractNodeDataCoder<ILeafData>,
Externalizable {
    private static final long serialVersionUID = -2225107318522852096L;
    private static final transient byte VERSION0 = 0;
    private IRabaCoder keysCoder;
    private IRabaCoder valsCoder;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new IOException();
            }
        }
        this.keysCoder = (IRabaCoder)in.readObject();
        this.valsCoder = (IRabaCoder)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(0);
        out.writeObject(this.keysCoder);
        out.writeObject(this.valsCoder);
    }

    @Override
    public final boolean isLeafDataCoder() {
        return true;
    }

    @Override
    public boolean isNodeDataCoder() {
        return false;
    }

    public String toString() {
        return super.toString() + "{keysCoder=" + this.keysCoder + ", valsCoder=" + this.valsCoder + "}";
    }

    public DefaultLeafCoder() {
    }

    public DefaultLeafCoder(IRabaCoder keysCoder, IRabaCoder valsCoder) {
        if (keysCoder == null) {
            throw new IllegalArgumentException();
        }
        if (valsCoder == null) {
            throw new IllegalArgumentException();
        }
        this.keysCoder = keysCoder;
        this.valsCoder = valsCoder;
    }

    @Override
    public ILeafData decode(AbstractFixedByteArrayBuffer data) {
        return new ReadOnlyLeafData(data, this.keysCoder, this.valsCoder);
    }

    @Override
    public ILeafData encodeLive(ILeafData leaf, DataOutputBuffer buf) {
        byte bits;
        int i;
        if (leaf == null) {
            throw new IllegalArgumentException();
        }
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        int nkeys = leaf.getKeyCount();
        int O_origin = buf.pos();
        boolean doubleLinked = leaf.isDoubleLinked();
        buf.putByte(doubleLinked ? (byte)2 : 1);
        if (doubleLinked) {
            buf.skip(16);
        }
        buf.putShort((short)1);
        short flags = 0;
        boolean hasDeleteMarkers = leaf.hasDeleteMarkers();
        boolean hasVersionTimestamps = leaf.hasVersionTimestamps();
        boolean hasRawRecords = leaf.hasRawRecords();
        if (hasDeleteMarkers) {
            flags = (short)(flags | 1);
        }
        if (hasVersionTimestamps) {
            flags = (short)(flags | 2);
        }
        if (hasRawRecords) {
            flags = (short)(flags | 8);
        }
        buf.putShort(flags);
        buf.putInt(nkeys);
        int O_keysSize = buf.pos();
        buf.skip(8);
        ICodedRaba encodedKeys = this.keysCoder.encodeLive(leaf.getKeys(), buf);
        ICodedRaba encodedValues = this.valsCoder.encodeLive(leaf.getValues(), buf);
        buf.putInt(O_keysSize, encodedKeys.data().len());
        buf.putInt(O_keysSize + 4, encodedValues.data().len());
        if (hasDeleteMarkers) {
            i = 0;
            while (i < nkeys) {
                bits = 0;
                for (int j = 0; j < 8 && i < nkeys; ++j, ++i) {
                    if (!leaf.getDeleteMarker(i)) continue;
                    bits = (byte)(bits | 1 << 7 - j);
                }
                buf.putByte(bits);
            }
        }
        if (hasVersionTimestamps) {
            long min = leaf.getMinimumVersionTimestamp();
            long max = leaf.getMaximumVersionTimestamp();
            byte versionTimestampBits = (byte)(Fast.mostSignificantBit((long)(max - min)) + 1);
            buf.putByte(versionTimestampBits);
            buf.putLong(min);
            buf.putLong(max);
            if (versionTimestampBits > 0) {
                int byteLength = BytesUtil.bitFlagByteLength(nkeys * versionTimestampBits);
                byte[] a = new byte[byteLength];
                OutputBitStream obs = new OutputBitStream(a);
                try {
                    for (int i2 = 0; i2 < nkeys; ++i2) {
                        long deltat = leaf.getVersionTimestamp(i2) - min;
                        assert (deltat >= 0L);
                        obs.writeLong(deltat, (int)versionTimestampBits);
                    }
                    obs.flush();
                    buf.put(a);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (hasRawRecords) {
            i = 0;
            while (i < nkeys) {
                bits = 0;
                for (int j = 0; j < 8 && i < nkeys; ++j, ++i) {
                    if (leaf.getRawRecord(i) == 0L) continue;
                    bits = (byte)(bits | 1 << 7 - j);
                }
                buf.putByte(bits);
            }
        }
        AbstractFixedByteArrayBuffer slice = buf.slice(O_origin, buf.pos() - O_origin);
        return new ReadOnlyLeafData(slice, encodedKeys, encodedValues);
    }

    @Override
    public AbstractFixedByteArrayBuffer encode(ILeafData leaf, DataOutputBuffer buf) {
        return this.encodeLive(leaf, buf).data();
    }

    public static StringBuilder toString(ILeafData leaf, StringBuilder sb) {
        int i;
        int nkeys = leaf.getKeyCount();
        if (leaf.isDoubleLinked()) {
            sb.append(", priorAddr=" + leaf.getPriorAddr());
            sb.append(", nextAddr=" + leaf.getNextAddr());
        }
        sb.append(",\nkeys=" + leaf.getKeys());
        sb.append(",\nvals=" + leaf.getValues());
        if (leaf.hasDeleteMarkers()) {
            sb.append(",\ndeleteMarkers=[");
            for (i = 0; i < nkeys; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(leaf.getDeleteMarker(i));
            }
            sb.append("]");
        }
        if (leaf.hasVersionTimestamps()) {
            sb.append(",\nversionTimestamps={min=" + leaf.getMinimumVersionTimestamp() + ",max=" + leaf.getMaximumVersionTimestamp() + ",tuples=[");
            for (i = 0; i < nkeys; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(leaf.getVersionTimestamp(i));
            }
            sb.append("]");
        }
        if (leaf.hasRawRecords()) {
            sb.append(",\nrawRecords=[");
            for (i = 0; i < nkeys; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(leaf.getRawRecord(i));
            }
            sb.append("]");
        }
        return sb;
    }

    private static class ReadOnlyLeafData
    extends AbstractReadOnlyNodeData<ILeafData>
    implements ILeafData {
        private final AbstractFixedByteArrayBuffer b;
        private final int nkeys;
        private final short flags;
        private final IRaba keys;
        private final IRaba vals;
        private final int O_deleteMarkers;
        private final int O_versionTimestamps;
        private final byte versionTimestampBits;
        private final long minVersionTimestamp;
        private final int O_rawRecords;

        @Override
        public final AbstractFixedByteArrayBuffer data() {
            return this.b;
        }

        protected ReadOnlyLeafData(AbstractFixedByteArrayBuffer buf, ICodedRaba keys, ICodedRaba values) {
            boolean doubleLinked;
            if (buf == null) {
                throw new IllegalArgumentException();
            }
            if (keys == null) {
                throw new IllegalArgumentException();
            }
            if (values == null) {
                throw new IllegalArgumentException();
            }
            int pos = 0;
            byte type = buf.getByte(pos);
            ++pos;
            switch (type) {
                case 0: {
                    throw new AssertionError();
                }
                case 1: {
                    doubleLinked = false;
                    break;
                }
                case 2: {
                    doubleLinked = true;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("type=" + type));
                }
            }
            if (doubleLinked) {
                pos += 16;
            }
            short version = buf.getShort(pos);
            pos += 2;
            switch (version) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("version=" + version));
                }
            }
            this.flags = buf.getShort(pos);
            boolean hasVersionTimestamps = (this.flags & 2) != 0;
            boolean hasDeleteMarkers = (this.flags & 1) != 0;
            boolean hasRawRecords = (this.flags & 8) != 0;
            this.nkeys = buf.getInt(pos += 2);
            int keysSize = buf.getInt(pos += 4);
            int valuesSize = buf.getInt(pos += 4);
            pos += 4;
            this.keys = keys;
            pos += keysSize;
            this.vals = values;
            pos += valuesSize;
            if (hasDeleteMarkers) {
                this.O_deleteMarkers = pos;
                pos += BytesUtil.bitFlagByteLength(this.nkeys);
            } else {
                this.O_deleteMarkers = -1;
            }
            if (hasVersionTimestamps) {
                this.versionTimestampBits = buf.getByte(pos);
                this.O_versionTimestamps = ++pos;
                this.minVersionTimestamp = buf.getLong(pos);
                pos += 16 + BytesUtil.bitFlagByteLength(this.nkeys * this.versionTimestampBits);
            } else {
                this.O_versionTimestamps = -1;
                this.versionTimestampBits = 0;
                this.minVersionTimestamp = -1L;
            }
            if (hasRawRecords) {
                this.O_rawRecords = pos;
                pos += BytesUtil.bitFlagByteLength(this.nkeys);
            } else {
                this.O_rawRecords = -1;
            }
            this.b = buf;
        }

        protected ReadOnlyLeafData(AbstractFixedByteArrayBuffer buf, IRabaCoder keysCoder, IRabaCoder valuesCoder) {
            boolean doubleLinked;
            if (buf == null) {
                throw new IllegalArgumentException();
            }
            if (keysCoder == null) {
                throw new IllegalArgumentException();
            }
            if (valuesCoder == null) {
                throw new IllegalArgumentException();
            }
            int pos = 0;
            byte type = buf.getByte(pos);
            ++pos;
            switch (type) {
                case 0: {
                    throw new AssertionError();
                }
                case 1: {
                    doubleLinked = false;
                    break;
                }
                case 2: {
                    doubleLinked = true;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("type=" + type));
                }
            }
            if (doubleLinked) {
                pos += 16;
            }
            short version = buf.getShort(pos);
            pos += 2;
            switch (version) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("version=" + version));
                }
            }
            this.flags = buf.getShort(pos);
            boolean hasVersionTimestamps = (this.flags & 2) != 0;
            boolean hasDeleteMarkers = (this.flags & 1) != 0;
            boolean hasRawRecords = (this.flags & 8) != 0;
            this.nkeys = buf.getInt(pos += 2);
            int keysSize = buf.getInt(pos += 4);
            int valuesSize = buf.getInt(pos += 4);
            this.keys = keysCoder.decode(buf.slice(pos += 4, keysSize));
            pos += keysSize;
            if (this.nkeys != this.keys.size()) {
                throw new RuntimeException("nkeys=" + this.nkeys + ", keys.size=" + this.keys.size());
            }
            this.vals = valuesCoder.decode(buf.slice(pos, valuesSize));
            pos += valuesSize;
            if (this.nkeys != this.vals.size()) {
                throw new RuntimeException("nkeys=" + this.nkeys + ", vals.size=" + this.vals.size());
            }
            if (hasDeleteMarkers) {
                this.O_deleteMarkers = pos;
                pos += BytesUtil.bitFlagByteLength(this.nkeys);
            } else {
                this.O_deleteMarkers = -1;
            }
            if (hasVersionTimestamps) {
                this.versionTimestampBits = buf.getByte(pos);
                this.O_versionTimestamps = ++pos;
                this.minVersionTimestamp = buf.getLong(pos);
                pos += 16 + BytesUtil.bitFlagByteLength(this.nkeys * this.versionTimestampBits);
            } else {
                this.O_versionTimestamps = -1;
                this.versionTimestampBits = 0;
                this.minVersionTimestamp = -1L;
            }
            if (hasRawRecords) {
                this.O_rawRecords = pos;
                pos += BytesUtil.bitFlagByteLength(this.nkeys);
            } else {
                this.O_rawRecords = -1;
            }
            this.b = buf;
        }

        @Override
        public final boolean isLeaf() {
            return true;
        }

        @Override
        public final boolean isReadOnly() {
            return true;
        }

        @Override
        public final boolean isCoded() {
            return true;
        }

        @Override
        public final int getKeyCount() {
            return this.nkeys;
        }

        @Override
        public final int getValueCount() {
            return this.nkeys;
        }

        @Override
        public final boolean hasVersionTimestamps() {
            return (this.flags & 2) != 0;
        }

        @Override
        public final boolean hasDeleteMarkers() {
            return (this.flags & 1) != 0;
        }

        @Override
        public final boolean hasRawRecords() {
            return (this.flags & 8) != 0;
        }

        @Override
        public long getMinimumVersionTimestamp() {
            if (!this.hasVersionTimestamps()) {
                throw new UnsupportedOperationException();
            }
            return this.minVersionTimestamp;
        }

        @Override
        public long getMaximumVersionTimestamp() {
            if (!this.hasVersionTimestamps()) {
                throw new UnsupportedOperationException();
            }
            return this.b.getLong(this.O_versionTimestamps + 8);
        }

        @Override
        public final long getVersionTimestamp(int index) {
            if (!this.hasVersionTimestamps()) {
                throw new UnsupportedOperationException();
            }
            long bitpos = ((long)this.O_versionTimestamps + 16L << 3) + (long)index * (long)this.versionTimestampBits;
            long bitIndex = (long)(this.b.off() << 3) + bitpos;
            long deltat = BytesUtil.getBits64(this.b.array(), (int)bitIndex, this.versionTimestampBits);
            return this.minVersionTimestamp + deltat;
        }

        @Override
        public final boolean getDeleteMarker(int index) {
            if (!this.hasDeleteMarkers()) {
                throw new UnsupportedOperationException();
            }
            return this.b.getBit((this.O_deleteMarkers << 3) + index);
        }

        @Override
        public final long getRawRecord(int index) {
            if (!this.hasRawRecords()) {
                throw new UnsupportedOperationException();
            }
            boolean flag = this.b.getBit((this.O_rawRecords << 3) + index);
            if (!flag) {
                return 0L;
            }
            return AbstractBTree.decodeRecordAddr(this.vals.get(index));
        }

        @Override
        public final IRaba getKeys() {
            return this.keys;
        }

        @Override
        public final IRaba getValues() {
            return this.vals;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName() + "{");
            DefaultLeafCoder.toString(this, sb);
            sb.append("}");
            return sb.toString();
        }

        @Override
        public final boolean isDoubleLinked() {
            return this.b.getByte(0) == 2;
        }

        @Override
        public final long getPriorAddr() {
            if (!this.isDoubleLinked()) {
                throw new UnsupportedOperationException();
            }
            return this.b.getLong(1);
        }

        @Override
        public final long getNextAddr() {
            if (!this.isDoubleLinked()) {
                throw new UnsupportedOperationException();
            }
            return this.b.getLong(9);
        }
    }
}

