/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.filter;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleCursor;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.KeyOutOfRangeException;
import com.bigdata.btree.filter.ITupleFilter;
import com.bigdata.io.ByteArrayBuffer;
import cutthecrap.utils.striterators.FilterBase;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class Advancer<E>
extends FilterBase
implements ITupleFilter<E> {
    private static final long serialVersionUID = 1L;
    protected static final transient Logger log = Logger.getLogger(Advancer.class);
    protected ITupleCursor<E> src;

    protected Advancer() {
    }

    @Override
    public final ITupleIterator<E> filterOnce(Iterator src, Object context) {
        this.src = (ITupleCursor)src;
        return new Advancerator<E>(this.src, context, this);
    }

    protected boolean init() {
        return true;
    }

    protected abstract void advance(ITuple<E> var1);

    private static class Advancerator<E>
    implements ITupleIterator<E> {
        private final ITupleCursor<E> src;
        protected final Object context;
        private final Advancer<E> filter;
        private boolean firstTime = true;
        private boolean exhausted = false;
        private final ByteArrayBuffer kbuf = new ByteArrayBuffer();

        public Advancerator(ITupleCursor<E> src, Object context, Advancer<E> filter) {
            this.src = src;
            this.context = context;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            if (this.firstTime) {
                if (!this.filter.init()) {
                    this.exhausted = true;
                    return false;
                }
                this.firstTime = false;
            }
            if (this.exhausted) {
                return false;
            }
            return this.src.hasNext();
        }

        @Override
        public ITuple<E> next() {
            ITuple<E> tuple = this.src.next();
            if (log.isInfoEnabled()) {
                log.info((Object)("next: " + tuple));
            }
            this.kbuf.reset().copyAll(tuple.getKeyBuffer());
            try {
                this.filter.advance(tuple);
            }
            catch (KeyOutOfRangeException ex) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Exhausted - advanced beyond key range constraint: " + ex));
                }
                this.exhausted = true;
            }
            return tuple;
        }

        @Override
        public void remove() {
            byte[] key = this.kbuf.toByteArray();
            if (log.isInfoEnabled()) {
                log.info((Object)("key=" + BytesUtil.toString(key)));
            }
            this.src.getIndex().remove(key);
        }
    }
}

