/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.filter;

import com.bigdata.btree.AbstractTuple;
import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleCursor;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.filter.ITupleFilter;
import cutthecrap.utils.striterators.FilterBase;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public abstract class TupleFilter<E>
extends FilterBase
implements ITupleFilter<E> {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(TupleFilter.class);

    @Override
    public ITupleIterator<E> filterOnce(Iterator src, Object context) {
        return new TupleFilterator((ITupleIterator)src, context, this);
    }

    protected abstract boolean isValid(ITuple<E> var1);

    public static class TupleFilterator<E>
    implements ITupleIterator<E> {
        protected final ITupleIterator<E> src;
        protected final Object context;
        protected final TupleFilter<E> filter;
        private ITuple<E> nextValue = null;
        private final AbstractTuple<E> returnValue;

        public TupleFilterator(ITupleIterator<E> src, Object context, TupleFilter<E> filter) {
            this.src = src;
            this.context = context;
            this.filter = filter;
            this.nextValue = this.getNext();
            if (this.nextValue != null) {
                final int sourceIndex = this.nextValue.getSourceIndex();
                final ITupleSerializer tupleSer = this.nextValue.getTupleSerializer();
                this.returnValue = new AbstractTuple<E>(this.nextValue.flags()){

                    @Override
                    public int getSourceIndex() {
                        return sourceIndex;
                    }

                    @Override
                    public ITupleSerializer getTupleSerializer() {
                        return tupleSer;
                    }
                };
            } else {
                this.returnValue = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public ITuple<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.returnValue.copyTuple(this.nextValue);
            this.nextValue = this.getNext();
            if (log.isInfoEnabled()) {
                log.info((Object)("returning: " + this.returnValue));
            }
            this.visit(this.returnValue);
            return this.returnValue;
        }

        protected void visit(ITuple<E> tuple) {
        }

        @Override
        public void remove() {
            byte[] key;
            if (this.src instanceof ITupleCursor) {
                key = this.returnValue.getKey();
                if (log.isInfoEnabled()) {
                    log.info((Object)("key=" + BytesUtil.toString(key)));
                }
            } else {
                throw new UnsupportedOperationException("Source iterator does not implement " + ITupleCursor.class.getName());
            }
            ((ITupleCursor)this.src).getIndex().remove(key);
        }

        protected ITuple<E> getNext() {
            while (this.src.hasNext()) {
                ITuple<E> next = this.src.next();
                if (!this.filter.isValid(next)) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("rejected  : " + next));
                    continue;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("will visit: " + next));
                }
                return next;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Source is exhausted.");
            }
            return null;
        }
    }
}

